/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.jdk.JdkSpecificClass;
import com.jidesoft.utils.SecurityUtils;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.UIManager;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static boolean _isWindows7 = false;
    private static boolean _isWindows8 = false;
    private static boolean _isWindows2003 = false;
    private static boolean _isClassicWindows = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static boolean _isBSD = false;
    private static JavaVersion _currentVersion;

    private SystemInfo() {
    }

    public static String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static String getJavaClassVersion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static void setSupportsTray(boolean bl2) {
        _supportsTray = bl2;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isClassicWindows() {
        return _isClassicWindows;
    }

    public static boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static boolean isWindows7() {
        return _isWindows7;
    }

    public static boolean isWindows8() {
        return _isWindows8;
    }

    public static boolean isWindowsVistaAbove() {
        return _isWindowsVista || _isWindows7 || _isWindows8;
    }

    public static boolean isWindows95() {
        return _isWindows95;
    }

    public static boolean isWindows98() {
        return _isWindows98;
    }

    public static boolean isWindows2003() {
        return _isWindows2003;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isBSD() {
        return _isBSD;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris || _isBSD;
    }

    private static void checkJdkVersion() {
        if (_currentVersion == null) {
            _currentVersion = new JavaVersion(SystemInfo.getJavaVersion());
        }
    }

    public static boolean isJdk13Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.3, 0, 0) >= 0;
    }

    public static boolean isJdk142Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 2, 0) >= 0;
    }

    public static boolean isJdk14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 0, 0) >= 0;
    }

    public static boolean isJdk15Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.5, 0, 0) >= 0;
    }

    public static boolean isJdk6Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 0) >= 0;
    }

    public static boolean isJdk6u10Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 10) >= 0;
    }

    public static boolean isJdk6u14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 14) >= 0;
    }

    public static boolean isJdk6u25Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 25) >= 0;
    }

    public static boolean isJdk7Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.7, 0, 0) >= 0;
    }

    public static boolean isJdk7u40Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.7, 0, 40) >= 0;
    }

    public static boolean isJdk8Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.8, 0, 0) >= 0;
    }

    public static boolean isJdk9Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(9.0, 0, 0) >= 0;
    }

    public static boolean isJdk17Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(17.0, 0, 0) >= 0;
    }

    public static boolean isJdkVersion(double d2, int n2, int n3) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n2, n3) == 0;
    }

    public static boolean isJdkVersionAbove(double d2, int n2, int n3) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n2, n3) >= 0;
    }

    public static boolean isJdkVersionBelow(double d2, int n2, int n3) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n2, n3) <= 0;
    }

    public static boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    public static boolean isMnemonicHidden() {
        return !UIManager.getBoolean("Button.showMnemonics");
    }

    public static double getScaleFactor() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        DisplayMode displayMode = graphicsDevice.getDisplayMode();
        return (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
    }

    public static int getDisplayScale() {
        if (GraphicsEnvironment.isHeadless()) {
            return 1;
        }
        if (SystemInfo.isJdk7u40Above()) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            try {
                Field field = graphicsDevice.getClass().getDeclaredField("scale");
                if (field != null) {
                    field.setAccessible(true);
                    Object object = field.get(graphicsDevice);
                    if (object instanceof Integer) {
                        return (Integer)object;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 1;
    }

    static {
        String string = SecurityUtils.getProperty("os.name", "Windows XP");
        _isWindows = string.indexOf("Windows") != -1;
        try {
            String string2 = SecurityUtils.getProperty("os.version", "5.0");
            Float f2 = Float.valueOf(string2);
            _isClassicWindows = (double)f2.floatValue() <= 4.0;
        }
        catch (NumberFormatException numberFormatException) {
            _isClassicWindows = false;
        }
        if (string.indexOf("Windows XP") != -1 || string.indexOf("Windows NT") != -1 || string.indexOf("Windows 2000") != -1) {
            _isWindowsNTor2000 = true;
        }
        if (string.indexOf("Windows XP") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows Vista") != -1) {
            _isWindowsVista = true;
        }
        if (string.indexOf("Windows 7") != -1) {
            _isWindows7 = true;
        }
        if (string.indexOf("Windows 8") != -1) {
            _isWindows8 = true;
        }
        if (string.indexOf("Windows 2003") != -1) {
            _isWindows2003 = true;
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("Windows 98") != -1) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1;
        _isBSD = string.endsWith("BSD");
        boolean bl2 = _isLinux = string.indexOf("Linux") != -1;
        if (string.startsWith("Mac OS")) {
            if (string.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }

    public static class JavaVersion {
        private static Pattern SUN_JAVA_VERSION = Pattern.compile("(\\d+(?:\\.\\d+)?)(\\.(\\d+))?(_([^-]+))?(.*)");
        private static Pattern SUN_JAVA_VERSION_SIMPLE = Pattern.compile("(\\d+(?:\\.\\d+)?)(\\.(\\d+))?(.*)");
        private double _majorVersion;
        private int _minorVersion;
        private int _buildNumber;
        private String _patch;

        public JavaVersion(String string) {
            block13: {
                this._majorVersion = 1.4;
                this._minorVersion = 0;
                this._buildNumber = 0;
                try {
                    Matcher matcher = SUN_JAVA_VERSION.matcher(string);
                    if (matcher.matches()) {
                        String string2;
                        int n2 = matcher.groupCount();
                        this._majorVersion = Double.parseDouble(matcher.group(1));
                        if (n2 >= 3 && matcher.group(3) != null) {
                            this._minorVersion = Integer.parseInt(matcher.group(3));
                        }
                        if (n2 >= 5 && matcher.group(5) != null) {
                            try {
                                this._buildNumber = Integer.parseInt(matcher.group(5));
                            }
                            catch (NumberFormatException numberFormatException) {
                                this._patch = matcher.group(5);
                            }
                        }
                        if (n2 >= 6 && matcher.group(6) != null && (string2 = matcher.group(6)) != null && string2.trim().length() > 0) {
                            this._patch = string2;
                        }
                        break block13;
                    }
                    int[] nArray = JdkSpecificClass.getVersions();
                    if (nArray != null) {
                        this._majorVersion = nArray[0];
                        this._minorVersion = nArray[1];
                        this._buildNumber = nArray[2];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        Matcher matcher = SUN_JAVA_VERSION_SIMPLE.matcher(string);
                        if (matcher.matches()) {
                            int n3 = matcher.groupCount();
                            this._majorVersion = Double.parseDouble(matcher.group(1));
                            if (n3 >= 3 && matcher.group(3) != null) {
                                this._minorVersion = Integer.parseInt(matcher.group(3));
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException2) {
                        System.err.println("Please check the installation of your JDK. The version number " + string + " is not right.");
                    }
                }
            }
        }

        public JavaVersion(double d2, int n2, int n3) {
            this._majorVersion = d2;
            this._minorVersion = n2;
            this._buildNumber = n3;
        }

        public int compareVersion(double d2, int n2, int n3) {
            double d3 = this._majorVersion - d2;
            if (d3 != 0.0) {
                return d3 < 0.0 ? -1 : 1;
            }
            int n4 = this._minorVersion - n2;
            if (n4 != 0) {
                return n4;
            }
            return this._buildNumber - n3;
        }

        public double getMajorVersion() {
            return this._majorVersion;
        }

        public int getMinorVersion() {
            return this._minorVersion;
        }

        public int getBuildNumber() {
            return this._buildNumber;
        }

        public String getPatch() {
            return this._patch;
        }
    }
}

