package com.jprofiler.api.agent;

/**
 * An object that contains information about the current HTTP-Request.
 */
public interface HttpRequest {
    /**
     * Returns the part of this request's URL from the protocol name up to the query string in the first line
     * of the HTTP request.
     * <p>
     * This is equivalent to {@code javax.servlet.http.HttpServletRequest.getRequestURI()}.
     * </p>

     * @return a {@code String} containing the part of the URL from the protocol name up to the query string
     */
    String getRequestURI();

    /**
     * Returns the query string that is contained in the request URL after the path. This method returns {@code null}
     * if the URL does not have a query string.
     * <p>
     * This is equivalent to {@code javax.servlet.http.HttpServletRequest.getQueryString()}.
     * </p>
     *
     * @return a {@code String} containing the query string or {@code null} if the URL contains no query string.
     */
    String getQueryString();


    /**
     * Returns the request URI including the optional query string.
     *
     * @return a {@code String} containing the content of {@link #getRequestURI()}
     * optionally followed by the query string.
     */
    String getRequestString();

    /**
     *
     * Returns the name of the HTTP method with which this request was made, for example, GET, POST, or PUT.
     *
     * @return a {@code String} with the method name
     */
    String getMethod();

    /**
     *
     * Returns the value of the specified request header as a {@code String}. If the request did not include a header
     * of the specified name, this method returns {@code null}. If there are multiple headers with the same name,
     * this method returns the first header in the request.
     *
     * <p>
     * Case sensitivity is handled by the technology-specific request object.
     * </p>
     * <p>
     * This is equivalent to {@code javax.servlet.http.HttpServletRequest.getHeader()}.
     * </p>
     *
     * @param name a {@code String} specifying the header name
     *
     * @return a {@code String} containing the value of the requested header, or {@code null}
     * if the request does not have a header of that name
     *
     */
    String getHeader(String name);


    /**
     * Returns the technology-specific request object.
     *
     * @return For servlet containers, a {@code javax.servlet.http.HttpServletRequest},
     * for Netty-HTTP/1 a {@code io.netty.handler.codec.http.HttpRequest},
     * for Netty-HTTP/2 a {@code io.netty.handler.codec.http2.Http2Headers} object
     *
     */
    Object getRequestObject();
}
