/*
 * Copyright 2025 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
/**
 * <p>
 * Contains the classes for creating an injected probe.
 * </p>
 * <b>Purpose of injected probes</b>
 * <p>
 * Please read the "Probe concepts" chapter in the documentation (directory {@code $JPROFILER_HOME/doc}) for
 * an overview on the different types of custom probes in JProfiler and the "Injected probes" chapter
 * for an extended discussion of injected probes.
 * </p>
 * <p>
 * Injected probes allow you to add functionality similar to the built-in probes in JProfiler. In contrast to
 * the "embedded" probe API, the "injected" probe API monitors software components whose source code is not under your control.
 * If you develop software like a container or a database driver and want to make JProfiler aware of its high-level semantics,
 * use the embedded probe API instead.
 * </p>
 * <b>Getting started</b>
 * <p>To define an injected probe, annotate a class with {@link com.jprofiler.api.probe.injected.Probe}. Such a probe class can
 * contain public static methods annotated with
 * {@link com.jprofiler.api.probe.injected.interception.Interception}, {@link com.jprofiler.api.probe.injected.interception.PayloadInterception},
 * {@link com.jprofiler.api.probe.injected.interception.SplitInterception}, {@link com.jprofiler.api.probe.injected.interception.AdditionalInterception},
 * {@link com.jprofiler.api.probe.injected.ControlObjectName} and {@link com.jprofiler.api.probe.injected.telemetry.Telemetry}.
 * </p>
 * <p>
 * To get started with writing injected probes, have a look at the {@code $JPROFILER_HOME/api/samples/simple-injected-probe}
 * example project. Open the gradle build file {@code build.gradle} in an editor for instructions on how to run it.
 * </p>
 * <b>JAR file and dependency</b>
 * <p>
 * All classes in this package are contained in {@code $JPROFILER_HOME/api/jprofiler-probe-injected.jar}.
 * The injected probe API is also available as a dependency. In the snippets below, "VERSION"
 * should be replaced with the corresponding JProfiler version.
 * </p>
 * <b>Maven</b>
 * <pre>{@code
 * <dependency>
 *   <groupId>com.jprofiler</groupId>
 *   <artifactId>jprofiler-probe-injected</artifactId>
 *   <version>VERSION</version>
 * </dependency>
 * }</pre>
 * <b>Gradle</b>
 * <pre>{@code
 * dependencies {
 *   classpath group: 'com.jprofiler', name: 'jprofiler-probe-injected', version: 'VERSION'
 * }
 * }</pre>
 * <b>Deployment</b>
 * <p>
 * To load injected custom probes, pass
 * </p>
 * <pre>{@code
 *      -Djprofiler.probeClassPath=...
 * }</pre>
 * to the profiled JVM. The probe classpath can contain directories and class files, separated with the path separator
 * (';' for Windows and ':' for other platforms). Note that the custom probe classes must not be on the class path.
 * The profiling agent will scan the probe classpath and find all probe definitions.
 * <p>
 *  Alternatively, you can set
 * </p>
 * <pre>{@code
 *      -Djprofiler.customProbes=...
 * }</pre>
 * to a comma-separated list of fully qualified class names that will be loaded from the class path.
 * <br><br>
 * <b>License</b>
 * <p>
 * Classes in this package and its sub-packages are licensed under the Apache License, version 2.0.
 * </p>
 */
package com.jprofiler.api.probe.injected;
