/*
 * Copyright 2025 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.interception;

/**
 * Specification of the intercepted method.
 */
public @interface MethodSpec {
    /**
     * The fully qualified name of the highest type in the class hierarchy where the method is implemented. Can be an empty string if you would like to instrument all methods
     * with the given name and signature. Packages are separated with dots, inner classes with '$'.
     * @return the class name
     */
    String className();

    /**
     * The name of the method. If you would like to instrument a constructor, use {@code <init>}.
     * @return the method name
     */
    String methodName();

    /**
     * The array of all parameter types that the method declares. The types must be fully qualified. Packages are separated with dots, inner classes with '$'.
     * Arrays are specified with a trailing '[]'.
     * Generic types must be erased ({@code java.util.List<T>} -> {@code java.util.List}).
     * Type parameters must be replaced by their upper bounds ({@code java.lang.Object} for {@code <T>}, ({@code java.util.List} for {@code <T extends List<U>>}.
     * @return the array of the declared types of all parameters
     */
    String[] parameterTypes();

    /**
     * The return type that the method declares. The type must be fully qualified. Packages are separated with dots, inner classes with '$'.
     * Arrays are specified with a trailing '[]'.
     * Generic types must be erased ({@code java.util.List<T>} -> {@code java.util.List}).
     * Type parameters must be replaced by their upper bounds ({@code java.lang.Object} for {@code <T>}, ({@code java.util.List} for {@code <T extends List<U>>}.
     * @return the return type
     */
    String returnType();

    /**
     * If {@code false}, only the method contained in {@link #className()} will be instrumented, but not in derived classes.
     * If {@code true}, the matching methods in {@link #className()} and all its subtypes will be instrumented.
     * @return if methods from subtypes should be instrumented, too
     */
    boolean subtypes() default false;
}
