/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent;

import com.jprofiler.agent.Agent;
import com.jprofiler.agent.NativeAgentMethods;
import com.jprofiler.agent.ProbeThreadManager;
import com.jprofiler.agent.e;
import com.jprofiler.agent.probe.CallSite;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.probe.d;
import com.jprofiler.agent.probe.d.b;
import com.jprofiler.agent.probe.g.c;
import com.jprofiler.agent.probe.l;
import com.jprofiler.agent.probe.payload.BasePayloadInfo;
import com.jprofiler.agent.probe.structures.h;
import com.jprofiler.agent.probe.structures.j;
import com.jprofiler.agent.probe.structures.n;
import com.jprofiler.agent.util.a.b.y;
import com.jprofiler.agent.util.ad;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class JProfilerThreadManager
implements ProbeThreadManager {
    public static final int NO_STACK_CALL_TREE_ID = 2147483547;
    private static final long MAIN_VIRTUAL_AGGREGATOR_THREAD_ID = -1L;
    private static final long FIRST_DEFERRED_MASK = 0x100000000L;
    private static ThreadLocal<JProfilerThreadManager> threadManagerLocal = e.a().b(() -> null);
    public final long threadManagerPointer;
    public final boolean recordedStart;
    public short lineNumberHint;

    public static JProfilerThreadManager getJProfilerThreadManager() {
        JProfilerThreadManager jProfilerThreadManager = threadManagerLocal.get();
        if (jProfilerThreadManager == null) {
            jProfilerThreadManager = Native.getCurrentJProfilerThreadManager(Thread.currentThread());
            if (jProfilerThreadManager != null) {
                threadManagerLocal.set(jProfilerThreadManager);
            } else {
                jProfilerThreadManager = Platform.INITIAL_THREAD_MANAGER;
            }
        }
        return jProfilerThreadManager;
    }

    public static JProfilerThreadManager getJProfilerVirtualThreadManager(boolean bl2) {
        JProfilerThreadManager jProfilerThreadManager = threadManagerLocal.get();
        if (jProfilerThreadManager == null) {
            long l2;
            Thread thread = Thread.currentThread();
            long l3 = Native.getCurrentJProfilerVirtualThreadManager(thread, l2 = ad.a(thread), bl2);
            if (l3 != 0L) {
                jProfilerThreadManager = Native.create(true, bl2, l3, l2);
                threadManagerLocal.set(jProfilerThreadManager);
            } else {
                jProfilerThreadManager = Virtual.INITIAL_THREAD_MANAGER;
            }
        }
        return jProfilerThreadManager;
    }

    private JProfilerThreadManager(long l2, boolean bl2) {
        this.threadManagerPointer = l2;
        this.recordedStart = bl2;
    }

    public abstract void setCarrierAggregator(JProfilerThreadManager var1);

    public abstract void addEvent(c var1, b var2, int var3);

    protected abstract CallSite getCachedCallSite();

    protected abstract long getThreadId();

    protected abstract long[] getPayloadData();

    @Override
    public CallSite enterCallSite(String string, String string2, boolean bl2) {
        int n2 = ProbeHandler.Native.getCallSiteId(this.threadManagerPointer, true, true, false, false, false);
        if (n2 == 0) {
            return null;
        }
        CallSite callSite = this.getCachedCallSite();
        callSite.init(n2, 0L);
        return callSite;
    }

    @Override
    public void exitCallSite() {
    }

    public void fillTiming(BasePayloadInfo basePayloadInfo) {
        this.fillTiming(basePayloadInfo, false);
    }

    public void fillTiming(BasePayloadInfo basePayloadInfo, boolean bl2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.Native.fillPayloadInfo0(lArray, 0, false, this.threadManagerPointer, bl2, false);
        basePayloadInfo.copyData(lArray);
    }

    public void fillTimingAndId(BasePayloadInfo basePayloadInfo, int n2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.Native.fillPayloadInfo0(lArray, n2, true, this.threadManagerPointer, false, false);
        basePayloadInfo.copyData(lArray);
    }

    public void fillTimingAndIdSpecial(BasePayloadInfo basePayloadInfo, int n2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.Native.fillPayloadInfoSpecial(lArray, this.threadManagerPointer, false, n2);
        basePayloadInfo.copyData(lArray);
    }

    public void fillAsyncNoStack(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setCallTreeId(2147483547);
        basePayloadInfo.setThreadId(this.getThreadId());
        basePayloadInfo.setTimeStampMicro(Agent.getCounter());
        basePayloadInfo.setDeferred();
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    @Override
    public void fillAsync(BasePayloadInfo basePayloadInfo, int n2) {
        long[] lArray = this.getPayloadData();
        ProbeHandler.Native.fillPayloadInfo0(lArray, n2, true, this.threadManagerPointer, false, true);
        basePayloadInfo.copyData(lArray);
        basePayloadInfo.setDeferred();
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    @Override
    public void fillAsync(d d2, BasePayloadInfo basePayloadInfo, int n2) {
        if (d2 == null || d2.b() == 0L) {
            this.fillAsync(basePayloadInfo, n2);
        } else {
            basePayloadInfo.copyData(d2);
            basePayloadInfo.setDeferred();
            basePayloadInfo.setBlockedMicro(System.nanoTime());
        }
    }

    @Override
    public d createDeferredAsyncSite(boolean bl2, boolean bl3, int n2) {
        long[] lArray = this.getPayloadData();
        if (bl3) {
            long l2 = ProbeHandler.Native.getDeferredAsyncSite0(lArray, bl2, n2, this.threadManagerPointer);
            int n3 = (int)l2;
            long l3 = lArray[1];
            if (n3 == 0 && l3 == 0L) {
                return null;
            }
            if ((l2 & 0x100000000L) != 0L) {
                return new d.a(n3, (int)lArray[0], l3, lArray[6]);
            }
            return new d(n3, (int)lArray[0], l3, lArray[6]);
        }
        long l4 = ProbeHandler.Native.getDeferredAsyncSite0(null, bl2, 0, this.threadManagerPointer);
        int n4 = (int)l4;
        if (n4 == 0) {
            return null;
        }
        if ((l4 & 0x100000000L) != 0L) {
            return new d.a(n4, 0, 0L, 0L);
        }
        return new d(n4, 0, 0L, 0L);
    }

    @Override
    public boolean isRecordedStart() {
        return this.recordedStart;
    }

    @Override
    public d createAsyncSite(boolean bl2, boolean bl3, int n2) {
        if (bl3) {
            long[] lArray = this.getPayloadData();
            int n3 = ProbeHandler.Native.getAsyncSite0(lArray, bl2, n2, this.threadManagerPointer);
            long l2 = lArray[1];
            if (n3 == 0 && l2 == 0L) {
                return null;
            }
            return new d(n3, (int)lArray[0], l2, lArray[6]);
        }
        int n4 = ProbeHandler.Native.getAsyncSite0(null, bl2, 0, this.threadManagerPointer);
        if (n4 == 0) {
            return null;
        }
        return new d(n4, 0, 0L, 0L);
    }

    public static void restartAsyncTime(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setBlockedMicro(System.nanoTime());
    }

    public static void calculateAsyncTime(BasePayloadInfo basePayloadInfo) {
        basePayloadInfo.setWaitingMicro((System.nanoTime() - basePayloadInfo.getBlockedMicro()) / 1000L + basePayloadInfo.getWaitingMicro());
        basePayloadInfo.setBlockedMicro(0L);
        basePayloadInfo.setRunnableMicro(0L);
        basePayloadInfo.setNetioMicro(0L);
    }

    @Override
    public long enterInterceptionMethod(String string, int n2, boolean bl2) {
        long l2 = ProbeHandler.getInterceptionMethodId(string, n2);
        this.enterSpecialMethod(l2, n2, true, bl2);
        return l2;
    }

    @Override
    public long enterInterceptionMethod(String string, int n2, boolean bl2, boolean bl3) {
        long l2 = ProbeHandler.getInterceptionMethodId(string, n2);
        this.enterSpecialMethod(l2, n2, bl3, bl2);
        return l2;
    }

    @Override
    public long enterInterceptionMethod(int n2, String string, int n3, boolean bl2) {
        long l2 = ProbeHandler.getLocalCallSiteMethodId(n2, string, n3);
        this.enterSpecialMethod(l2, n3, true, bl2);
        return l2;
    }

    private static boolean isTrackingType(int n2) {
        return n2 >= 3 && n2 <= 11;
    }

    public void enterSpecialMethod(long l2, int n2, boolean bl2, boolean bl3) {
        if (l2 != 0L) {
            if (JProfilerThreadManager.isTrackingType(n2)) {
                this.getAndResetLineNumberHint();
            }
            ProbeHandler.Native.enterInterceptionMethod0(l2, n2, this.threadManagerPointer, bl2, bl3);
        }
    }

    public void enterPayloadSpecialMethod(long l2, int n2, BasePayloadInfo basePayloadInfo) {
        if (l2 != 0L) {
            long[] lArray = this.getPayloadData();
            ProbeHandler.Native.enterPayloadInterceptionMethod0(l2, n2, this.threadManagerPointer, lArray);
            basePayloadInfo.copyData(lArray);
        }
    }

    @Override
    public long enterInterceptionMethod(n n2, int n3, boolean bl2) {
        return this.enterInterceptionMethod(n2.b(), n3, bl2);
    }

    @Override
    public long enterInterceptionMethod(n n2, int n3, boolean bl2, boolean bl3) {
        long l2 = ProbeHandler.getInterceptionMethodId(n2.b(), n3);
        this.enterSpecialMethod(l2, n3, bl3, bl2);
        return l2;
    }

    public void exitPayloadInterceptionMethod(long l2, BasePayloadInfo basePayloadInfo) {
        if (l2 != Long.MAX_VALUE) {
            long[] lArray = this.getPayloadData();
            ProbeHandler.Native.exitPayloadInterceptionMethod0(l2, this.threadManagerPointer, lArray);
            basePayloadInfo.calcDifference(lArray);
        }
    }

    @Override
    public boolean exitInterceptionMethod(long l2, Object object) {
        if (l2 != Long.MAX_VALUE) {
            ProbeHandler.Native.exitInterceptionMethod0(l2, this.threadManagerPointer);
        }
        return object != null;
    }

    @Override
    public boolean exitInterceptionMethod(long l2, Object object, boolean bl2) {
        if (l2 != Long.MAX_VALUE) {
            ProbeHandler.Native.exitInterceptionMethod1(l2, this.threadManagerPointer, bl2);
        }
        return object != null;
    }

    public short getAndResetLineNumberHint() {
        short s2 = this.lineNumberHint;
        this.lineNumberHint = 0;
        return s2;
    }

    static class Native {
        Native() {
        }

        static native JProfilerThreadManager getCurrentJProfilerThreadManager(Thread var0);

        static native long getCurrentJProfilerVirtualThreadManager(Thread var0, long var1, boolean var3);

        public static JProfilerThreadManager create(boolean bl2, boolean bl3, long l2, long l3) {
            if (bl2) {
                return new Virtual(l2, bl3);
            }
            return new Platform(l2, bl3, l3);
        }

        static {
            try {
                NativeAgentMethods.register(Native.class, 30);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static final class Virtual
    extends JProfilerThreadManager {
        private static final Virtual INITIAL_THREAD_MANAGER = new Virtual(0L, true);
        private JProfilerThreadManager carrierAggregator;

        public Virtual(long l2, boolean bl2) {
            super(l2, bl2);
        }

        @Override
        protected long getThreadId() {
            return -1L;
        }

        @Override
        protected long[] getPayloadData() {
            JProfilerThreadManager jProfilerThreadManager = this.carrierAggregator;
            if (jProfilerThreadManager != null) {
                return jProfilerThreadManager.getPayloadData();
            }
            return new long[7];
        }

        @Override
        public long getCarrierAggregatorThreadId() {
            JProfilerThreadManager jProfilerThreadManager = this.carrierAggregator;
            if (jProfilerThreadManager != null) {
                return jProfilerThreadManager.getThreadId();
            }
            return -1L;
        }

        @Override
        protected CallSite getCachedCallSite() {
            JProfilerThreadManager jProfilerThreadManager = this.carrierAggregator;
            if (jProfilerThreadManager != null) {
                return jProfilerThreadManager.getCachedCallSite();
            }
            return new CallSite();
        }

        @Override
        public void setCarrierAggregator(JProfilerThreadManager jProfilerThreadManager) {
            this.carrierAggregator = jProfilerThreadManager;
        }

        @Override
        public void addEvent(c c2, b b2, int n2) {
            JProfilerThreadManager jProfilerThreadManager = this.carrierAggregator;
            if (jProfilerThreadManager != null) {
                jProfilerThreadManager.addEvent(c2, b2, n2);
            }
        }
    }

    public static final class Platform
    extends JProfilerThreadManager {
        private static final Platform INITIAL_THREAD_MANAGER = new Platform(0L, true, 0L);
        private final long threadId;
        private long[] payloadData;
        private CallSite cachedCallSite;
        private Map<c, j> eventCollections;

        public Platform(long l2, boolean bl2, long l3) {
            super(l2, bl2);
            this.threadId = l3;
        }

        @Override
        public long getCarrierAggregatorThreadId() {
            return this.threadId;
        }

        @Override
        protected long getThreadId() {
            return this.threadId;
        }

        @Override
        protected CallSite getCachedCallSite() {
            CallSite callSite = this.cachedCallSite;
            if (callSite == null) {
                this.cachedCallSite = callSite = new CallSite();
            }
            return callSite;
        }

        @Override
        protected long[] getPayloadData() {
            if (this.payloadData == null) {
                this.payloadData = new long[7];
            }
            return this.payloadData;
        }

        @Override
        public void setCarrierAggregator(JProfilerThreadManager jProfilerThreadManager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public j removeEvents(c c2) {
            j j2 = null;
            Platform platform = this;
            synchronized (platform) {
                if (this.eventCollections != null && !this.eventCollections.isEmpty()) {
                    j2 = this.eventCollections.remove(c2);
                }
            }
            return j2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public j getAndResetEvents(c c2) {
            Platform platform = this;
            synchronized (platform) {
                if (this.eventCollections != null) {
                    return this.eventCollections.remove(c2);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long writeEventObjects(c c2, h h2, byte[] byArray, c.a a2, DataOutputStream dataOutputStream, y<l> y2) throws IOException {
            Platform platform = this;
            synchronized (platform) {
                j j2;
                if (this.eventCollections != null && (j2 = this.eventCollections.get(c2)) != null) {
                    return c2.a(j2, h2, byArray, a2, dataOutputStream, y2);
                }
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetEvents() {
            Platform platform = this;
            synchronized (platform) {
                if (this.eventCollections != null) {
                    this.eventCollections.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addEvent(c c2, b b2, int n2) {
            Platform platform = this;
            synchronized (platform) {
                j j2;
                if (this.eventCollections == null) {
                    this.eventCollections = new HashMap<c, j>();
                }
                if ((j2 = this.eventCollections.get(c2)) == null) {
                    j2 = new j(n2);
                    this.eventCollections.put(c2, j2);
                }
                j2.a(b2);
            }
        }
    }
}

