/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.process.internal;

import io.matthewnelson.kmp.file.KmpFile;
import io.matthewnelson.kmp.process.Signal;
import io.matthewnelson.kmp.process.Stdio;
import io.matthewnelson.kmp.process.internal._JvmPlatformKt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u001a\u001d\u0010\u0006\u001a\u00020\u0001*\u00060\u0007j\u0002`\b2\n\u0010\t\u001a\u00060\u0007j\u0002`\bH\u0080\b\u001a^\u0010\n\u001a\u00020\u000b*\u00060\fj\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\u000e\u0010\u0016\u001a\n\u0018\u00010\u0007j\u0004\u0018\u0001`\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0000\u001a\u001c\u0010\u001b\u001a\u00020\u000b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0000\u001a\u001d\u0010\u001b\u001a\u00020\u000b*\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0011H\u0080\b\"\u001b\u0010\u0000\u001a\u00020\u00018\u00c0\u0002X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001f"}, d2={"IsWindows", "", "getIsWindows$annotations", "()V", "getIsWindows", "()Z", "isCanonicallyEqualTo", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "other", "appendProcessInfo", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "className", "", "pid", "", "exitCode", "command", "args", "", "cwd", "stdio", "Lio/matthewnelson/kmp/process/Stdio$Config;", "destroySignal", "Lio/matthewnelson/kmp/process/Signal;", "checkBounds", "", "offset", "len", "io.matthewnelson.kmp-process_process_jvm"})
@SourceDebugExtension(value={"SMAP\n-CommonPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -CommonPlatform.kt\nio/matthewnelson/kmp/process/internal/_CommonPlatformKt\n+ 2 KmpFile.kt\nio/matthewnelson/kmp/file/KmpFile\n*L\n1#1,106:1\n102#1,4:108\n129#2:107\n*S KotlinDebug\n*F\n+ 1 -CommonPlatform.kt\nio/matthewnelson/kmp/process/internal/_CommonPlatformKt\n*L\n96#1:108,4\n36#1:107\n*E\n"})
public final class _CommonPlatformKt {
    public static final boolean getIsWindows() {
        boolean $i$f$getIsWindows = false;
        return Intrinsics.areEqual((Object)_JvmPlatformKt.getSTDIO_NULL().getPath(), (Object)"NUL");
    }

    public static /* synthetic */ void getIsWindows$annotations() {
    }

    public static final boolean isCanonicallyEqualTo(@NotNull File $this$isCanonicallyEqualTo, @NotNull File other) {
        File $this$canonicalFile$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isCanonicallyEqualTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean $i$f$isCanonicallyEqualTo = false;
        if (Intrinsics.areEqual((Object)$this$isCanonicallyEqualTo, (Object)other)) {
            return true;
        }
        try {
            $this$canonicalFile$iv = $this$isCanonicallyEqualTo;
            boolean $i$f$canonicalFileOf = false;
            File file = $this$canonicalFile$iv.getCanonicalFile();
            $this$canonicalFile$iv = other;
            $i$f$canonicalFileOf = false;
            $this$canonicalFile$iv = TuplesKt.to((Object)file, (Object)$this$canonicalFile$iv.getCanonicalFile());
        }
        catch (IOException iOException) {
            File file = $this$isCanonicallyEqualTo.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAbsoluteFile(...)");
            File file2 = KmpFile.normalizedFileOf((File)file);
            File file3 = other.getAbsoluteFile();
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getAbsoluteFile(...)");
            $this$canonicalFile$iv = TuplesKt.to((Object)file2, (Object)KmpFile.normalizedFileOf((File)file3));
        }
        File file = $this$canonicalFile$iv;
        File thisFile = (File)file.component1();
        File otherFile = (File)file.component2();
        return Intrinsics.areEqual((Object)thisFile, (Object)otherFile);
    }

    public static final void appendProcessInfo(@NotNull StringBuilder $this$appendProcessInfo, @NotNull String className, int pid, @NotNull String exitCode, @NotNull String command, @NotNull List<String> args, @Nullable File cwd, @NotNull Stdio.Config stdio, @NotNull Signal destroySignal) {
        Intrinsics.checkNotNullParameter((Object)$this$appendProcessInfo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)exitCode, (String)"exitCode");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)stdio, (String)"stdio");
        Intrinsics.checkNotNullParameter((Object)((Object)destroySignal), (String)"destroySignal");
        $this$appendProcessInfo.append(className);
        $this$appendProcessInfo.append(": [").append('\n');
        $this$appendProcessInfo.append("    pid: ");
        StringBuilder stringBuilder = $this$appendProcessInfo.append(pid);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(...)");
        stringBuilder.append('\n');
        $this$appendProcessInfo.append("    exitCode: ");
        $this$appendProcessInfo.append(exitCode).append('\n');
        $this$appendProcessInfo.append("    command: ");
        $this$appendProcessInfo.append(command).append('\n');
        $this$appendProcessInfo.append("    args: [");
        StringBuilder stringBuilder2 = args.isEmpty() ? $this$appendProcessInfo.append(']').append('\n') : (StringBuilder)CollectionsKt.joinTo$default((Iterable)args, (Appendable)$this$appendProcessInfo, (CharSequence)"\n        ", (CharSequence)"\n        ", (CharSequence)"\n    ]\n", (int)0, null, null, (int)112, null);
        $this$appendProcessInfo.append("    cwd: ");
        StringBuilder stringBuilder3 = $this$appendProcessInfo;
        Object object = cwd;
        if (object == null || (object = ((File)object).getPath()) == null) {
            object = "";
        }
        stringBuilder3.append((String)object).append('\n');
        $this$appendProcessInfo.append("    stdio: [").append('\n');
        List lines = StringsKt.lines((CharSequence)stdio.toString());
        boolean bl = false;
        int n = lines.size();
        for (int i = 1; i < n; ++i) {
            $this$appendProcessInfo.append("    ");
            $this$appendProcessInfo.append((String)lines.get(i)).append('\n');
        }
        $this$appendProcessInfo.append("    destroySignal: ");
        $this$appendProcessInfo.append((Object)destroySignal).append('\n');
        $this$appendProcessInfo.append(']');
    }

    public static final void checkBounds(@NotNull byte[] $this$checkBounds, int offset, int len) throws IllegalArgumentException, IndexOutOfBoundsException {
        Intrinsics.checkNotNullParameter((Object)$this$checkBounds, (String)"<this>");
        int $this$checkBounds$iv = $this$checkBounds.length;
        boolean $i$f$checkBounds = false;
        int size$iv = $this$checkBounds$iv;
        if (size$iv - offset < len) {
            throw new IllegalArgumentException("Input too short");
        }
        if (offset < 0 || len < 0 || offset > size$iv - len) {
            throw new IndexOutOfBoundsException();
        }
    }

    public static final void checkBounds(int $this$checkBounds, int offset, int len) throws IllegalArgumentException, IndexOutOfBoundsException {
        boolean $i$f$checkBounds = false;
        int size = $this$checkBounds;
        if (size - offset < len) {
            throw new IllegalArgumentException("Input too short");
        }
        if (offset < 0 || len < 0 || offset > size - len) {
            throw new IndexOutOfBoundsException();
        }
    }
}

