/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.process.internal;

import io.matthewnelson.kmp.process.AsyncWriteStream;
import io.matthewnelson.kmp.process.Output;
import io.matthewnelson.kmp.process.OutputFeed;
import io.matthewnelson.kmp.process.Process;
import io.matthewnelson.kmp.process.ProcessException;
import io.matthewnelson.kmp.process.ReadBuffer;
import io.matthewnelson.kmp.process.Signal;
import io.matthewnelson.kmp.process.Stdio;
import io.matthewnelson.kmp.process.internal.OutputFeedBuffer;
import io.matthewnelson.kmp.process.internal.PlatformBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\\\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\u001a^\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u000e\u0010\u0007\u001a\n\u0018\u00010\bj\u0004\u0018\u0001`\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a:\u0010\u0012\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152#\u0010\u0016\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\u0010\u001b\u001aB\u0010\u0012\u001a\u00020\u0013*\u00060\u0014j\u0002`\u00152\u0006\u0010\u001c\u001a\u00020\u001d2#\u0010\u0016\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0018\u0012\b\b\u0019\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u00020\u00130\u0017H\u0000\u00a2\u0006\u0002\u0010\u001e\u00a8\u0006\u001f"}, d2={"blockingOutput", "Lio/matthewnelson/kmp/process/Output;", "Lio/matthewnelson/kmp/process/internal/PlatformBuilder;", "command", "", "args", "", "chdir", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "env", "", "stdio", "Lio/matthewnelson/kmp/process/Stdio$Config;", "options", "Lio/matthewnelson/kmp/process/Output$Options;", "destroy", "Lio/matthewnelson/kmp/process/Signal;", "scanLines", "", "Ljava/io/InputStream;", "Lio/matthewnelson/kmp/process/internal/ReadStream;", "dispatch", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "line", "(Ljava/io/InputStream;Lkotlin/jvm/functions/Function1;)V", "bufferSize", "", "(Ljava/io/InputStream;ILkotlin/jvm/functions/Function1;)V", "io.matthewnelson.kmp-process_process_jvm"})
@SourceDebugExtension(value={"SMAP\n-BlockingPlatform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -BlockingPlatform.kt\nio/matthewnelson/kmp/process/internal/_BlockingPlatformKt\n+ 2 -JvmPlatform.kt\nio/matthewnelson/kmp/process/internal/_JvmPlatformKt\n+ 3 -CommonProcess.kt\nio/matthewnelson/kmp/process/internal/_CommonProcessKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n35#2,2:177\n35#2,2:193\n40#3,14:179\n56#3,4:195\n1#4:199\n*S KotlinDebug\n*F\n+ 1 -BlockingPlatform.kt\nio/matthewnelson/kmp/process/internal/_BlockingPlatformKt\n*L\n78#1:177,2\n88#1:193,2\n83#1:179,14\n83#1:195,4\n*E\n"})
public final class _BlockingPlatformKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public static final Output blockingOutput(@NotNull PlatformBuilder $this$blockingOutput, @NotNull String command, @NotNull List<String> args, @Nullable File chdir, @NotNull Map<String, String> env, @NotNull Stdio.Config stdio, @NotNull Output.Options options, @NotNull Signal destroy) throws IOException {
        int timeout$iv2;
        Process process;
        Intrinsics.checkNotNullParameter((Object)$this$blockingOutput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)stdio, (String)"stdio");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)((Object)destroy), (String)"destroy");
        try {
            process = $this$blockingOutput.spawn$io_matthewnelson_kmp_process_process_jvm(command, args, chdir, env, stdio, destroy, ProcessException.Handler.IGNORE);
        }
        catch (IOException e) {
            options.dropInput$io_matthewnelson_kmp_process_process_jvm();
            throw e;
        }
        Process p = process;
        OutputFeedBuffer stdoutBuffer = OutputFeedBuffer.Companion.of$io_matthewnelson_kmp_process_process_jvm(options);
        OutputFeedBuffer stderrBuffer = OutputFeedBuffer.Companion.of$io_matthewnelson_kmp_process_process_jvm(options);
        Integer waitForCode = null;
        try {
            void $this$commonWaitFor_u2d8Mi8wO0$iv;
            Integer code$iv;
            Integer n;
            p.stdoutFeed((OutputFeed)stdoutBuffer);
            p.stderrFeed((OutputFeed)stderrBuffer);
            byte[] byArray = options.consumeInput$io_matthewnelson_kmp_process_process_jvm();
            if (byArray != null) {
                byte[] bytes = byArray;
                boolean bl = false;
                try {
                    AsyncWriteStream asyncWriteStream = p.input;
                    if (asyncWriteStream == null) {
                        throw new IOException("Misconfigured Stdio.Config. stdin should be Stdio.Pipe");
                    }
                    asyncWriteStream.write(bytes);
                    p.input.close();
                }
                finally {
                    ArraysKt.fill$default((byte[])bytes, (byte)0, (int)0, (int)0, (int)6, null);
                }
            }
            try {
                void $this$threadSleep_u2dLRDsOJo$iv;
                long l = DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS);
                boolean bl = false;
                Thread.sleep(Duration.getInWholeMilliseconds-impl((long)$this$threadSleep_u2dLRDsOJo$iv));
            }
            catch (InterruptedException $this$threadSleep_u2dLRDsOJo$iv) {
                // empty catch block
            }
            Process $this$threadSleep_u2dLRDsOJo$iv = p;
            long timeout$iv2 = Duration.minus-LRDsOJo((long)options.getTimeout-UwyO8pc$io_matthewnelson_kmp_process_process_jvm(), (long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.MILLISECONDS));
            boolean bl = false;
            long startMark$iv = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
            long remainingNanos$iv = Duration.getInWholeNanoseconds-impl((long)timeout$iv2);
            while ((n = (code$iv = $this$commonWaitFor_u2d8Mi8wO0$iv.exitCodeOrNull())) == null) {
                if (remainingNanos$iv > 0L) {
                    long millis$iv;
                    double d = Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((long)remainingNanos$iv, (DurationUnit)DurationUnit.NANOSECONDS)) + 1L;
                    double d2 = 100.0;
                    long millis = millis$iv = DurationKt.toDuration((long)((long)Math.min(d, d2)), (DurationUnit)DurationUnit.MILLISECONDS);
                    boolean bl2 = false;
                    if (stdoutBuffer.maxSizeExceeded() || stderrBuffer.maxSizeExceeded()) {
                        throw new IllegalStateException();
                    }
                    long $this$threadSleep_u2dLRDsOJo$iv2 = millis;
                    boolean bl3 = false;
                    Thread.sleep(Duration.getInWholeMilliseconds-impl((long)$this$threadSleep_u2dLRDsOJo$iv2));
                }
                if ((remainingNanos$iv = Duration.getInWholeNanoseconds-impl((long)Duration.minus-LRDsOJo((long)timeout$iv2, (long)TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)startMark$iv)))) > 0L) continue;
                n = null;
                break;
            }
            waitForCode = n;
        }
        catch (IllegalStateException $this$commonWaitFor_u2d8Mi8wO0$iv) {
        }
        catch (InterruptedException e) {
            throw new IOException("Underlying thread interrupted", e);
        }
        finally {
            p.destroy();
        }
        try {
            timeout$iv2 = p.stdoutWaiter().awaitStop().stderrWaiter().awaitStop().waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException("Underlying thread interrupted", e);
        }
        int exitCode = timeout$iv2;
        String pErr = stdoutBuffer.maxSizeExceeded() || stderrBuffer.maxSizeExceeded() ? "maxBuffer[" + options.getMaxBuffer$io_matthewnelson_kmp_process_process_jvm() + "] exceeded" : (waitForCode == null ? "waitFor timed out" : null);
        String stdout = stdoutBuffer.doFinal$io_matthewnelson_kmp_process_process_jvm();
        String stderr = stderrBuffer.doFinal$io_matthewnelson_kmp_process_process_jvm();
        return Output.ProcessInfo.Companion.createOutput$io_matthewnelson_kmp_process_process_jvm(stdout, stderr, pErr, p.pid(), exitCode, p.command, p.args, p.cwd, p.environment, p.stdio, p.destroySignal);
    }

    public static final void scanLines(@NotNull InputStream $this$scanLines, @NotNull Function1<? super String, Unit> dispatch) {
        Intrinsics.checkNotNullParameter((Object)$this$scanLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(dispatch, (String)"dispatch");
        _BlockingPlatformKt.scanLines($this$scanLines, 8192, dispatch);
    }

    public static final void scanLines(@NotNull InputStream $this$scanLines, int bufferSize, @NotNull Function1<? super String, Unit> dispatch) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)$this$scanLines, (String)"<this>");
        Intrinsics.checkNotNullParameter(dispatch, (String)"dispatch");
        InputStream stream = $this$scanLines;
        Object buf = ReadBuffer.Companion.of-Armsq0Q(new byte[bufferSize]);
        ReadBuffer.LineOutputFeed feed = ReadBuffer.Companion.lineOutputFeed(dispatch);
        Throwable threw = null;
        while (true) {
            int n;
            try {
                n = stream.read(ReadBuffer.getBuf-impl(buf));
            }
            catch (IOException iOException) {
                break;
            }
            int read = n;
            if (read <= 0) break;
            try {
                feed.onData-zry8YOI(buf, read);
            }
            catch (Throwable t) {
                threw = t;
                break;
            }
        }
        ArraysKt.fill$default((byte[])ReadBuffer.getBuf-impl(buf), (byte)0, (int)0, (int)0, (int)6, null);
        Throwable throwable = threw;
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw it;
        }
        feed.close();
    }
}

