/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.openjdk.jmc.common.IMCThread;
import org.openjdk.jmc.common.IMCThreadGroup;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.ThreadGroup;
import org.openjdk.jmc.flightrecorder.messages.internal.Messages;

final class JfrThread
implements IMCThread {
    private final int m_platformId;
    private volatile String m_name;
    private volatile ThreadGroup m_threadGroup;
    private volatile Long m_javaId;

    public JfrThread(int platformId) {
        this.m_platformId = platformId;
    }

    public Long getJavaId() {
        return this.m_javaId;
    }

    public synchronized void addJavaId(long javaId) {
        this.m_javaId = JfrThread.getAny(this.m_javaId, javaId);
    }

    public String getName() {
        return this.m_name;
    }

    public synchronized void addName(String name) {
        this.m_name = JfrThread.getAny(this.m_name, name);
    }

    public int getPlatformId() {
        return this.m_platformId;
    }

    public String toString() {
        return this.getThreadName();
    }

    public Long getThreadId() {
        return this.getJavaId();
    }

    public String getThreadName() {
        return this.m_name == null ? Messages.getString("JfrThread_UNKNOWN_THREAD_NAME") : this.m_name;
    }

    public IMCThreadGroup getThreadGroup() {
        return this.m_threadGroup;
    }

    public boolean isVirtual() {
        return false;
    }

    public synchronized void addThreadGroup(ThreadGroup group) {
        this.m_threadGroup = JfrThread.getAny(this.m_threadGroup, group);
    }

    public int hashCode() {
        return this.m_platformId;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof JfrThread && this.m_platformId == ((JfrThread)obj).m_platformId;
    }

    private static <T extends Comparable<T>> T getAny(T a, T b) {
        if (a == null || b != null && a.compareTo(b) < 0) {
            return b;
        }
        return a;
    }
}

