/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent;

import com.jprofiler.agent.Agent;
import com.jprofiler.agent.AgentEnvironment;
import com.jprofiler.agent.JProfilerThreadManager;
import com.jprofiler.agent.NativeAgentMethods;
import com.jprofiler.agent.b.a;
import com.jprofiler.agent.probe.ProbeHandler;
import com.jprofiler.agent.probe.c;
import com.jprofiler.agent.probe.f.i;
import com.jprofiler.agent.probe.structures.TrackingInfo;
import com.jprofiler.agent.triggers.TriggerManager;
import com.jprofiler.agent.util.ae;
import com.jprofiler.agent.util.m;
import com.jprofiler.api.agent.HeapDumpOptions;
import com.jprofiler.api.agent.ProbeObjectType;
import com.jprofiler.api.agent.ProbeValueType;
import com.jprofiler.api.agent.TrackingOptions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;
import javax.annotation.CheckReturnValue;

public class ControllerImpl {
    private static final String ERROR_MESSAGE = "JProfiler> Native library not found. Ignoring controller call.";
    private static final String ERROR_MESSAGE_SESSION = "JProfiler> Profiling settings must be configured by adding config=<path to config>,id=<session id> to the -agentpath VM parameter. Ignoring controller call.";
    private static volatile File shutdownSnapshotFile;
    private static boolean publicControllerDisabled;

    private static native void startCPURecording0(boolean var0, boolean var1, long var2);

    private static native void stopCPURecording0();

    private static native void startAllocRecording0(boolean var0);

    private static native void stopAllocRecording0();

    private static native void triggerHeapDump0(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7);

    private static native void triggerThreadDump0(String var0);

    private static native void triggerAllObjectsDump0(String var0);

    private static native void triggerMonitorDump0(boolean var0);

    private static native void saveSnapshot0(byte[] var0, Object var1);

    private static native void startThreadProfiling0();

    private static native void stopThreadProfiling0();

    private static native void startVMTelemetryRecording0();

    private static native void stopVMTelemetryRecording0();

    private static native void startCallTracer0(int var0, boolean var1, boolean var2);

    private static native void stopCallTracer0();

    private static native void startMonitorRecording0(int var0, int var1);

    private static native void stopMonitorRecording0();

    private static native void markHeap0();

    private static native void triggerMBeanSnapshot0(String var0, boolean var1, String[] var2);

    public static boolean isPublicControllerDisabled() {
        return publicControllerDisabled;
    }

    public static void setPublicControllerDisabled(boolean bl2) {
        publicControllerDisabled = bl2;
    }

    public static synchronized void startCPURecording(boolean bl2) {
        ControllerImpl.startCPURecording(bl2, false);
    }

    public static synchronized void startCPURecording(boolean bl2, boolean bl3) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            if (bl2) {
                ProbeHandler.reset();
            }
            ControllerImpl.startCPURecording0(bl2, bl3, bl3 ? JProfilerThreadManager.getJProfilerThreadManager().threadManagerPointer : 0L);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void startCPURecording(boolean bl2, TrackingOptions trackingOptions) {
        i.a(trackingOptions);
        ControllerImpl.startCPURecording(bl2);
    }

    public static synchronized void stopCPURecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopCPURecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void startAllocRecording(boolean bl2, TrackingOptions trackingOptions) {
        i.a(trackingOptions);
        ControllerImpl.startAllocRecording(bl2);
    }

    public static synchronized void startAllocRecording(boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startAllocRecording0(bl2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void stopAllocRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopAllocRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void addBookmark(String string) {
        ControllerImpl.addBookmark(string, null, false);
    }

    public static synchronized void addBookmark(String string, Integer n2, boolean bl2) {
        if (string == null) {
            string = "";
        }
        if (n2 != null || bl2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{#");
            if (n2 != null) {
                stringBuilder.append(Integer.toHexString(n2 & 0xFFFFFF));
            } else {
                stringBuilder.append("none");
            }
            stringBuilder.append(',');
            stringBuilder.append(bl2 ? "dashed" : "solid");
            stringBuilder.append(",}");
            stringBuilder.append(string);
            string = stringBuilder.toString();
        }
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            Agent.addBookmark(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerMonitorDump() {
        ControllerImpl.triggerMonitorDump(true);
    }

    public static synchronized void triggerMonitorDump(boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.triggerMonitorDump0(bl2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerThreadDump(String string) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.triggerThreadDump0(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerMBeanSnapshot(String string, String string2) {
        try {
            String[] stringArray;
            if (!ControllerImpl.init()) {
                return;
            }
            boolean bl2 = Objects.equals(System.getProperty("jprofiler.mBeanCreatePlatformServer", "true"), "true");
            if (string2 == null || string2.trim().isEmpty()) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = string2;
            }
            ControllerImpl.triggerMBeanSnapshot0(string, bl2, stringArray);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void triggerAllObjectsDump(String string) {
        ControllerImpl.triggerAllObjectsDump(false, string);
    }

    public static synchronized void triggerAllObjectsDump(boolean bl2, String string) {
        ControllerImpl.runInWorker(bl2, () -> ControllerImpl.triggerAllObjectsDump0(string));
    }

    public static synchronized void triggerHeapDump(HeapDumpOptions heapDumpOptions) {
        ControllerImpl.triggerHeapDump(heapDumpOptions, false);
    }

    public static synchronized void triggerHeapDump(HeapDumpOptions heapDumpOptions, boolean bl2) {
        ControllerImpl.runInWorker(bl2, () -> ControllerImpl.triggerHeapDumpInternal(heapDumpOptions));
    }

    private static void triggerHeapDumpInternal(HeapDumpOptions heapDumpOptions) {
        try {
            ControllerImpl.triggerHeapDump0(heapDumpOptions.isFullGc(), heapDumpOptions.isRetainSoftReferences(), heapDumpOptions.isRetainWeakReferences(), heapDumpOptions.isRetainPhantomReferences(), heapDumpOptions.isRetainFinalizerReferences(), heapDumpOptions.isSelectRecorded(), heapDumpOptions.isPrimitiveData(), heapDumpOptions.isCalculateRetainedSizes());
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void markHeap() {
        ControllerImpl.runInWorker(false, ControllerImpl::markHeap0);
    }

    public static synchronized void saveSnapshot(File file) {
        ControllerImpl.saveSnapshot(file, false);
    }

    public static synchronized File saveSnapshot(File file, boolean bl2) {
        if (file == null) {
            return null;
        }
        File[] fileArray = new File[1];
        ControllerImpl.runInWorker(bl2, () -> {
            fileArray[0] = ControllerImpl.saveSnapshotNow(file);
        });
        return fileArray[0];
    }

    private static File saveSnapshotNow(File file) {
        if (file != null) {
            try {
                file = file.getAbsoluteFile();
                if (file.isDirectory()) {
                    file = ControllerImpl.displaySnapshotError(file, "is a directory");
                } else if (file.getParentFile() == null || !file.getParentFile().isDirectory()) {
                    file = ControllerImpl.displaySnapshotError(file, "has no existing parent directory");
                } else if (!ControllerImpl.isWritable(file)) {
                    file = ControllerImpl.displaySnapshotError(file, "cannot be written");
                }
                ControllerImpl.saveSnapshot0(ae.a(file, true), ProbeHandler.getJavaCollector());
            }
            catch (Throwable throwable) {
                System.err.println("JProfiler> Could not save snapshot");
                throwable.printStackTrace();
            }
            m.a(file);
        }
        return file;
    }

    private static boolean isWritable(File file) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.close();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static File displaySnapshotError(File file, String string) throws IOException {
        System.err.println("JProfiler> " + file.getAbsolutePath() + " " + string + ". Using temporary file.");
        file = File.createTempFile("snap", ".jps", AgentEnvironment.getTempDir());
        return file;
    }

    private static synchronized void runInWorker(boolean bl2, final Runnable runnable) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            if (bl2) {
                runnable.run();
            } else {
                Thread thread = new Thread("_jprofiler_offline_comm"){

                    @Override
                    public void run() {
                        try {
                            runnable.run();
                        }
                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                            System.err.println(ControllerImpl.ERROR_MESSAGE);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            System.err.println(ControllerImpl.ERROR_MESSAGE);
                        }
                    }
                };
                thread.start();
                thread.join();
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void startCallTracer(int n2, boolean bl2, boolean bl3) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startCallTracer0(n2, bl2, bl3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopCallTracer() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopCallTracer0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void setComplexityRecording(boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            a.a(bl2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startThreadProfiling() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startThreadProfiling0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopThreadProfiling() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopThreadProfiling0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startMonitorRecording(int n2, int n3) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startMonitorRecording0(n2, n3);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startMonitorRecording() {
        ControllerImpl.startMonitorRecording(100, 100000);
    }

    public static void stopMonitorRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopMonitorRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void startVMTelemetryRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.startVMTelemetryRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void stopVMTelemetryRecording() {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            ControllerImpl.stopVMTelemetryRecording0();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void saveSnapshotOnExit(File file) {
        if (file == null) {
            return;
        }
        if (shutdownSnapshotFile == null) {
            shutdownSnapshotFile = file;
            Agent.setHasShutdownActions(true);
        } else {
            shutdownSnapshotFile = file;
        }
    }

    static void handleShutdownActions() {
        File file = shutdownSnapshotFile;
        if (file != null) {
            ControllerImpl.saveSnapshot(file, true);
        }
    }

    public static void startProbeRecording(String string, boolean bl2, boolean ... blArray) {
        ControllerImpl.setProbeRecording(string, true, bl2, blArray);
    }

    public static void stopProbeRecording(String string) {
        ControllerImpl.setProbeRecording(string, false, false, null);
    }

    public static void startProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType) {
        ControllerImpl.setProbeTracking(string, stringArray, probeObjectType, probeValueType, true);
    }

    public static void stopProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType) {
        ControllerImpl.setProbeTracking(string, stringArray, probeObjectType, probeValueType, false);
    }

    private static synchronized void setProbeTracking(String string, String[] stringArray, ProbeObjectType probeObjectType, ProbeValueType probeValueType, boolean bl2) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            TrackingInfo trackingInfo = new TrackingInfo(stringArray, probeObjectType, probeValueType);
            Agent.setProbeTracking(string, trackingInfo, bl2, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("JProfiler> Tracking " + (Object)((Object)probeValueType) + " of " + (Object)((Object)probeObjectType) + " for " + string + " is not available");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static synchronized void setProbeRecording(String string, boolean bl2, boolean bl3, boolean[] blArray) {
        try {
            if (!ControllerImpl.init()) {
                return;
            }
            string = c.i(string);
            Agent.setProbeRecording(string, bl2, bl3, blArray, true);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    @CheckReturnValue
    private static boolean init() {
        Agent.initFromController();
        if (!com.jprofiler.agent.c.a.d) {
            System.err.println(ERROR_MESSAGE_SESSION);
            return false;
        }
        return true;
    }

    public static void enableTriggerGroup(boolean bl2, String string) {
        try {
            TriggerManager.setGroupEnabled(bl2, string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println(ERROR_MESSAGE);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            System.err.println(ERROR_MESSAGE);
        }
    }

    public static void enableTriggers(boolean bl2) {
        TriggerManager.globalEnabled = bl2;
    }

    private ControllerImpl() {
    }

    static {
        try {
            NativeAgentMethods.register(ControllerImpl.class, 21);
        }
        catch (Throwable throwable) {
            System.err.println(ERROR_MESSAGE);
        }
        shutdownSnapshotFile = null;
        publicControllerDisabled = Boolean.getBoolean("jprofiler.disableController");
    }
}

