/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.util.TextDisplay;
import org.gjt.jclasslib.util.UiDefaultsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0013\u0012\n\b\u0003\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\u0010*\u00060\u0016j\u0002`\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010#\u001a\u00020\u000eH\u0016J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0019H\u0016J \u0010$\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0002J\u001a\u0010$\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0010\u0010-\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\b\u0010.\u001a\u00020/H\u0016R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u00061"}, d2={"Lorg/gjt/jclasslib/util/HtmlDisplayTextArea;", "Ljavax/swing/JEditorPane;", "Lorg/gjt/jclasslib/util/TextDisplay;", "text", "", "<init>", "(Ljava/lang/String;)V", "inverted", "", "getInverted", "()Z", "setInverted", "(Z)V", "getMinimumSize", "Ljava/awt/Dimension;", "setForeground", "", "fg", "Ljava/awt/Color;", "getHexValue", "color", "appendComponent", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "component", "", "htmlDocument", "Ljavax/swing/text/html/HTMLDocument;", "getHtmlDocument", "()Ljavax/swing/text/html/HTMLDocument;", "styleSheet", "Ljavax/swing/text/html/StyleSheet;", "getStyleSheet", "()Ljavax/swing/text/html/StyleSheet;", "setText", "getPreferredSize", "getBaseline", "width", "height", "view", "Ljavax/swing/text/View;", "w", "h", "bounds", "Ljava/awt/Shape;", "hasParagraph", "getBaselineResizeBehavior", "Ljava/awt/Component$BaselineResizeBehavior;", "Companion", "browser"})
public class HtmlDisplayTextArea
extends JEditorPane
implements TextDisplay {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean inverted;
    @NotNull
    private static final String TAG_HTML = "<html>";
    @NotNull
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public HtmlDisplayTextArea(@Nls @Nullable String text) {
        this.setEditable(false);
        this.setBackground(UIManager.getColor("Label.background"));
        this.setRequestFocusEnabled(false);
        this.setFocusable(false);
        this.setMargin(NO_MARGIN);
        this.setOpaque(false);
        this.updateUI();
        this.setEditorKit(new HTMLEditorKit());
        StyleSheet styleSheet = this.getStyleSheet();
        if (styleSheet != null) {
            StyleSheet styleSheet2;
            StyleSheet $this$_init__u24lambda_u241 = styleSheet2 = styleSheet;
            boolean bl = false;
            Color color = UIManager.getColor("Label.foreground");
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
            $this$_init__u24lambda_u241.addRule("body {color : #" + this.getHexValue(color) + " }");
            Font font = UIManager.getFont("Label.font");
            $this$_init__u24lambda_u241.addRule("body {font-size : " + font.getSize() + "pt; }");
            $this$_init__u24lambda_u241.addRule("body {font-family :" + font.getFontName() + "; }");
        }
        this.setInverted(false);
        if (text != null) {
            this.setText(text);
        }
    }

    public /* synthetic */ HtmlDisplayTextArea(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    public final void setInverted(boolean inverted) {
        block0: {
            StyleSheet styleSheet;
            this.inverted = inverted;
            StyleSheet styleSheet2 = this.getStyleSheet();
            if (styleSheet2 == null) break block0;
            StyleSheet $this$_set_inverted__u24lambda_u240 = styleSheet = styleSheet2;
            boolean bl = false;
            Color color = inverted ? this.getForeground() : UiDefaultsKt.getLinkColor();
            Intrinsics.checkNotNull((Object)color);
            $this$_set_inverted__u24lambda_u240.addRule("a {color : #" + this.getHexValue(color) + " }");
            color = inverted ? this.getForeground() : UiDefaultsKt.getActiveLinkColor();
            Intrinsics.checkNotNull((Object)color);
            $this$_set_inverted__u24lambda_u240.addRule("a:active {color : #" + this.getHexValue(color) + " }");
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension;
        Dimension $this$getMinimumSize_u24lambda_u242 = dimension = super.getMinimumSize();
        boolean bl = false;
        $this$getMinimumSize_u24lambda_u242.width = 0;
        Dimension dimension2 = dimension;
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"apply(...)");
        return dimension2;
    }

    @Override
    public void setForeground(@NotNull Color fg) {
        block0: {
            StyleSheet styleSheet;
            Intrinsics.checkNotNullParameter((Object)fg, (String)"fg");
            super.setForeground(fg);
            StyleSheet styleSheet2 = this.getStyleSheet();
            if (styleSheet2 == null) break block0;
            StyleSheet $this$setForeground_u24lambda_u243 = styleSheet = styleSheet2;
            boolean bl = false;
            $this$setForeground_u24lambda_u243.addRule("body {color : #" + this.getHexValue(fg) + " }");
        }
    }

    private final String getHexValue(Color color) {
        StringBuilder stringBuilder;
        StringBuilder $this$getHexValue_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.appendComponent($this$getHexValue_u24lambda_u244, color.getRed());
        this.appendComponent($this$getHexValue_u24lambda_u244, color.getGreen());
        this.appendComponent($this$getHexValue_u24lambda_u244, color.getBlue());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void appendComponent(StringBuilder $this$appendComponent, int component) {
        String string = Integer.toHexString(component);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        $this$appendComponent.append(StringsKt.padStart((String)string, (int)2, (char)'0'));
    }

    private final HTMLDocument getHtmlDocument() {
        HTMLDocument hTMLDocument;
        if (this.getDocument() instanceof HTMLDocument) {
            Document document = this.getDocument();
            Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLDocument");
            hTMLDocument = (HTMLDocument)document;
        } else {
            hTMLDocument = null;
        }
        return hTMLDocument;
    }

    private final StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = this.getHtmlDocument();
        return hTMLDocument != null ? hTMLDocument.getStyleSheet() : null;
    }

    @Override
    public void setText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super.setText((String)(StringsKt.startsWith$default((String)text, (String)TAG_HTML, (boolean)false, (int)2, null) ? TAG_HTML + text : text));
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension dimension;
        Dimension dimension2 = super.getPreferredSize();
        if (dimension2 != null) {
            Dimension dimension3;
            Dimension $this$getPreferredSize_u24lambda_u245 = dimension3 = dimension2;
            boolean bl = false;
            if ($this$getPreferredSize_u24lambda_u245.height == 0) {
                $this$getPreferredSize_u24lambda_u245.height = 10;
            }
            dimension = dimension3;
        } else {
            dimension = new Dimension(400, 400);
        }
        return dimension;
    }

    @Override
    public int getBaseline(int width, int height) {
        Insets insets = this.getInsets();
        View rootView = this.getUI().getRootView(this);
        if (rootView.getViewCount() > 0) {
            int baseline = insets.top;
            View view = rootView.getView(0);
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"getView(...)");
            int fieldBaseline = this.getBaseline(view, width - insets.left - insets.right, height - insets.top - insets.bottom);
            if (fieldBaseline >= 0) {
                return baseline + fieldBaseline;
            }
        }
        return -1;
    }

    private final int getBaseline(View view, int w, int h) {
        if (this.hasParagraph(view)) {
            view.setSize(w, h);
            return this.getBaseline(view, new Rectangle(0, 0, w, h));
        }
        return -1;
    }

    private final int getBaseline(View view, Shape bounds) {
        int n;
        if (view.getViewCount() == 0) {
            return -1;
        }
        AttributeSet attributeSet = view.getElement().getAttributes();
        Object name = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
        int index = name == HTML.Tag.HTML && view.getViewCount() > 1 ? 1 : 0;
        Shape shape = view.getChildAllocation(index, bounds);
        if (shape == null) {
            return -1;
        }
        Shape correctedBounds = shape;
        View child = view.getView(index);
        if (view instanceof ParagraphView) {
            Rectangle rectangle = correctedBounds instanceof Rectangle ? (Rectangle)correctedBounds : null;
            if (rectangle == null) {
                Rectangle rectangle2 = correctedBounds.getBounds();
                rectangle = rectangle2;
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2, (String)"getBounds(...)");
            }
            Rectangle rect = rectangle;
            n = rect.y + (int)((float)rect.height * child.getAlignment(1));
        } else {
            Intrinsics.checkNotNull((Object)child);
            n = this.getBaseline(child, correctedBounds);
        }
        return n;
    }

    private final boolean hasParagraph(View view) {
        if (view instanceof ParagraphView) {
            return true;
        }
        if (view.getViewCount() == 0) {
            return false;
        }
        AttributeSet attributeSet = view.getElement().getAttributes();
        Object name = attributeSet != null ? attributeSet.getAttribute(StyleConstants.NameAttribute) : null;
        int index = name == HTML.Tag.HTML && view.getViewCount() > 1 ? 1 : 0;
        View view2 = view.getView(index);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getView(...)");
        return this.hasParagraph(view2);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    public HtmlDisplayTextArea() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gjt/jclasslib/util/HtmlDisplayTextArea$Companion;", "", "<init>", "()V", "TAG_HTML", "", "NO_MARGIN", "Ljava/awt/Insets;", "browser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

