/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import com.install4j.runtime.filechooser.DirectoryChooser;
import com.install4j.runtime.filechooser.FileChooser;
import com.install4j.runtime.filechooser.MultiFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserFrame;
import org.gjt.jclasslib.browser.config.BrowserConfig;
import org.gjt.jclasslib.browser.config.classpath.ClasspathArchiveEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathCellRenderer;
import org.gjt.jclasslib.browser.config.classpath.ClasspathDirectoryEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.util.DefaultAction;
import org.gjt.jclasslib.util.GUIHelper;
import org.gjt.jclasslib.util.StandardDialog;
import org.gjt.jclasslib.util.UiDefaultsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010&\u001a\u00020\u0010H\u0014J\u0010\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0010H\u0002J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020-H\u0014J\b\u0010.\u001a\u00020/H\u0002J\u0015\u00100\u001a\n 2*\u0004\u0018\u00010101H\u0002\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0018\u001a\u00020\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u001d\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010\u001d\u001a\u0004\b$\u0010!\u00a8\u00069"}, d2={"Lorg/gjt/jclasslib/browser/config/classpath/ClasspathSetupDialog;", "Lorg/gjt/jclasslib/util/StandardDialog;", "frame", "Lorg/gjt/jclasslib/browser/BrowserFrame;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserFrame;)V", "listModel", "Ljavax/swing/DefaultListModel;", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathEntry;", "lstElements", "Ljavax/swing/JList;", "jreHomeTextField", "Ljavax/swing/JTextField;", "popupMenu", "Ljavax/swing/JPopupMenu;", "addClasspathEntry", "", "entry", "addButton", "Ljavax/swing/JButton;", "removeAction", "Lorg/gjt/jclasslib/util/DefaultAction;", "upAction", "downAction", "fileChooser", "Lcom/install4j/runtime/filechooser/FileChooser;", "getFileChooser", "()Lcom/install4j/runtime/filechooser/FileChooser;", "fileChooser$delegate", "Lkotlin/Lazy;", "directoryChooser", "Lcom/install4j/runtime/filechooser/DirectoryChooser;", "getDirectoryChooser", "()Lcom/install4j/runtime/filechooser/DirectoryChooser;", "directoryChooser$delegate", "jreFileChooser", "getJreFileChooser", "jreFileChooser$delegate", "doOk", "setVisible", "visible", "", "updateData", "addContent", "component", "Ljavax/swing/JComponent;", "createListPanel", "Ljavax/swing/JPanel;", "createModificationButtonBox", "Ljavax/swing/Box;", "kotlin.jvm.PlatformType", "()Ljavax/swing/Box;", "isInModel", "selectIndex", "newSelectedIndex", "", "checkEnabledStatus", "browser"})
@SourceDebugExtension(value={"SMAP\nClasspathSetupDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSetupDialog.kt\norg/gjt/jclasslib/browser/config/classpath/ClasspathSetupDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n827#2:232\n855#2,2:233\n1863#2,2:235\n827#2:237\n855#2,2:238\n1863#2,2:240\n1755#2,3:242\n1#3:245\n*S KotlinDebug\n*F\n+ 1 ClasspathSetupDialog.kt\norg/gjt/jclasslib/browser/config/classpath/ClasspathSetupDialog\n*L\n146#1:232\n146#1:233,2\n147#1:235,2\n149#1:237\n149#1:238,2\n150#1:240,2\n213#1:242,3\n*E\n"})
public final class ClasspathSetupDialog
extends StandardDialog {
    @NotNull
    private final BrowserFrame frame;
    @NotNull
    private final DefaultListModel<ClasspathEntry> listModel;
    @NotNull
    private final JList<ClasspathEntry> lstElements;
    @NotNull
    private final JTextField jreHomeTextField;
    @NotNull
    private final JPopupMenu popupMenu;
    @NotNull
    private final JButton addButton;
    @NotNull
    private final DefaultAction removeAction;
    @NotNull
    private final DefaultAction upAction;
    @NotNull
    private final DefaultAction downAction;
    @NotNull
    private final Lazy fileChooser$delegate;
    @NotNull
    private final Lazy directoryChooser$delegate;
    @NotNull
    private final Lazy jreFileChooser$delegate;

    /*
     * WARNING - void declaration
     */
    public ClasspathSetupDialog(@NotNull BrowserFrame frame) {
        void $this$downAction_u24lambda_u2413;
        Serializable $this$upAction_u24lambda_u2411;
        Serializable $this$removeAction_u24lambda_u249;
        Serializable $this$addButton_u24lambda_u247;
        Serializable $this$popupMenu_u24lambda_u244;
        JComponent $this$lstElements_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        super((Window)frame, BrowserBundle.INSTANCE.getString("window.setup.classpath", new Object[0]));
        this.frame = frame;
        this.listModel = new DefaultListModel();
        Serializable serializable = new JList(this.listModel);
        JList jList = serializable;
        ClasspathSetupDialog classpathSetupDialog = this;
        boolean bl = false;
        $this$lstElements_u24lambda_u241.setSelectionMode(0);
        $this$lstElements_u24lambda_u241.setCellRenderer(new ClasspathCellRenderer());
        $this$lstElements_u24lambda_u241.addListSelectionListener(arg_0 -> ClasspathSetupDialog.lstElements$lambda$1$lambda$0(this, arg_0));
        classpathSetupDialog.lstElements = serializable;
        this.jreHomeTextField = new JTextField();
        serializable = new JPopupMenu();
        $this$lstElements_u24lambda_u241 = serializable;
        classpathSetupDialog = this;
        boolean bl2 = false;
        ((JPopupMenu)$this$popupMenu_u24lambda_u244).add(new DefaultAction(BrowserBundle.INSTANCE.getString("action.classpath.add.jar", new Object[0]), null, null, arg_0 -> ClasspathSetupDialog.popupMenu$lambda$4$lambda$2(this, arg_0), 6, null));
        ((JPopupMenu)$this$popupMenu_u24lambda_u244).add(new DefaultAction(BrowserBundle.INSTANCE.getString("action.classpath.add.directory", new Object[0]), null, null, arg_0 -> ClasspathSetupDialog.popupMenu$lambda$4$lambda$3(this, arg_0), 6, null));
        classpathSetupDialog.popupMenu = serializable;
        $this$popupMenu_u24lambda_u244 = serializable = new DefaultAction(BrowserBundle.INSTANCE.getString("action.classpath.add.entry", new Object[0]), BrowserBundle.INSTANCE.getString("action.classpath.add.entry.description", new Object[0]), "add.svg", (Function1<? super DefaultAction, Unit>)((Function1)arg_0 -> ClasspathSetupDialog.addButton$lambda$6(this, arg_0)));
        classpathSetupDialog = this;
        boolean bl3 = false;
        ((DefaultAction)$this$addButton_u24lambda_u247).accelerator(155, 0);
        ((DefaultAction)$this$addButton_u24lambda_u247).applyAcceleratorTo(this.lstElements);
        classpathSetupDialog.addButton = ((DefaultAction)serializable).createImageButton();
        $this$addButton_u24lambda_u247 = serializable = new DefaultAction(BrowserBundle.INSTANCE.getString("action.classpath.remove.entry", new Object[0]), BrowserBundle.INSTANCE.getString("action.classpath.remove.entry.description", new Object[0]), "remove.svg", (Function1<? super DefaultAction, Unit>)((Function1)arg_0 -> ClasspathSetupDialog.removeAction$lambda$8(this, arg_0)));
        classpathSetupDialog = this;
        boolean bl4 = false;
        ((DefaultAction)$this$removeAction_u24lambda_u249).accelerator(127, 0);
        ((DefaultAction)$this$removeAction_u24lambda_u249).applyAcceleratorTo(this.lstElements);
        classpathSetupDialog.removeAction = serializable;
        $this$removeAction_u24lambda_u249 = serializable = new DefaultAction(BrowserBundle.INSTANCE.getString("action.move.up", new Object[0]), BrowserBundle.INSTANCE.getString("action.move.up.description", new Object[0]), "up.svg", (Function1<? super DefaultAction, Unit>)((Function1)arg_0 -> ClasspathSetupDialog.upAction$lambda$10(this, arg_0)));
        classpathSetupDialog = this;
        boolean bl5 = false;
        ((DefaultAction)$this$upAction_u24lambda_u2411).accelerator(38, 512);
        ((DefaultAction)$this$upAction_u24lambda_u2411).applyAcceleratorTo(this.lstElements);
        classpathSetupDialog.upAction = serializable;
        $this$upAction_u24lambda_u2411 = serializable = new DefaultAction(BrowserBundle.INSTANCE.getString("action.move.down", new Object[0]), BrowserBundle.INSTANCE.getString("action.move.down.description", new Object[0]), "down.svg", (Function1<? super DefaultAction, Unit>)((Function1)arg_0 -> ClasspathSetupDialog.downAction$lambda$12(this, arg_0)));
        classpathSetupDialog = this;
        boolean bl6 = false;
        $this$downAction_u24lambda_u2413.accelerator(40, 512);
        $this$downAction_u24lambda_u2413.applyAcceleratorTo(this.lstElements);
        classpathSetupDialog.downAction = serializable;
        this.fileChooser$delegate = LazyKt.lazy(() -> ClasspathSetupDialog.fileChooser_delegate$lambda$14(this));
        this.directoryChooser$delegate = LazyKt.lazy(() -> ClasspathSetupDialog.directoryChooser_delegate$lambda$15(this));
        this.jreFileChooser$delegate = LazyKt.lazy(() -> ClasspathSetupDialog.jreFileChooser_delegate$lambda$16(this));
        this.setupComponent();
    }

    private final void addClasspathEntry(ClasspathEntry entry) {
        if (!this.isInModel(entry)) {
            this.listModel.addElement(entry);
            this.selectIndex(this.listModel.getSize() - 1);
        }
    }

    private final FileChooser getFileChooser() {
        Lazy lazy = this.fileChooser$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (FileChooser)object;
    }

    private final DirectoryChooser getDirectoryChooser() {
        Lazy lazy = this.directoryChooser$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DirectoryChooser)object;
    }

    private final DirectoryChooser getJreFileChooser() {
        Lazy lazy = this.jreFileChooser$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (DirectoryChooser)object;
    }

    @Override
    protected void doOk() {
        Iterable $this$forEach$iv;
        ClasspathEntry it;
        Object element$iv$iv;
        Iterator $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        ArrayList newEntries = new ArrayList();
        Collection collection = newEntries;
        Enumeration<ClasspathEntry> enumeration = this.listModel.elements();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
        CollectionsKt.addAll((Collection)collection, (Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)));
        BrowserConfig config = this.frame.getConfig();
        ArrayList oldEntries = new ArrayList(config.getClasspath());
        List<ClasspathEntry> list2 = oldEntries;
        boolean $i$f$filterNot = false;
        void var6_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            it = (ClasspathEntry)element$iv$iv;
            boolean bl = false;
            if (newEntries.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClasspathEntry it2 = (ClasspathEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            config.removeClasspathEntry(it2);
        }
        $this$forEach$iv = newEntries;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        Iterator bl = $this$filterNotTo$iv$iv.iterator();
        while (bl.hasNext()) {
            element$iv$iv = bl.next();
            it = (ClasspathEntry)element$iv$iv;
            boolean bl2 = false;
            if (oldEntries.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClasspathEntry it3 = (ClasspathEntry)element$iv;
            boolean bl3 = false;
            config.addClasspathEntry(it3);
        }
        List<ClasspathEntry> $this$doOk_u24lambda_u2421 = list2 = config.getClasspath();
        boolean bl4 = false;
        $this$doOk_u24lambda_u2421.clear();
        $this$doOk_u24lambda_u2421.addAll(newEntries);
        String string = this.jreHomeTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        config.setJreHome(((Object)StringsKt.trim((CharSequence)string)).toString());
        super.doOk();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateData();
        }
        super.setVisible(visible);
    }

    private final void updateData() {
        this.listModel.clear();
        for (ClasspathEntry classpathEntry : this.frame.getConfig().getClasspath()) {
            this.listModel.addElement(classpathEntry);
        }
        this.jreHomeTextField.setText(this.frame.getConfig().getJreHome());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addContent(@NotNull JComponent component) {
        void $this$addContent_u24lambda_u2425_u24lambda_u2424;
        JButton jButton;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        JComponent $this$addContent_u24lambda_u2425 = component;
        boolean bl = false;
        $this$addContent_u24lambda_u2425.setLayout((LayoutManager)new MigLayout("wrap", "[grow]"));
        $this$addContent_u24lambda_u2425.add((Component)this.createListPanel(), "pushy, grow");
        $this$addContent_u24lambda_u2425.add((Component)new JLabel(BrowserBundle.INSTANCE.getString("classpath.jre.home", new Object[0])), "split");
        $this$addContent_u24lambda_u2425.add((Component)this.jreHomeTextField, "grow");
        JButton jButton2 = jButton = new JButton(BrowserBundle.INSTANCE.getString("action.choose", new Object[0]));
        JComponent jComponent = $this$addContent_u24lambda_u2425;
        boolean bl2 = false;
        $this$addContent_u24lambda_u2425_u24lambda_u2424.addActionListener(arg_0 -> ClasspathSetupDialog.addContent$lambda$25$lambda$24$lambda$23(this, arg_0));
        jComponent.add((Component)jButton, "wrap para");
        this.setSize(600, 400);
        this.checkEnabledStatus();
    }

    /*
     * WARNING - void declaration
     */
    private final JPanel createListPanel() {
        void $this$createListPanel_u24lambda_u2427_u24lambda_u2426;
        JPanel jPanel;
        JPanel $this$createListPanel_u24lambda_u2427 = jPanel = new JPanel();
        boolean bl = false;
        $this$createListPanel_u24lambda_u2427.setLayout(new BorderLayout());
        Object object = UiDefaultsKt.getScrollPaneFactory().invoke(this.lstElements);
        JScrollPane jScrollPane = (JScrollPane)object;
        JPanel jPanel2 = $this$createListPanel_u24lambda_u2427;
        boolean bl2 = false;
        $this$createListPanel_u24lambda_u2427_u24lambda_u2426.setBorder(BorderFactory.createEtchedBorder());
        jPanel2.add((Component)object, "Center");
        $this$createListPanel_u24lambda_u2427.add((Component)this.createModificationButtonBox(), "East");
        return jPanel;
    }

    private final Box createModificationButtonBox() {
        Box box;
        Box $this$createModificationButtonBox_u24lambda_u2428 = box = Box.createVerticalBox();
        boolean bl = false;
        $this$createModificationButtonBox_u24lambda_u2428.add(this.addButton);
        $this$createModificationButtonBox_u24lambda_u2428.add(this.removeAction.createImageButton());
        $this$createModificationButtonBox_u24lambda_u2428.add(Box.createVerticalGlue());
        $this$createModificationButtonBox_u24lambda_u2428.add(this.upAction.createImageButton());
        $this$createModificationButtonBox_u24lambda_u2428.add(this.downAction.createImageButton());
        return box;
    }

    private final boolean isInModel(ClasspathEntry entry) {
        boolean bl;
        block3: {
            Enumeration<ClasspathEntry> enumeration = this.listModel.elements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
            ArrayList<ClasspathEntry> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            Iterable $this$any$iv = arrayList;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClasspathEntry it = (ClasspathEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)entry)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void selectIndex(int newSelectedIndex) {
        int cappedSelectedIndex = Math.min(newSelectedIndex, this.listModel.getSize() - 1);
        if (cappedSelectedIndex > -1) {
            this.lstElements.setSelectedIndex(cappedSelectedIndex);
            this.lstElements.ensureIndexIsVisible(cappedSelectedIndex);
            this.checkEnabledStatus();
        }
    }

    private final void checkEnabledStatus() {
        int selectedIndex = this.lstElements.getSelectedIndex();
        this.removeAction.setEnabled(selectedIndex > -1);
        this.upAction.setEnabled(selectedIndex > 0);
        this.downAction.setEnabled(selectedIndex > -1 && selectedIndex < this.listModel.getSize() - 1);
    }

    private static final void lstElements$lambda$1$lambda$0(ClasspathSetupDialog this$0, ListSelectionEvent it) {
        this$0.checkEnabledStatus();
    }

    private static final Unit popupMenu$lambda$4$lambda$2(ClasspathSetupDialog this$0, DefaultAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.getFileChooser().select()) {
            Collection files = this$0.getFileChooser().getSelectedFiles();
            for (File file : files) {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                this$0.addClasspathEntry(new ClasspathArchiveEntry(string));
                this$0.frame.setClassesChooserPath(file.getParent());
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit popupMenu$lambda$4$lambda$3(ClasspathSetupDialog this$0, DefaultAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.getDirectoryChooser().select()) {
            File file = this$0.getDirectoryChooser().getSelectedDirectory();
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this$0.addClasspathEntry(new ClasspathDirectoryEntry(string));
            this$0.frame.setClassesChooserPath(file.getParent());
        }
        return Unit.INSTANCE;
    }

    private static final Unit addButton$lambda$6(ClasspathSetupDialog this$0, DefaultAction action) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            JComponent jComponent = action.getLastButton();
            if (jComponent == null) break block0;
            JComponent it = jComponent;
            boolean bl = false;
            Rectangle bounds = it.getBounds();
            this$0.popupMenu.show(it.getParent(), bounds.x, bounds.y + bounds.height);
        }
        return Unit.INSTANCE;
    }

    private static final Unit removeAction$lambda$8(ClasspathSetupDialog this$0, DefaultAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedIndex = this$0.lstElements.getSelectedIndex();
        if (selectedIndex > -1) {
            this$0.listModel.remove(selectedIndex);
            this$0.selectIndex(selectedIndex);
        }
        return Unit.INSTANCE;
    }

    private static final Unit upAction$lambda$10(ClasspathSetupDialog this$0, DefaultAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedIndex = this$0.lstElements.getSelectedIndex();
        if (selectedIndex > 0) {
            ClasspathEntry entry = this$0.listModel.remove(selectedIndex);
            int newSelectedIndex = selectedIndex - 1;
            this$0.listModel.insertElementAt(entry, newSelectedIndex);
            this$0.selectIndex(newSelectedIndex);
        }
        return Unit.INSTANCE;
    }

    private static final Unit downAction$lambda$12(ClasspathSetupDialog this$0, DefaultAction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int selectedIndex = this$0.lstElements.getSelectedIndex();
        if (selectedIndex < this$0.listModel.getSize() - 1) {
            ClasspathEntry entry = this$0.listModel.remove(selectedIndex);
            int newSelectedIndex = selectedIndex + 1;
            this$0.listModel.insertElementAt(entry, newSelectedIndex);
            this$0.selectIndex(newSelectedIndex);
        }
        return Unit.INSTANCE;
    }

    private static final FileChooser fileChooser_delegate$lambda$14(ClasspathSetupDialog this$0) {
        return ((FileChooser)GUIHelper.INSTANCE.applyPath(((FileChooser)FileChooser.create().parent((Component)this$0)).title(BrowserBundle.INSTANCE.getString("chooser.jar.files.title", new Object[0])), this$0.frame.getClassesChooserPath())).addFileFilter(new MultiFileFilter("jar", BrowserBundle.INSTANCE.getString("chooser.jar.files.and.directories.filter.name", new Object[0]))).multiple(true);
    }

    private static final DirectoryChooser directoryChooser_delegate$lambda$15(ClasspathSetupDialog this$0) {
        return (DirectoryChooser)GUIHelper.INSTANCE.applyPath(((DirectoryChooser)DirectoryChooser.create().parent((Component)this$0)).title(BrowserBundle.INSTANCE.getString("chooser.directory.title", new Object[0])), this$0.frame.getClassesChooserPath());
    }

    private static final DirectoryChooser jreFileChooser_delegate$lambda$16(ClasspathSetupDialog this$0) {
        return (DirectoryChooser)GUIHelper.INSTANCE.applyPath(((DirectoryChooser)DirectoryChooser.create().parent((Component)this$0)).title(BrowserBundle.INSTANCE.getString("chooser.jre.home.title", new Object[0])), this$0.frame.getClassesChooserPath());
    }

    private static final File addContent$lambda$25$lambda$24$lambda$23$maybeNestedJre(File file) {
        File it = new File(file, "jre");
        boolean bl = false;
        return it.exists() ? it : file;
    }

    private static final void addContent$lambda$25$lambda$24$lambda$23(ClasspathSetupDialog this$0, ActionEvent it) {
        if (this$0.getJreFileChooser().select()) {
            JTextField jTextField = this$0.jreHomeTextField;
            File file = this$0.getJreFileChooser().getSelectedFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSelectedFile(...)");
            jTextField.setText(ClasspathSetupDialog.addContent$lambda$25$lambda$24$lambda$23$maybeNestedJre(file).getPath());
        }
    }
}

