/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.dom.DomKt;
import kotlinx.dom.build.BuilderKt;
import org.gjt.jclasslib.browser.config.ClassPathContainer;
import org.gjt.jclasslib.browser.config.ImmutableClassPathContainer;
import org.gjt.jclasslib.browser.config.classpath.ClasspathArchiveEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathDirectoryEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0006J\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0006J\u0006\u0010\u001c\u001a\u00020\u0015J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0010j\b\u0012\u0004\u0012\u00020\u0006`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/gjt/jclasslib/browser/config/BrowserConfig;", "Lorg/gjt/jclasslib/browser/config/ClassPathContainer;", "<init>", "()V", "classpath", "", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathEntry;", "getClasspath", "()Ljava/util/List;", "jreHome", "", "getJreHome", "()Ljava/lang/String;", "setJreHome", "(Ljava/lang/String;)V", "mergedEntries", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "toImmutableContainer", "Lorg/gjt/jclasslib/browser/config/ImmutableClassPathContainer;", "addClasspathDirectory", "", "directoryName", "addClasspathArchive", "archiveName", "addClasspathEntry", "entry", "removeClasspathEntry", "clear", "saveWorkspace", "element", "Lorg/w3c/dom/Element;", "readWorkspace", "Companion", "browser"})
@SourceDebugExtension(value={"SMAP\nBrowserConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserConfig.kt\norg/gjt/jclasslib/browser/config/BrowserConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1#2:82\n1863#3,2:83\n*S KotlinDebug\n*F\n+ 1 BrowserConfig.kt\norg/gjt/jclasslib/browser/config/BrowserConfig\n*L\n57#1:83,2\n*E\n"})
public final class BrowserConfig
extends ClassPathContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ClasspathEntry> classpath = new ArrayList();
    @NotNull
    private String jreHome;
    @NotNull
    private final HashSet<ClasspathEntry> mergedEntries;
    @NotNull
    private static final String ATTRIBUTE_JRE_HOME = "jreHome";
    @NotNull
    private static final String NODE_NAME_CLASSPATH = "classpath";

    public BrowserConfig() {
        String string = System.getProperty("java.home");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        this.jreHome = string;
        this.mergedEntries = new HashSet();
    }

    @Override
    @NotNull
    public List<ClasspathEntry> getClasspath() {
        return this.classpath;
    }

    @Override
    @NotNull
    public String getJreHome() {
        return this.jreHome;
    }

    public void setJreHome(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.jreHome = string;
    }

    @NotNull
    public final ImmutableClassPathContainer toImmutableContainer() {
        return new ImmutableClassPathContainer(new ArrayList(this.getClasspath()), this.getJreHome());
    }

    public final void addClasspathDirectory(@NotNull String directoryName) {
        ClasspathDirectoryEntry classpathDirectoryEntry;
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        ClasspathDirectoryEntry $this$addClasspathDirectory_u24lambda_u240 = classpathDirectoryEntry = new ClasspathDirectoryEntry(directoryName);
        boolean bl = false;
        $this$addClasspathDirectory_u24lambda_u240.addToClassPath(this.getClasspath());
    }

    public final void addClasspathArchive(@NotNull String archiveName) {
        ClasspathArchiveEntry classpathArchiveEntry;
        Intrinsics.checkNotNullParameter((Object)archiveName, (String)"archiveName");
        ClasspathArchiveEntry $this$addClasspathArchive_u24lambda_u241 = classpathArchiveEntry = new ClasspathArchiveEntry(archiveName);
        boolean bl = false;
        $this$addClasspathArchive_u24lambda_u241.addToClassPath(this.getClasspath());
    }

    public final void addClasspathEntry(@NotNull ClasspathEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        entry.addToClassPath(this.getClasspath());
    }

    public final void removeClasspathEntry(@NotNull ClasspathEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.getClasspath().remove(entry);
    }

    public final void clear() {
        this.setJreHome(System.getProperty("java.home"));
        this.getClasspath().clear();
        this.mergedEntries.clear();
    }

    public final void saveWorkspace(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BuilderKt.addElement$default((Element)element, (String)NODE_NAME_CLASSPATH, null, arg_0 -> BrowserConfig.saveWorkspace$lambda$3(this, arg_0), (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void readWorkspace(@NotNull Element element) {
        block1: {
            void it;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            this.clear();
            Element element2 = DomKt.firstChildElement((Element)element, (String)NODE_NAME_CLASSPATH);
            if (element2 == null) break block1;
            Element classpathElement = element2;
            boolean bl = false;
            String string = classpathElement.getAttribute(ATTRIBUTE_JRE_HOME);
            BrowserConfig browserConfig = this;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            browserConfig.setJreHome((String)(((CharSequence)it).length() == 0 || !new File((String)it).exists() ? this.getJreHome() : it));
            for (Element entryElement : DomKt.childElements((Element)classpathElement)) {
                ClasspathEntry classpathEntry;
                if (ClasspathEntry.Companion.create(entryElement) == null) continue;
                ClasspathEntry $this$readWorkspace_u24lambda_u246_u24lambda_u245 = classpathEntry;
                boolean bl3 = false;
                this.getClasspath().add($this$readWorkspace_u24lambda_u246_u24lambda_u245);
            }
        }
    }

    private static final Unit saveWorkspace$lambda$3(BrowserConfig this$0, Element $this$addElement) {
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
        $this$addElement.setAttribute(ATTRIBUTE_JRE_HOME, this$0.getJreHome());
        Iterable $this$forEach$iv = this$0.getClasspath();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ClasspathEntry it = (ClasspathEntry)element$iv;
            boolean bl = false;
            it.saveWorkspace($this$addElement);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gjt/jclasslib/browser/config/BrowserConfig$Companion;", "", "<init>", "()V", "ATTRIBUTE_JRE_HOME", "", "NODE_NAME_CLASSPATH", "browser"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

