/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserDetailPane;
import org.gjt.jclasslib.browser.BrowserHistory;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.BrowserTreePane;
import org.gjt.jclasslib.browser.NodeType;
import org.gjt.jclasslib.browser.config.AttributeHolder;
import org.gjt.jclasslib.browser.config.BrowserPath;
import org.gjt.jclasslib.browser.config.CategoryHolder;
import org.gjt.jclasslib.browser.config.IndexHolder;
import org.gjt.jclasslib.browser.config.PathComponent;
import org.gjt.jclasslib.browser.config.ReferenceHolder;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassMember;
import org.gjt.jclasslib.structures.FieldInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;
import org.gjt.jclasslib.structures.MethodInfo;
import org.gjt.jclasslib.util.AlertFacade;
import org.gjt.jclasslib.util.AlertFacadeKt;
import org.gjt.jclasslib.util.SplitDirection;
import org.gjt.jclasslib.util.SplitterFacade;
import org.gjt.jclasslib.util.SplitterFacadeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0002J\u0016\u0010'\u001a\u00020&2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0002J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020,J\u0006\u0010.\u001a\u00020,J\u0006\u0010/\u001a\u00020\u0014J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202H\u0016J\u0014\u00103\u001a\u00020,*\u00020\u001b2\u0006\u00104\u001a\u000205H\u0002J\u0014\u00106\u001a\u00020,*\u00020\u001b2\u0006\u00107\u001a\u000208H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020&H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Lorg/gjt/jclasslib/browser/BrowserComponent;", "Ljavax/swing/JComponent;", "Ljavax/swing/event/TreeSelectionListener;", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserServices;)V", "history", "Lorg/gjt/jclasslib/browser/BrowserHistory;", "getHistory", "()Lorg/gjt/jclasslib/browser/BrowserHistory;", "detailPane", "Lorg/gjt/jclasslib/browser/BrowserDetailPane;", "getDetailPane", "()Lorg/gjt/jclasslib/browser/BrowserDetailPane;", "treePane", "Lorg/gjt/jclasslib/browser/BrowserTreePane;", "getTreePane", "()Lorg/gjt/jclasslib/browser/BrowserTreePane;", "isModified", "", "()Z", "setModified", "(Z)V", "splitPane", "Lorg/gjt/jclasslib/util/SplitterFacade;", "browserPath", "Lorg/gjt/jclasslib/browser/config/BrowserPath;", "getBrowserPath", "()Lorg/gjt/jclasslib/browser/config/BrowserPath;", "setBrowserPath", "(Lorg/gjt/jclasslib/browser/config/BrowserPath;)V", "title", "", "getTitle", "()Ljava/lang/String;", "createBrowserPath", "selectionPath", "Ljavax/swing/tree/TreePath;", "buildPath", "pathComponents", "", "Lorg/gjt/jclasslib/browser/config/PathComponent;", "rebuild", "", "reset", "checkSelection", "canRemove", "valueChanged", "selectionEvent", "Ljavax/swing/event/TreeSelectionEvent;", "addReferenceHolder", "classMember", "Lorg/gjt/jclasslib/structures/ClassMember;", "addIndexHolder", "node", "Lorg/gjt/jclasslib/browser/BrowserTreeNode;", "showDetailPaneForPath", "path", "browser"})
@SourceDebugExtension(value={"SMAP\nBrowserComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserComponent.kt\norg/gjt/jclasslib/browser/BrowserComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,160:1\n1557#2:161\n1628#2,3:162\n1872#2,3:165\n295#2,2:168\n37#3:170\n36#3,3:171\n*S KotlinDebug\n*F\n+ 1 BrowserComponent.kt\norg/gjt/jclasslib/browser/BrowserComponent\n*L\n63#1:161\n63#1:162,3\n63#1:165,3\n96#1:168,2\n103#1:170\n103#1:171,3\n*E\n"})
public final class BrowserComponent
extends JComponent
implements TreeSelectionListener {
    @NotNull
    private final BrowserServices services;
    @NotNull
    private final BrowserHistory history;
    @NotNull
    private final BrowserDetailPane detailPane;
    @NotNull
    private final BrowserTreePane treePane;
    private boolean isModified;
    @NotNull
    private final SplitterFacade splitPane;

    public BrowserComponent(@NotNull BrowserServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        this.services = services;
        this.history = new BrowserHistory(this.services);
        this.detailPane = new BrowserDetailPane(this.services);
        this.treePane = new BrowserTreePane(this.services);
        this.splitPane = (SplitterFacade)SplitterFacadeKt.getSplitterFactory().invoke((Object)SplitDirection.HORIZONTAL, (Object)this.treePane, (Object)this.detailPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitPane.getComponent(), "Center");
        this.treePane.getTree().addTreeSelectionListener(this);
    }

    @NotNull
    public final BrowserHistory getHistory() {
        return this.history;
    }

    @NotNull
    public final BrowserDetailPane getDetailPane() {
        return this.detailPane;
    }

    @NotNull
    public final BrowserTreePane getTreePane() {
        return this.treePane;
    }

    public final boolean isModified() {
        return this.isModified;
    }

    public final void setModified(boolean bl) {
        this.isModified = bl;
    }

    @Nullable
    public final BrowserPath getBrowserPath() {
        TreePath selectionPath = this.treePane.getTree().getSelectionPath();
        if (selectionPath == null || selectionPath.getPathCount() < 2) {
            return null;
        }
        return this.createBrowserPath(selectionPath);
    }

    public final void setBrowserPath(@Nullable BrowserPath browserPath) {
        if (browserPath == null || browserPath.getPathComponents().isEmpty()) {
            this.treePane.getTree().addSelectionRow(0);
        } else {
            JTree jTree;
            TreePath path = this.buildPath((List<? extends PathComponent>)browserPath.getPathComponents());
            JTree $this$_set_browserPath__u24lambda_u240 = jTree = this.treePane.getTree();
            boolean bl = false;
            $this$_set_browserPath__u24lambda_u240.expandPath(path);
            $this$_set_browserPath__u24lambda_u240.setSelectionPath(path);
            $this$_set_browserPath__u24lambda_u240.scrollPathToVisible(path);
        }
    }

    @NotNull
    public final String getTitle() {
        return this.services.getClassFile().getSimpleClassName();
    }

    /*
     * WARNING - void declaration
     */
    private final BrowserPath createBrowserPath(TreePath selectionPath) {
        BrowserPath browserPath;
        BrowserPath $this$createBrowserPath_u24lambda_u243 = browserPath = new BrowserPath();
        boolean bl = false;
        try {
            void $this$forEachIndexed$iv;
            Object item$iv$iv;
            void $this$mapTo$iv$iv;
            Object[] objectArray = selectionPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getPath(...)");
            Iterable $this$map$iv = ArraysKt.drop((Object[])objectArray, (int)1);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
                collection.add((BrowserTreeNode)it);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            block9: for (Object item$iv : $this$forEachIndexed$iv) {
                void node;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (BrowserTreeNode)item$iv;
                int i = n;
                boolean bl3 = false;
                Object element = node.getElement();
                if (i == 0) {
                    $this$createBrowserPath_u24lambda_u243.addPathComponent(new CategoryHolder(node.getType()));
                    continue;
                }
                switch (WhenMappings.$EnumSwitchMapping$0[node.getType().ordinal()]) {
                    case 1: {
                        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.gjt.jclasslib.structures.MethodInfo");
                        this.addReferenceHolder($this$createBrowserPath_u24lambda_u243, (ClassMember)((MethodInfo)element));
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.gjt.jclasslib.structures.FieldInfo");
                        this.addReferenceHolder($this$createBrowserPath_u24lambda_u243, (ClassMember)((FieldInfo)element));
                        break;
                    }
                    case 3: {
                        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type org.gjt.jclasslib.structures.AttributeInfo");
                        $this$createBrowserPath_u24lambda_u243.addPathComponent(new AttributeHolder(((AttributeInfo)element).getName()));
                        break;
                    }
                    case 4: {
                        if (!this.detailPane.getConstantPoolDetailPane().getFilterPane().isShowAll()) continue block9;
                        this.addIndexHolder($this$createBrowserPath_u24lambda_u243, (BrowserTreeNode)node);
                        break;
                    }
                    default: {
                        this.addIndexHolder($this$createBrowserPath_u24lambda_u243, (BrowserTreeNode)node);
                    }
                }
            }
        }
        catch (InvalidByteCodeException invalidByteCodeException) {
        }
        return browserPath;
    }

    private final TreePath buildPath(List<? extends PathComponent> pathComponents) {
        BrowserTreeNode[] browserTreeNodeArray = new BrowserTreeNode[]{this.treePane.getRoot()};
        List nodes = CollectionsKt.mutableListOf((Object[])browserTreeNodeArray);
        for (PathComponent pathComponent : pathComponents) {
            Object v0;
            block2: {
                Iterable $this$firstOrNull$iv = (Iterable)CollectionsKt.last((List)nodes);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BrowserTreeNode it = (BrowserTreeNode)element$iv;
                    boolean bl = false;
                    if (!pathComponent.matches(it)) continue;
                    v0 = element$iv;
                    break block2;
                }
                v0 = null;
            }
            BrowserTreeNode node = v0;
            if (node == null) break;
            nodes.add(node);
        }
        Collection $this$toTypedArray$iv = nodes;
        boolean bl = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new TreePath(thisCollection$iv.toArray(new BrowserTreeNode[0]));
    }

    public final void rebuild() {
        BrowserPath browserPath = this.getBrowserPath();
        this.reset();
        if (browserPath != null) {
            this.setBrowserPath(browserPath);
        }
    }

    public final void reset() {
        JTree tree = this.treePane.getTree();
        tree.removeTreeSelectionListener(this);
        this.treePane.rebuild();
        this.history.clear();
        tree.addTreeSelectionListener(this);
        this.checkSelection();
    }

    public final void checkSelection() {
        JTree tree = this.treePane.getTree();
        if (tree.getSelectionPath() == null) {
            Object object = tree.getModel().getRoot();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
            BrowserTreeNode rootNode = (BrowserTreeNode)object;
            Object[] objectArray = new Object[]{rootNode, rootNode.getFirstChild()};
            tree.setSelectionPath(new TreePath(objectArray));
        }
    }

    public final boolean canRemove() {
        return !this.isModified || AlertFacade.DefaultImpls.showDiscardCancelDialog$default(AlertFacadeKt.getAlertFacade(), this, BrowserBundle.INSTANCE.getString("message.class.file.modified.title", new Object[0]), BrowserBundle.INSTANCE.getString("message.class.file.modified", new Object[0]), false, 8, null).getSelectedIndex() == 0;
    }

    @Override
    public void valueChanged(@NotNull TreeSelectionEvent selectionEvent) {
        Intrinsics.checkNotNullParameter((Object)selectionEvent, (String)"selectionEvent");
        this.services.activate();
        TreePath selectedPath = selectionEvent.getPath();
        Intrinsics.checkNotNull((Object)selectedPath);
        BrowserHistory.addHistoryEntry$default(this.history, selectedPath, null, 2, null);
        this.showDetailPaneForPath(selectedPath);
    }

    private final void addReferenceHolder(BrowserPath $this$addReferenceHolder, ClassMember classMember) {
        $this$addReferenceHolder.addPathComponent(new ReferenceHolder(classMember.getName(), classMember.getDescriptor()));
    }

    private final void addIndexHolder(BrowserPath $this$addIndexHolder, BrowserTreeNode node) {
        $this$addIndexHolder.addPathComponent(new IndexHolder(node.getIndex()));
    }

    private final void showDetailPaneForPath(TreePath path) {
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        BrowserTreeNode node = (BrowserTreeNode)object;
        NodeType nodeType = node.getType();
        this.detailPane.showPane(nodeType, path);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NodeType.values().length];
            try {
                nArray[NodeType.METHOD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.FIELD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.ATTRIBUTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeType.CONSTANT_POOL_ENTRY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

