/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.vsnet;

import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;

class VsnetUtils {
    static final Color DARK_GREEN = new Color(0, 128, 0);
    static final Color DARK_MAGENTA = new Color(128, 0, 128);
    private static double RATIO1 = 0.8;
    private static double RATIO2 = 0.92f;
    private static double RATIO3 = 0.86f;

    VsnetUtils() {
    }

    static Color getLighterColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.93f);
    }

    static Color getMenuSelectionColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.8555f);
    }

    static Color getMenuBackgroundColor(Color color) {
        return VsnetUtils.getLighterColor(color);
    }

    static Color getToolBarBackgroundColor(Color color) {
        if (Color.BLACK.equals(color)) {
            return color;
        }
        if (Color.WHITE.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, 0.645f);
    }

    static Color getGripperForegroundColor(Color color) {
        int n2 = VsnetUtils.getGripperValue(color.getRed());
        int n3 = VsnetUtils.getGripperValue(color.getGreen());
        int n4 = VsnetUtils.getGripperValue(color.getBlue());
        if (n2 >= 255) {
            n2 = 255;
        }
        if (n3 >= 255) {
            n3 = 255;
        }
        if (n4 >= 255) {
            n4 = 255;
        }
        return new ColorUIResource(n2, n3, n4);
    }

    static int getGripperValue(int n2) {
        if (n2 == 255) {
            return 0;
        }
        if (n2 >= 0 && n2 <= 64) {
            return n2 * 33 / 64 + 123;
        }
        return (n2 - 65) * 157 / 189 + 33;
    }

    static Color getDefaultBackgroundColor(Color color) {
        ColorUIResource colorUIResource;
        if (color.getRed() == 212 && color.getGreen() == 208 && color.getBlue() == 200) {
            colorUIResource = new ColorUIResource(247, 243, 233);
        } else if (color.getRed() == 236 && color.getGreen() == 233 && color.getBlue() == 216) {
            colorUIResource = new ColorUIResource(255, 251, 233);
        } else {
            int n2 = color.getRed() + 35;
            int n3 = color.getGreen() + 35;
            int n4 = color.getBlue() + 35;
            if (n2 >= 255) {
                n2 = 255;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            if (n4 >= 255) {
                n4 = 255;
            }
            colorUIResource = new ColorUIResource(n2, n3, n4);
        }
        return colorUIResource;
    }

    public static void setColorRatios(double d2, double d3, double d4) {
        RATIO1 = d2;
        RATIO2 = d3;
        RATIO3 = d4;
    }

    static int getLightColor(int n2, double d2) {
        return (int)((double)(255 - n2) * d2 + (double)n2);
    }

    static Color getLighterColor(Color color, float f2) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return color;
        }
        return ColorUtils.getDerivedColor(color, f2);
    }

    static Color getSelectedAndRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO1);
    }

    static Color getRolloverButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO2);
    }

    static Color getSelectedButtonColor(Color color) {
        return VsnetUtils.getLighterColor(color, (float)RATIO3);
    }

    static Color getButtonBorderColor(Color color) {
        if (DARK_GREEN.equals(color) || DARK_MAGENTA.equals(color)) {
            return new ColorUIResource(Color.WHITE);
        }
        return color;
    }
}

