/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.DefaultMarkerStripePainter;
import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerArea;
import com.jidesoft.marker.MarkerModel;
import com.jidesoft.marker.MarkerStripePainter;
import com.jidesoft.marker.MarkerSupport;
import com.jidesoft.range.IntegerRange;
import com.jidesoft.utils.HtmlUtils;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;

public class MarkerStripe
extends JPanel
implements MouseListener,
MouseMotionListener {
    protected MarkerSupport _markerSupport;
    protected MarkerArea _markerArea;
    protected MarkerStripePainter _painter;

    public MarkerStripe(MarkerArea markerArea) {
        this._markerArea = markerArea;
        this._markerSupport = markerArea.getMarkerSupport();
        ToolTipManager.sharedInstance().registerComponent(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void a(MarkerSupport markerSupport) {
        this._markerSupport = markerSupport;
    }

    public MarkerStripePainter getPainter() {
        String[] stringArray = MarkerArea.b();
        MarkerStripePainter markerStripePainter = this._painter;
        if (stringArray == null) {
            if (markerStripePainter == null) {
                this._painter = new DefaultMarkerStripePainter();
            }
            markerStripePainter = this._painter;
        }
        return markerStripePainter;
    }

    public void setPainter(MarkerStripePainter markerStripePainter) {
        this._painter = markerStripePainter;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        MarkerModel markerModel;
        String[] stringArray = MarkerArea.b();
        super.paintComponent(graphics);
        MarkerSupport markerSupport = this._markerSupport;
        if (stringArray == null) {
            if (markerSupport == null) {
                return;
            }
            markerSupport = this._markerSupport;
        }
        MarkerModel markerModel2 = markerModel = markerSupport.getMarkerModel();
        if (stringArray == null) {
            if (markerModel2 == null) {
                return;
            }
            markerModel2 = markerModel;
        }
        List<Marker> list = markerModel2.getMarkers();
        Color color = graphics.getColor();
        if (stringArray == null) {
            if (list != null) {
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Marker marker = list.get(i2);
                    this.paintMarker(graphics, marker);
                    if (stringArray == null) {
                        if (stringArray == null) continue;
                    }
                    break;
                }
            } else {
                graphics.setColor(color);
            }
        }
    }

    protected List<Marker> getMarkersAt(Point point) {
        block5: {
            IntegerRange integerRange;
            IntegerRange integerRange2;
            IntegerRange integerRange3;
            block6: {
                MarkerStripe markerStripe;
                String[] stringArray;
                block4: {
                    stringArray = MarkerArea.b();
                    markerStripe = this;
                    if (stringArray != null) break block4;
                    if (markerStripe._markerSupport == null) break block5;
                    markerStripe = this;
                }
                Insets insets = markerStripe.getInsets();
                int n2 = this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom;
                point.x -= insets.left;
                point.y -= insets.top;
                integerRange3 = this._markerSupport.pointToIndexRange(new Point(point.x - 0, point.y - 0), n2);
                integerRange2 = this._markerSupport.pointToIndexRange(new Point(point.x + 0, point.y + 0), n2);
                integerRange = integerRange3;
                if (stringArray != null) break block6;
                if (integerRange == null) break block5;
                integerRange = integerRange2;
            }
            if (integerRange != null) {
                MarkerModel markerModel = this._markerSupport.getMarkerModel();
                return markerModel.getMarkersAt(integerRange3.getMin(), integerRange2.getMax());
            }
        }
        return null;
    }

    protected void paintMarker(Graphics graphics, Marker marker) {
        int n2;
        int n3;
        int n4;
        int n5;
        Insets insets;
        block8: {
            block9: {
                Point point;
                int n6 = marker.getStartOffset();
                insets = this.getInsets();
                int n7 = this.getHeight() - this.getPainter().getMaxStripeHeight() - insets.top - insets.bottom;
                Point point2 = this._markerSupport.indexToPoint(n6, n7);
                String[] stringArray = MarkerArea.b();
                Point point3 = point2;
                if (stringArray == null) {
                    if (point3 == null) {
                        return;
                    }
                    point2.y += insets.top;
                    point3 = point2;
                }
                n5 = point3.y;
                int n8 = marker.getEndOffset();
                n4 = 3;
                n3 = n8;
                n2 = n6;
                if (stringArray != null) break block8;
                if (n3 == n2) break block9;
                Point point4 = point = this._markerSupport.indexToPoint(n8, n7);
                if (stringArray == null) {
                    if (point4 == null) {
                        return;
                    }
                    point4 = point;
                }
                int n9 = point4.y;
                n3 = n9 - n5;
                n2 = n4;
                if (stringArray != null) break block8;
                if (n3 > n2) {
                    n4 = n9 - n5;
                }
            }
            n3 = this.getWidth() - insets.left;
            n2 = insets.right;
        }
        int n10 = n3 - n2;
        this.getPainter().paint(this._markerArea, graphics, marker, new Rectangle(insets.left, n5, n10 - 1, n4));
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        block11: {
            StringBuffer stringBuffer;
            block12: {
                int n2;
                int n3;
                StringBuffer stringBuffer2;
                block9: {
                    List<Marker> list;
                    List<Marker> list2;
                    String[] stringArray;
                    block10: {
                        stringArray = MarkerArea.b();
                        list = list2 = this.getMarkersAt(mouseEvent.getPoint());
                        if (stringArray != null) break block10;
                        if (list == null) break block11;
                        list = list2;
                    }
                    if (list.size() <= 0) break block11;
                    stringBuffer2 = new StringBuffer("<html>");
                    int n4 = 0;
                    while (n4 < list2.size()) {
                        Marker marker = list2.get(n4);
                        String string = marker.getToolTipText();
                        stringBuffer2.append(HtmlUtils.formatHtmlSubString(string));
                        if (stringArray == null) {
                            n3 = n4;
                            n2 = list2.size() - 1;
                            if (stringArray != null) break block9;
                            if (n3 != n2) {
                                stringBuffer2.append("<br>");
                            }
                            ++n4;
                        }
                        if (stringArray == null) continue;
                    }
                    stringBuffer2.append("</html>");
                    stringBuffer = stringBuffer2;
                    if (stringArray != null) break block12;
                    n3 = stringBuffer.length();
                    n2 = "<html>".length() + "</html>".length();
                }
                if (n3 <= n2) {
                    return null;
                }
                stringBuffer = stringBuffer2;
            }
            return stringBuffer.toString();
        }
        return null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        block5: {
            Object object;
            block3: {
                Object object2;
                String[] stringArray;
                block4: {
                    List<Marker> list;
                    block2: {
                        stringArray = MarkerArea.b();
                        list = this.getMarkersAt(mouseEvent.getPoint());
                        object2 = list;
                        if (stringArray != null) break block2;
                        if (object2 == null) break block3;
                        object2 = list;
                    }
                    if (stringArray != null) break block4;
                    if (object2.size() <= 0) break block3;
                    object2 = list.get(0);
                }
                object = (Marker)object2;
                this._markerSupport.scrollTo(((Marker)object).getStartOffset(), ((Marker)object).getEndOffset(), this._markerArea.isClickToSelect());
                if (stringArray == null) break block5;
            }
            object = this.getInsets();
            int n2 = this.getHeight() - this.getPainter().getMaxStripeHeight() - ((Insets)object).top - ((Insets)object).bottom;
            IntegerRange integerRange = this._markerSupport.pointToIndexRange(mouseEvent.getPoint(), n2);
            this._markerSupport.scrollTo(integerRange.getMin(), integerRange.getMax(), false);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        block4: {
            block3: {
                List<Marker> list;
                String[] stringArray;
                block2: {
                    List<Marker> list2;
                    stringArray = MarkerArea.b();
                    list = list2 = this.getMarkersAt(mouseEvent.getPoint());
                    if (stringArray != null) break block2;
                    if (list == null) break block3;
                    list = list2;
                }
                if (list.size() <= 0) break block3;
                this.setCursor(Cursor.getPredefinedCursor(12));
                if (stringArray == null) break block4;
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

