/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.grid.JideTable;
import com.jidesoft.grid.TreeTable;
import com.jidesoft.icons.RolloverIcon;
import com.jidesoft.swing.Animator;
import com.jidesoft.swing.AnimatorListener;
import com.jidesoft.swing.NavigationComponent;
import com.jidesoft.swing.NavigationComponentHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class NavigationTreeTable
extends TreeTable
implements NavigationComponent,
RolloverIcon.IconRolloverSupport {
    private NavigationComponentHelper bR;
    private float bS = 0.0f;
    private Animator bT;
    private Animator bU;
    private boolean bV = true;
    public static final String PROPERTY_FADE_ICON = "fadeIcon";

    public NavigationTreeTable() {
        this.G();
    }

    public NavigationTreeTable(int n2, int n3) {
        super(n2, n3);
        this.G();
    }

    public NavigationTreeTable(TableModel tableModel) {
        super(tableModel);
        this.G();
    }

    public NavigationTreeTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.G();
    }

    public NavigationTreeTable(Vector<? extends Vector> vector, Vector<?> vector2) {
        super(vector, vector2);
        this.G();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.G();
    }

    public NavigationTreeTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.G();
    }

    private void G() {
        this.setAutoResizeMode(256);
        this.setFillsSelection(false);
        this.setShowGrid(false);
        this.setFillsGrids(false);
        this.setShowTreeLines(false);
        this.setShowLeafNodeTreeLines(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setExpandedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 0));
        this.setCollapsedIcon(new RolloverIcon((RolloverIcon.IconRolloverSupport)this, 1));
        this.bT = new Animator(this, 100, 30, 30);
        this.bT.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                String[] stringArray = JideTable.w();
                float f2 = 1.0f * (float)(n2 - n3) / (float)n2;
                if (stringArray == null) {
                    if (f2 <= NavigationTreeTable.this.getIconAlpha()) {
                        NavigationTreeTable.this.setIconAlpha(f2);
                    }
                    NavigationTreeTable.this.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(0.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.bU = new Animator(this, 100, 5, 10);
        this.bU.addAnimatorListener(new AnimatorListener(){

            @Override
            public void animationStarts(Component component) {
            }

            @Override
            public void animationFrame(Component component, int n2, int n3) {
                String[] stringArray = JideTable.w();
                float f2 = 1.0f * (float)n3 / (float)n2;
                if (stringArray == null) {
                    if (f2 >= NavigationTreeTable.this.getIconAlpha()) {
                        NavigationTreeTable.this.setIconAlpha(f2);
                    }
                    NavigationTreeTable.this.repaint();
                }
            }

            @Override
            public void animationEnds(Component component) {
                NavigationTreeTable.this.setIconAlpha(1.0f);
                NavigationTreeTable.this.repaint();
            }
        });
        this.bR = this.createNavigationHelper();
        this.bR.setup(this);
    }

    protected NavigationComponentHelper createNavigationHelper() {
        return new NavigationTreeTableHelper();
    }

    private Rectangle k(int n2) {
        return this.getCellRect(n2, 0, false).union(this.getCellRect(n2, this.getColumnCount() - 1, false));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isIconRollover(int n2, int n3, int n4, int n5) {
        Point point;
        String[] stringArray = JideTable.w();
        Point point2 = point = this.bR.getMousePosition();
        if (stringArray == null) {
            if (point2 == null) return 0 != 0;
            point2 = point;
        }
        int n6 = point2.x;
        if (stringArray != null) return n6 != 0;
        if (n6 < n2) return 0 != 0;
        n6 = point.x;
        if (stringArray != null) return n6 != 0;
        if (n6 > n2 + n4) return 0 != 0;
        n6 = point.y;
        if (stringArray != null) return n6 != 0;
        if (n6 < n3) return 0 != 0;
        n6 = point.y;
        if (stringArray != null) return n6 != 0;
        if (n6 > n3 + n5) return 0 != 0;
        return true;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.bR.paint(graphics, this);
    }

    @Override
    public float getIconAlpha() {
        return this.bS;
    }

    public void setIconAlpha(float f2) {
        this.bS = f2;
    }

    @Override
    public boolean isIconFade() {
        return this.bV;
    }

    public void setFadeIcon(boolean bl2) {
        block3: {
            block2: {
                String[] stringArray = JideTable.w();
                boolean bl3 = this.bV;
                if (stringArray != null) break block2;
                if (bl2 == this.bV) break block3;
                this.bV = bl2;
                this.firePropertyChange(PROPERTY_FADE_ICON, bl3, this.bV);
            }
            this.repaint();
        }
    }

    public int getNavigationRolloverRow() {
        return this.bR.getRolloverRow();
    }

    public void setNavigationRolloverRow(int n2) {
        block5: {
            NavigationTreeTable navigationTreeTable;
            Rectangle rectangle;
            block7: {
                Rectangle rectangle2;
                block6: {
                    int n3;
                    String[] stringArray;
                    block4: {
                        stringArray = JideTable.w();
                        n3 = this.bR.getRolloverRow();
                        if (stringArray != null) break block4;
                        if (n3 == n2) break block5;
                        this.bR.setRolloverRow(n2);
                    }
                    rectangle2 = rectangle = this.k(n3);
                    if (stringArray != null) break block6;
                    if (rectangle2 != null) {
                        this.repaint(rectangle);
                    }
                    navigationTreeTable = this;
                    if (stringArray != null) break block7;
                    rectangle2 = rectangle = navigationTreeTable.k(n2);
                }
                if (rectangle2 == null) break block5;
                navigationTreeTable = this;
            }
            navigationTreeTable.repaint(rectangle);
        }
    }

    public class NavigationTreeTableHelper
    extends NavigationComponentHelper {
        @Override
        public Rectangle getRowBounds(int n2) {
            return NavigationTreeTable.this.k(n2);
        }

        @Override
        public int rowAtPoint(Point point) {
            return NavigationTreeTable.this.rowAtPoint(point);
        }

        @Override
        public int[] getSelectedRows() {
            return NavigationTreeTable.this.getSelectedRows();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block4: {
                    boolean bl2;
                    block2: {
                        String[] stringArray = JideTable.w();
                        bl2 = NavigationTreeTable.this.isIconFade();
                        if (stringArray != null) break block2;
                        if (!bl2) break block3;
                        navigationTreeTable = NavigationTreeTable.this;
                        if (stringArray != null) break block4;
                        bl2 = navigationTreeTable.hasFocus();
                    }
                    if (bl2) break block3;
                    NavigationTreeTable.this.bU.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.bT.start();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block4: {
                    boolean bl2;
                    block2: {
                        String[] stringArray = JideTable.w();
                        bl2 = NavigationTreeTable.this.isIconFade();
                        if (stringArray != null) break block2;
                        if (!bl2) break block3;
                        navigationTreeTable = NavigationTreeTable.this;
                        if (stringArray != null) break block4;
                        bl2 = navigationTreeTable.hasFocus();
                    }
                    if (bl2) break block3;
                    NavigationTreeTable.this.bT.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.bU.start();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block2: {
                    String[] stringArray = JideTable.w();
                    navigationTreeTable = NavigationTreeTable.this;
                    if (stringArray != null) break block2;
                    if (!navigationTreeTable.isIconFade()) break block3;
                    NavigationTreeTable.this.bT.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.bU.start();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            block3: {
                NavigationTreeTable navigationTreeTable;
                block2: {
                    String[] stringArray = JideTable.w();
                    navigationTreeTable = NavigationTreeTable.this;
                    if (stringArray != null) break block2;
                    if (!navigationTreeTable.isIconFade()) break block3;
                    NavigationTreeTable.this.bU.stop();
                    navigationTreeTable = NavigationTreeTable.this;
                }
                navigationTreeTable.bT.start();
            }
        }
    }
}

