/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.status;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.status.AbstractCodeEditorStatusBarItem;
import com.jidesoft.swing.JidePopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class LineBreakStatusBarItem
extends AbstractCodeEditorStatusBarItem
implements PropertyChangeListener,
MouseListener {
    public LineBreakStatusBarItem() {
    }

    public LineBreakStatusBarItem(String string) {
        super(string);
    }

    @Override
    public void initialize() {
        this.setHorizontalAlignment(0);
        this.addMouseListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this._editor != null) {
            JidePopupMenu jidePopupMenu = new JidePopupMenu();
            JMenuItem jMenuItem = jidePopupMenu.add(this._editor.getResourceString("LineBreak.fileFormat"));
            jMenuItem.setEnabled(false);
            jidePopupMenu.addSeparator();
            this.a(jidePopupMenu, 0);
            this.a(jidePopupMenu, 1);
            this.a(jidePopupMenu, 2);
            jidePopupMenu.show(this, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        }
    }

    private void a(JidePopupMenu jidePopupMenu, final int n2) {
        boolean bl2 = AbstractCodeEditorStatusBarItem.b();
        JMenuItem jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(new AbstractAction(this.getLineBreakText(n2)){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LineBreakStatusBarItem.this.getCodeEditor().setLineBreakStyle(n2);
            }
        }));
        int n3 = this.getCodeEditor().getLineBreakStyle();
        if (bl2) {
            n3 = n3 == n2 ? 1 : 0;
        }
        jMenuItem.setSelected(n3 != 0);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateText((Integer)propertyChangeEvent.getNewValue());
    }

    @Override
    public void registerListener(CodeEditor codeEditor) {
        block3: {
            CodeEditor codeEditor2;
            block2: {
                boolean bl2 = AbstractCodeEditorStatusBarItem.b();
                codeEditor2 = codeEditor;
                if (!bl2) break block2;
                if (codeEditor2 == null) break block3;
                codeEditor2 = codeEditor;
            }
            codeEditor2.addPropertyChangeListener("lineBreakStyle", this);
            this.updateText(codeEditor.getLineBreakStyle());
        }
    }

    @Override
    public void unregisterListener(CodeEditor codeEditor) {
        block3: {
            CodeEditor codeEditor2;
            block2: {
                boolean bl2 = AbstractCodeEditorStatusBarItem.b();
                codeEditor2 = codeEditor;
                if (!bl2) break block2;
                if (codeEditor2 == null) break block3;
                codeEditor2 = codeEditor;
            }
            codeEditor2.removePropertyChangeListener("lineBreakStyle", this);
        }
    }

    public String getLineBreakText(int n2) {
        switch (n2) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed");
    }

    public String getLineBreakTooltip(int n2) {
        switch (n2) {
            case 0: {
                return this._editor.getResourceString("LineBreak.pc.tooltip");
            }
            case 2: {
                return this._editor.getResourceString("LineBreak.mac.tooltip");
            }
            case 1: {
                return this._editor.getResourceString("LineBreak.unix.tooltip");
            }
        }
        return this._editor.getResourceString("LineBreak.mixed.tooltip");
    }

    public void updateText(int n2) {
        block3: {
            LineBreakStatusBarItem lineBreakStatusBarItem;
            block2: {
                boolean bl2 = AbstractCodeEditorStatusBarItem.b();
                lineBreakStatusBarItem = this;
                if (!bl2) break block2;
                if (lineBreakStatusBarItem._editor == null) break block3;
                this.setText(this.getLineBreakText(n2));
                lineBreakStatusBarItem = this;
            }
            lineBreakStatusBarItem.setToolTipText(this.getLineBreakTooltip(n2));
        }
    }
}

