/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.CodeEditorMarginSupport;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.folding.FoldingSpan;
import com.jidesoft.editor.folding.FoldingSpanEvent;
import com.jidesoft.editor.folding.FoldingSpanListener;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.editor.margin.DefaultCodeFoldingPainter;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.MouseInputListener;

public class CodeFoldingMargin
extends AbstractMargin
implements FoldingSpanListener,
MouseInputListener {
    private transient FoldingSpan b;
    private transient ArrayList<FoldingSpan> c;
    protected CodeFoldingPainter _codeFoldingPainter;

    public CodeFoldingMargin() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public CodeFoldingMargin(CodeEditor codeEditor) {
        super(codeEditor);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    protected void installListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().addFoldingSpanListener(this);
    }

    @Override
    protected void uninstallListenersOnEditor() {
        this.getCodeEditor().getFoldingModel().removeFoldingSpanListener(this);
    }

    @Override
    public void paintMargin(Graphics graphics) {
        block11: {
            Object object;
            int n2;
            int n3;
            String[] stringArray;
            block12: {
                block13: {
                    FoldingSpan[] foldingSpanArray;
                    stringArray = AbstractMargin.b();
                    CodeEditor codeEditor = this.getCodeEditor();
                    if (stringArray != null) {
                        if (codeEditor == null) {
                            return;
                        }
                        codeEditor = this.getCodeEditor();
                    }
                    CodeEditor codeEditor2 = codeEditor;
                    n3 = codeEditor2.getDocument() instanceof LazyLoadDocument;
                    if (stringArray == null) break block12;
                    if (n3 == 0) break block13;
                    n2 = codeEditor2.getPainter().getLineHeight();
                    object = codeEditor2.getVisibleRect();
                    int n4 = codeEditor2.xyToOffset(object.x, object.y);
                    int n5 = codeEditor2.xyToOffset(object.width, object.height);
                    for (FoldingSpan foldingSpan : foldingSpanArray = codeEditor2.getFoldingModel().getFoldingSpans()) {
                        block16: {
                            int n6;
                            int n7;
                            int n8;
                            block17: {
                                int n9;
                                block18: {
                                    block14: {
                                        block15: {
                                            n9 = foldingSpan.getStartOffset();
                                            n8 = foldingSpan.getEndOffset();
                                            if (stringArray == null) break block11;
                                            n7 = n9;
                                            n6 = n4;
                                            if (stringArray == null) break block14;
                                            if (n7 < n6) break block15;
                                            n7 = n9;
                                            n6 = n5;
                                            if (stringArray == null) break block14;
                                            if (n7 <= n6) break block16;
                                        }
                                        n7 = n8;
                                        n6 = n4;
                                    }
                                    if (stringArray == null) break block17;
                                    if (n7 < n6) break block18;
                                    n7 = n8;
                                    n6 = n5;
                                    if (stringArray == null) break block17;
                                    if (n7 < n6) break block16;
                                }
                                n7 = n9;
                                n6 = n4;
                            }
                            if (stringArray != null) {
                                if (n7 >= n6) continue;
                                n7 = n8;
                                n6 = n5;
                            }
                            if (n7 <= n6) continue;
                        }
                        this.paintFolding(graphics, foldingSpan, n2);
                        if (stringArray != null) continue;
                    }
                    if (stringArray != null) break block11;
                }
                n3 = this.getCodeEditor().getPainter().getLineHeight();
            }
            n2 = n3;
            for (FoldingSpan foldingSpan : object = this.getCodeEditor().getFoldingModel().getFoldingSpans()) {
                this.paintFolding(graphics, foldingSpan, n2);
                if (stringArray != null) continue;
            }
        }
    }

    @Override
    public void foldingSpanChanged(FoldingSpanEvent foldingSpanEvent) {
        if (!foldingSpanEvent.isAdjusting()) {
            this.repaint();
        }
    }

    public CodeFoldingPainter getCodeFoldingPainter() {
        String[] stringArray = AbstractMargin.b();
        CodeFoldingPainter codeFoldingPainter = this._codeFoldingPainter;
        if (stringArray != null) {
            if (codeFoldingPainter == null) {
                this._codeFoldingPainter = new DefaultCodeFoldingPainter();
            }
            codeFoldingPainter = this._codeFoldingPainter;
        }
        return codeFoldingPainter;
    }

    public void setCodeFoldingPainter(CodeFoldingPainter codeFoldingPainter) {
        this._codeFoldingPainter = codeFoldingPainter;
        this.repaint();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        super.paintBackground(graphics);
        this.getCodeFoldingPainter().paintBackground(this, graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    @Override
    public int getPreferredWidth() {
        return this.getCodeFoldingPainter().getPreferredWidth();
    }

    protected ArrayList<FoldingSpan> getFoldingSpansAt(Point point) {
        String[] stringArray = AbstractMargin.b();
        ArrayList<FoldingSpan> arrayList = new ArrayList<FoldingSpan>();
        CodeEditor codeEditor = this.getCodeEditor();
        if (stringArray != null) {
            if (codeEditor == null) {
                return arrayList;
            }
            codeEditor = this.getCodeEditor();
        }
        int n2 = codeEditor.getFirstLine();
        int n3 = this.getCodeEditor().getPainter().getLineHeight();
        int n4 = point.y / n3;
        this.getFoldingSpans(arrayList, n2 + n4);
        return arrayList;
    }

    protected void getFoldingSpans(ArrayList<FoldingSpan> arrayList, int n2) {
        FoldingSpan[] foldingSpanArray;
        FoldingSpan[] foldingSpanArray2 = foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n3 = foldingSpanArray2.length;
        String[] stringArray = AbstractMargin.b();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            int n5;
            int n6;
            FoldingSpan foldingSpan;
            block11: {
                int n7;
                block8: {
                    int n8;
                    block9: {
                        block10: {
                            block6: {
                                block7: {
                                    int n9;
                                    foldingSpan = foldingSpanArray2[i2];
                                    int n10 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                    int n11 = n9 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                    if (stringArray != null) {
                                        if (n11 < 0) continue;
                                        n11 = this.getCodeEditor().modelToViewLine(n10);
                                    }
                                    n7 = n11;
                                    n6 = this.getCodeEditor().modelToViewLine(n9);
                                    n8 = n7;
                                    if (stringArray == null) break block6;
                                    if (n8 >= 0) break block7;
                                    n7 = n6;
                                    if (stringArray != null) break block8;
                                }
                                n8 = n6;
                            }
                            if (stringArray == null) break block9;
                            if (n8 < 0) break block10;
                            n5 = n6;
                            n4 = n7;
                            if (stringArray == null) break block11;
                            if (n5 >= n4) break block8;
                        }
                        n8 = n7;
                    }
                    n6 = n8;
                }
                n5 = n2;
                if (stringArray == null) continue;
                n4 = n7;
            }
            if (n5 != n4) {
                n5 = n2;
                if (stringArray == null || n5 != n6) continue;
            }
            n5 = arrayList.add(foldingSpan) ? 1 : 0;
            if (stringArray != null) continue;
        }
    }

    protected boolean isMixedSpansAt(Point point) {
        return this.isMixedSpans(this.getFoldingSpansAt(point));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isMixedSpans(ArrayList<FoldingSpan> arrayList) {
        boolean bl2;
        boolean bl3;
        String[] stringArray;
        block5: {
            stringArray = AbstractMargin.b();
            boolean bl4 = arrayList.size();
            if (stringArray == null) return bl4;
            if (bl4 <= true) return false;
            bl3 = false;
            boolean bl5 = false;
            for (FoldingSpan foldingSpan : arrayList) {
                block6: {
                    block7: {
                        bl2 = foldingSpan.isExpanded();
                        if (stringArray == null) break block5;
                        if (stringArray == null) break block6;
                        if (!bl2) break block7;
                        bl3 = true;
                        if (stringArray != null) break block6;
                    }
                    boolean bl6 = bl5 = true;
                }
                if (stringArray != null) continue;
            }
            bl2 = bl5;
        }
        if (stringArray != null) {
            if (!bl2) return false;
            bl2 = bl3;
        }
        if (stringArray == null) return bl2;
        if (!bl2) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void paintFolding(Graphics var1_1, FoldingSpan var2_2, int var3_3) {
        block27: {
            block28: {
                block29: {
                    block25: {
                        block26: {
                            block20: {
                                block21: {
                                    block22: {
                                        var4_4 = AbstractMargin.b();
                                        if (this.getCodeEditor() == null) {
                                            return;
                                        }
                                        var5_5 = 0;
                                        v0 = this;
                                        if (var4_4 == null) break block21;
                                        if (v0.c == null) break block22;
                                        v1 = this.c.size();
                                        if (var4_4 == null) break block20;
                                        if (v1 <= 1) break block22;
                                        var5_5 = this.isMixedSpans(this.c);
                                        var6_6 = this.c.iterator();
                                        while (var6_6.hasNext()) {
                                            block24: {
                                                block23: {
                                                    v2 = var7_8 = var6_6.next();
                                                    if (var4_4 == null) break block23;
                                                    v1 = (int)v2.isExpanded();
                                                    if (var4_4 == null) break block20;
                                                    if (v1 != 0) break block24;
                                                    v2 = var2_2;
                                                }
                                                if (v2 == var7_8) {
                                                    this.b = var7_8;
                                                    if (var4_4 != null) break;
                                                }
                                            }
                                            if (var4_4 != null) continue;
                                        }
                                    }
                                    v0 = this;
                                }
                                v1 = v0.getCodeEditor().getFirstLine();
                            }
                            var6_7 = v1;
                            var7_9 = this.getCodeEditor().getLineNumber(var2_2.getStartOffset());
                            var8_10 = this.b == var2_2 ? 2 : 0;
                            v3 = var2_2.isExpanded();
                            if (var4_4 == null) break block25;
                            if (v3 != 0) break block26;
                            var7_9 = this.getCodeEditor().modelToViewLine(var7_9) + 1;
                            this.getCodeFoldingPainter().paintCollapsedFolding(this, var1_1, var2_2, new Rectangle(0, (var7_9 - var6_7 - 1) * var3_3 + 1, this.getWidth(), var3_3), var8_10);
                            if (var4_4 != null) break block27;
                        }
                        v3 = this.getCodeEditor().getLineNumber(var2_2.getEndOffset() - 1);
                    }
                    v4 = var9_11 = v3;
                    if (var4_4 != null) {
                        if (v4 < 0) {
                            return;
                        }
                        v4 = var7_9;
                    }
                    v5 = var9_11;
                    if (var4_4 == null) break block28;
                    if (v4 == v5) break block29;
                    v6 = var5_5;
                    if (var4_4 != null) {
                        if (v6 != 0) {
                            v6 = (int)this.c.contains(var2_2);
                            if (var4_4 != null) {
                                if (v6 != 0) {
                                    return;
                                } else {
                                    ** GOTO lbl-1000
                                }
                            }
                        } else lbl-1000:
                        // 3 sources

                        {
                            var7_9 = this.getCodeEditor().modelToViewLine(var7_9) + 1;
                            var9_11 = this.getCodeEditor().modelToViewLine(var9_11) + 1;
                            v6 = var7_9;
                        }
                    }
                    if (var4_4 != null) {
                        if (v6 == var9_11) {
                            return;
                        }
                        v6 = this.getCodeFoldingPainter().paintFoldingStart(this, var1_1, var2_2, new Rectangle(0, (var7_9 - var6_7 - 1) * var3_3 + 1, this.getWidth(), var3_3), var8_10);
                    }
                    var10_12 = v6;
                    var11_13 = this.getCodeFoldingPainter().paintFoldingEnd(this, var1_1, var2_2, new Rectangle(0, (var9_11 - var6_7 - 1) * var3_3 + 1, this.getWidth(), var3_3), var8_10);
                    this.getCodeFoldingPainter().paintFoldingLine(this, var1_1, var2_2, new Rectangle(0, var10_12, this.getWidth(), var11_13 - var10_12), var8_10);
                    if (var4_4 != null) break block27;
                }
                v4 = this.getCodeEditor().modelToViewLine(var7_9);
                v5 = 1;
            }
            var7_9 = v4 + v5;
            this.getCodeFoldingPainter().paintExpandedFolding(this, var1_1, var2_2, new Rectangle(0, (var7_9 - var6_7 - 1) * var3_3 + 1, this.getWidth(), var3_3), var8_10);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        block9: {
            block14: {
                Object object;
                block21: {
                    int n2;
                    block20: {
                        String[] stringArray;
                        block19: {
                            block15: {
                                block16: {
                                    block18: {
                                        block17: {
                                            Point point;
                                            CodeFoldingMargin codeFoldingMargin;
                                            block10: {
                                                block11: {
                                                    stringArray = AbstractMargin.b();
                                                    codeFoldingMargin = this;
                                                    if (stringArray != null) {
                                                        if (codeFoldingMargin.getCodeEditor() == null) {
                                                            return;
                                                        }
                                                        codeFoldingMargin = this;
                                                    }
                                                    point = mouseEvent.getPoint();
                                                    if (stringArray == null) break block10;
                                                    if (!codeFoldingMargin.isMixedSpansAt(point)) break block11;
                                                    object = this.getFoldingSpansAt(mouseEvent.getPoint());
                                                    Iterator iterator = ((ArrayList)object).iterator();
                                                    while (iterator.hasNext()) {
                                                        block13: {
                                                            block12: {
                                                                FoldingSpan foldingSpan = (FoldingSpan)iterator.next();
                                                                if (stringArray == null) break block9;
                                                                if (stringArray == null) break block12;
                                                                if (foldingSpan.isExpanded()) break block13;
                                                                this.getCodeEditor().getFoldingModel().expandFoldingSpan(foldingSpan);
                                                            }
                                                            if (stringArray != null) break;
                                                        }
                                                        if (stringArray != null) continue;
                                                    }
                                                    if (stringArray != null) break block14;
                                                }
                                                codeFoldingMargin = this;
                                                point = mouseEvent.getPoint();
                                            }
                                            object = codeFoldingMargin.getSpanInfo(point);
                                            if (stringArray == null) break block9;
                                            if (object == null) break block14;
                                            n2 = ((HitInfo)object).a.isExpanded();
                                            if (stringArray == null) break block15;
                                            if (n2 == 0) break block16;
                                            n2 = ((HitInfo)object).b;
                                            if (stringArray == null) break block17;
                                            if (n2 == 0) break block18;
                                            n2 = ((HitInfo)object).b;
                                        }
                                        if (stringArray == null) break block15;
                                        if (n2 != 1) break block16;
                                    }
                                    this.getCodeEditor().getFoldingModel().collapseFoldingSpan(((HitInfo)object).a);
                                    if (stringArray != null) break block14;
                                }
                                n2 = ((HitInfo)object).a.isExpanded() ? 1 : 0;
                            }
                            if (stringArray == null) break block19;
                            if (n2 != 0) break block14;
                            n2 = ((HitInfo)object).b;
                        }
                        if (stringArray == null) break block20;
                        if (n2 == 0) break block21;
                        n2 = ((HitInfo)object).b;
                    }
                    if (n2 != 1) break block14;
                }
                this.getCodeEditor().getFoldingModel().expandFoldingSpan(((HitInfo)object).a);
            }
            this.mouseMoved(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        block3: {
            CodeFoldingMargin codeFoldingMargin;
            block2: {
                String[] stringArray = AbstractMargin.b();
                codeFoldingMargin = this;
                if (stringArray == null) break block2;
                if (codeFoldingMargin.b == null) break block3;
                this.b = null;
                this.c = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        block5: {
            CodeFoldingMargin codeFoldingMargin;
            block6: {
                boolean bl2;
                String[] stringArray;
                block2: {
                    ArrayList<FoldingSpan> arrayList;
                    block3: {
                        CodeFoldingMargin codeFoldingMargin2;
                        block4: {
                            arrayList = this.getFoldingSpansAt(mouseEvent.getPoint());
                            this.c = arrayList;
                            stringArray = AbstractMargin.b();
                            bl2 = arrayList.isEmpty();
                            if (stringArray == null) break block2;
                            if (bl2) break block3;
                            codeFoldingMargin2 = this;
                            if (stringArray == null) break block4;
                            if (codeFoldingMargin2.b == arrayList.get(0)) break block3;
                            this.b = arrayList.get(0);
                            codeFoldingMargin2 = this;
                        }
                        codeFoldingMargin2.repaint();
                        if (stringArray != null) break block5;
                    }
                    bl2 = arrayList.isEmpty();
                }
                if (!bl2) break block5;
                codeFoldingMargin = this;
                if (stringArray == null) break block6;
                if (codeFoldingMargin.b == null) break block5;
                this.b = null;
                this.c = null;
                codeFoldingMargin = this;
            }
            codeFoldingMargin.repaint();
        }
    }

    protected HitInfo getSpanInfo(Point point) {
        String[] stringArray = AbstractMargin.b();
        CodeEditor codeEditor = this.getCodeEditor();
        if (stringArray != null) {
            if (codeEditor == null) {
                return null;
            }
            codeEditor = this.getCodeEditor();
        }
        int n2 = codeEditor.getFirstLine();
        int n3 = this.getCodeEditor().getPainter().getLineHeight();
        int n4 = point.y;
        int n5 = n4 / n3;
        FoldingSpan[] foldingSpanArray = this.getCodeEditor().getFoldingModel().getFoldingSpans();
        int n6 = n2 + n5;
        for (FoldingSpan foldingSpan : foldingSpanArray) {
            int n7;
            int n8;
            int n9;
            int n10;
            block16: {
                block13: {
                    int n11;
                    block14: {
                        block15: {
                            block11: {
                                block12: {
                                    int n12;
                                    int n13 = this.getCodeEditor().getLineNumber(foldingSpan.getStartOffset());
                                    int n14 = n12 = this.getCodeEditor().getLineNumber(foldingSpan.getEndOffset() - 1);
                                    if (stringArray != null) {
                                        if (n14 < 0) {
                                            return null;
                                        }
                                        n14 = this.getCodeEditor().modelToViewLine(n13);
                                    }
                                    n10 = n14;
                                    n9 = this.getCodeEditor().modelToViewLine(n12);
                                    n11 = n10;
                                    if (stringArray == null) break block11;
                                    if (n11 >= 0) break block12;
                                    n10 = n9;
                                    if (stringArray != null) break block13;
                                }
                                n11 = n9;
                            }
                            if (stringArray == null) break block14;
                            if (n11 < 0) break block15;
                            n8 = n9;
                            n7 = n10;
                            if (stringArray == null) break block16;
                            if (n8 >= n7) break block13;
                        }
                        n11 = n10;
                    }
                    n9 = n11;
                }
                n8 = n6;
                n7 = n10;
            }
            if (stringArray != null) {
                if (n8 < n7) continue;
                n8 = n6;
                n7 = n9;
            }
            if (n8 > n7) continue;
            HitInfo hitInfo = new HitInfo();
            hitInfo.a = foldingSpan;
            int n15 = n6;
            int n16 = n10;
            if (stringArray != null) {
                if (n15 == n16) {
                    hitInfo.b = 0;
                    return hitInfo;
                }
                n15 = n6;
                n16 = n9;
            }
            if (n15 != n16) continue;
            hitInfo.b = 0;
            return hitInfo;
        }
        return null;
    }

    @Override
    public void setCodeEditor(CodeEditor codeEditor) {
        this.setMarginSupport(new CodeEditorMarginSupport(codeEditor));
        super.setCodeEditor(codeEditor);
    }

    protected static class HitInfo {
        FoldingSpan a;
        int b;

        protected HitInfo() {
        }
    }
}

