/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.LazyLoadDocument;
import com.jidesoft.editor.SyntaxDocument;
import com.jidesoft.search.FindAndReplaceTarget;
import com.jidesoft.search.FindResultIntepreter;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;

public class CodeEditorFindAndReplaceTarget
implements FindAndReplaceTarget,
DocumentListener {
    private CodeEditor a;
    private boolean b = false;
    private int c;
    private DocumentListener[] d;

    public CodeEditorFindAndReplaceTarget(CodeEditor codeEditor) {
        this.a = codeEditor;
        this.a.getDocument().addDocumentListener(this);
    }

    @Override
    public FindResultIntepreter getIntepreter() {
        return this.a;
    }

    public CodeEditor getCodeEditor() {
        return this.a;
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new JLabel(this.getResourceString("FindAndReplace.global"));
    }

    @Override
    public boolean hasNext() {
        return false;
    }

    @Override
    public void next() {
    }

    @Override
    public boolean hasPrevious() {
        return false;
    }

    @Override
    public void previous() {
    }

    @Override
    public int getCurrentPosition(boolean bl2) {
        CodeEditor[] codeEditorArray = SyntaxDocument.b();
        int n2 = this.getCodeEditor().getSelectionModel().hasSelection();
        if (codeEditorArray == null) {
            if (n2 != 0) {
                int n3 = bl2;
                if (codeEditorArray == null) {
                    n3 = n3 != 0 ? this.getCodeEditor().getSelectionEnd() : this.getCodeEditor().getSelectionStart();
                }
                return n3;
            }
            n2 = this.getCodeEditor().getCaretModel().getOffset();
        }
        return n2;
    }

    @Override
    public void adjustCurrentPosition(String string, boolean bl2) {
        block3: {
            int n2;
            block6: {
                int n3;
                block4: {
                    block5: {
                        CodeEditor[] codeEditorArray;
                        block2: {
                            codeEditorArray = SyntaxDocument.b();
                            n3 = this.getCodeEditor().getSelectionModel().hasSelection();
                            if (codeEditorArray != null) break block2;
                            if (n3 == 0) break block3;
                            n3 = bl2;
                        }
                        if (codeEditorArray != null) break block4;
                        if (n3 == 0) break block5;
                        n2 = this.getCodeEditor().getSelectionStart();
                        if (codeEditorArray == null) break block6;
                    }
                    n3 = this.getCodeEditor().getSelectionEnd();
                }
                n2 = n3;
            }
            this.getCodeEditor().select(n2, n2, true);
        }
    }

    @Override
    public void highlight(int n2, int n3) {
        this.getCodeEditor().a(n2, n3, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replace(int n2, int n3, String string) throws BadLocationException {
        CodeEditor[] codeEditorArray = SyntaxDocument.b();
        this.getCodeEditor().getDocument().beginCompoundEdit();
        try {
            this.getCodeEditor().getDocument().remove(n2, n3);
            this.getCodeEditor().getDocument().insertString(n2, string, null);
            this.getCodeEditor().getCaretModel().setOffset(n2 + string.length());
            CodeEditorFindAndReplaceTarget codeEditorFindAndReplaceTarget = this;
            if (codeEditorArray == null) {
                try {
                    if (codeEditorFindAndReplaceTarget.c > n2) {
                        this.c -= n3 - string.length();
                    }
                }
                catch (BadLocationException badLocationException) {
                    throw CodeEditorFindAndReplaceTarget.a(badLocationException);
                }
                codeEditorFindAndReplaceTarget = this;
            }
            codeEditorFindAndReplaceTarget.getCodeEditor().getDocument().endCompoundEdit();
        }
        catch (Throwable throwable) {
            this.getCodeEditor().getDocument().endCompoundEdit();
            throw throwable;
        }
    }

    @Override
    public Window getPromptDialogParent() {
        return JideSwingUtilities.getWindowForComponent(this.getCodeEditor());
    }

    @Override
    public Point getPromptDialogLocation(Rectangle rectangle) {
        Point point;
        block6: {
            Point point2;
            block7: {
                CodeEditor[] codeEditorArray = SyntaxDocument.b();
                CodeEditor codeEditor = this.getCodeEditor();
                if (codeEditorArray == null) {
                    if (!codeEditor.isChangePromptDialogPosition()) {
                        return null;
                    }
                    codeEditor = this.getCodeEditor();
                }
                Point point3 = codeEditor.getCaretLocation();
                point = point2 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), Math.min(point3.y + 50, this.getCodeEditor().getPainter().getHeight() - rectangle.height - 50));
                if (codeEditorArray != null) break block6;
                if (point.y > point3.y) break block7;
                point = point2;
                if (codeEditorArray != null) break block6;
                if (point.y + rectangle.height >= point3.y) {
                    point2.y = Math.max(0, point3.y - 50 - rectangle.height);
                }
            }
            SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
            point = point2;
        }
        return point;
    }

    @Override
    public Point getPromptDialogLocation() {
        Point point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 10));
        SwingUtilities.convertPointToScreen(point, this.getCodeEditor().getPainter());
        return point;
    }

    @Override
    public void scrollToShowCaret(Rectangle rectangle) {
        block9: {
            int n2;
            int n3;
            int n4;
            block11: {
                block12: {
                    CodeEditor[] codeEditorArray;
                    block15: {
                        int n5;
                        int n6;
                        block13: {
                            block14: {
                                Point point;
                                block10: {
                                    int n7;
                                    int n8;
                                    block8: {
                                        Point point2 = this.getCodeEditor().getCaretLocation();
                                        CodeEditor[] codeEditorArray2 = SyntaxDocument.b();
                                        SwingUtilities.convertPointToScreen(point2, this.getCodeEditor().getPainter());
                                        codeEditorArray = codeEditorArray2;
                                        n8 = rectangle.y;
                                        n7 = point2.y;
                                        if (codeEditorArray != null) break block8;
                                        if (n8 > n7) break block9;
                                        point = point2;
                                        if (codeEditorArray != null) break block10;
                                        n8 = point.y;
                                        n7 = rectangle.y + rectangle.height;
                                    }
                                    if (n8 > n7) break block9;
                                    point = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + 5));
                                }
                                Point point3 = point;
                                SwingUtilities.convertPointToScreen(point3, this.getCodeEditor().getPainter());
                                n4 = this.getCodeEditor().getCaretModel().getViewPosition().line;
                                n3 = rectangle.y;
                                n2 = point3.y;
                                if (codeEditorArray != null) break block11;
                                if (n3 > n2) break block12;
                                n3 = point3.y;
                                n2 = rectangle.y + rectangle.height;
                                if (codeEditorArray != null) break block11;
                                if (n3 > n2) break block12;
                                Point point4 = new Point(Math.min(100, this.getCodeEditor().getPainter().getWidth() / 3), this.getCodeEditor().lineToY(this.getCodeEditor().getFirstLine() + this.getCodeEditor().getVisibleLines() - 5));
                                SwingUtilities.convertPointToScreen(point4, this.getCodeEditor().getPainter());
                                n6 = rectangle.y;
                                n5 = point4.y;
                                if (codeEditorArray != null) break block13;
                                if (n6 > n5) break block14;
                                n6 = point4.y;
                                n5 = rectangle.y + rectangle.height;
                                if (codeEditorArray != null) break block13;
                                if (n6 <= n5) break block15;
                            }
                            n6 = n4;
                            n5 = this.getCodeEditor().getVisibleLines() - 5;
                        }
                        if (n6 >= n5) {
                            this.getCodeEditor().setFirstLine(n4 - this.getCodeEditor().getVisibleLines() + 5);
                        }
                    }
                    if (codeEditorArray == null) break block9;
                }
                n3 = n4;
                n2 = 5;
            }
            if (n3 >= n2) {
                this.getCodeEditor().setFirstLine(n4 - 5);
            }
        }
    }

    @Override
    public String getCurrentName() {
        return this.getCodeEditor().getName();
    }

    @Override
    public CharSequence getCurrentText() {
        CharSequence charSequence;
        block4: {
            CodeEditor codeEditor;
            block2: {
                block3: {
                    CodeEditor[] codeEditorArray = SyntaxDocument.b();
                    codeEditor = this.getCodeEditor();
                    if (codeEditorArray != null) break block2;
                    if (!(codeEditor.getDocument() instanceof LazyLoadDocument)) break block3;
                    charSequence = ((LazyLoadDocument)this.getCodeEditor().getDocument()).getLazyLoadText();
                    if (codeEditorArray == null) break block4;
                }
                codeEditor = this.getCodeEditor();
            }
            charSequence = codeEditor.getRawText();
        }
        this.setTargetChanged(false);
        return charSequence;
    }

    @Override
    public void showMessage(String string) {
        this.getCodeEditor().showMessage(string);
    }

    @Override
    public void replaceAllStarts() {
        block2: {
            this.getCodeEditor().getDocument().beginCompoundEdit();
            DocumentListener[] documentListenerArray = this.d = this.getCodeEditor().getDocument().getDocumentListeners();
            CodeEditor[] codeEditorArray = SyntaxDocument.b();
            for (DocumentListener documentListener : documentListenerArray) {
                this.getCodeEditor().getDocument().removeDocumentListener(documentListener);
                if (codeEditorArray == null) {
                    if (codeEditorArray == null) continue;
                }
                break block2;
            }
            this.c = this.getCodeEditor().getCaretModel().getOffset();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void replaceAllEnds() {
        CodeEditor[] codeEditorArray = SyntaxDocument.b();
        this.getCodeEditor().getDocument().endCompoundEdit();
        CodeEditorFindAndReplaceTarget codeEditorFindAndReplaceTarget = this;
        if (codeEditorArray == null) {
            if (codeEditorFindAndReplaceTarget.d != null) {
                DocumentEvent documentEvent = this.getCodeEditor().createReplaceAllDocumentEvent();
                for (DocumentListener documentListener : this.d) {
                    this.getCodeEditor().getDocument().addDocumentListener(documentListener);
                    documentListener.changedUpdate(documentEvent);
                    if (codeEditorArray != null) return;
                    if (codeEditorArray == null) continue;
                }
            }
            codeEditorFindAndReplaceTarget = this;
        }
        int n2 = codeEditorFindAndReplaceTarget.c;
        if (codeEditorArray != null || n2 < 0) return;
        this.getCodeEditor().getCaretModel().setOffset(this.c);
        n2 = this.getCodeEditor().scrollToCaret() ? 1 : 0;
    }

    protected void setTargetChanged(boolean bl2) {
        this.b = bl2;
    }

    @Override
    public boolean isTargetChanged() {
        return this.b;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.setTargetChanged(true);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public String getResourceString(String string) {
        return this.getCodeEditor().getResourceString(string);
    }

    @Override
    public Locale getLocale() {
        return this.getCodeEditor().getLocale();
    }

    private static BadLocationException a(BadLocationException badLocationException) {
        return badLocationException;
    }
}

