/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.style;

import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.style.AbstractStyle;
import com.jidesoft.chart.style.LineFillExtent;
import com.jidesoft.chart.xml.XmlBasicStrokeAdapter;
import com.jidesoft.chart.xml.XmlPaintAdapter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

public class LineStyle
extends AbstractStyle
implements Serializable {
    private static final long serialVersionUID = 3124081108916085212L;
    public static final int DEFAULT_WIDTH = 1;
    public static final BasicStroke DEFAULT_STROKE = new BasicStroke(1.0f, 2, 2);
    private transient BasicStroke a = DEFAULT_STROKE;
    private Paint c;
    private Orientation d = Orientation.vertical;
    private LineFillExtent e = LineFillExtent.TO_ZERO;

    public LineStyle() {
    }

    public LineStyle(int n2) {
        this.setWidth(n2);
    }

    public LineStyle(BasicStroke basicStroke) {
        this.setStroke(basicStroke);
    }

    public LineStyle(Color color, int n2) {
        super(color);
        this.setWidth(n2);
    }

    public LineStyle(Color color, BasicStroke basicStroke) {
        super(color);
        this.setStroke(basicStroke);
    }

    @XmlJavaTypeAdapter(value=XmlPaintAdapter.class)
    public Paint getFill() {
        return this.c;
    }

    public void setFill(Paint paint) {
        this.c = paint;
    }

    public void setFillOrientation(Orientation orientation) {
        this.d = orientation;
    }

    public Orientation getFillOrientation() {
        return this.d;
    }

    public LineFillExtent getFillExtent() {
        return this.e;
    }

    public void setFillExtent(LineFillExtent lineFillExtent) {
        this.e = lineFillExtent;
    }

    public void setWidth(int n2) {
        BasicStroke basicStroke = this.getStroke();
        BasicStroke basicStroke2 = new BasicStroke(n2, basicStroke.getEndCap(), basicStroke.getLineJoin(), basicStroke.getMiterLimit(), basicStroke.getDashArray(), basicStroke.getDashPhase());
        this.setStroke(basicStroke2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @XmlAttribute
    public int getWidth() {
        int n2 = AbstractStyle.c();
        BasicStroke basicStroke = this.a;
        if (n2 == 0) {
            if (basicStroke == null) {
                return 1;
            }
            basicStroke = this.a;
        }
        int n3 = (int)basicStroke.getLineWidth();
        return n3;
    }

    @XmlJavaTypeAdapter(value=XmlBasicStrokeAdapter.class)
    public BasicStroke getStroke() {
        int n2 = AbstractStyle.c();
        BasicStroke basicStroke = this.a;
        if (n2 == 0) {
            if (basicStroke == null) {
                this.a = DEFAULT_STROKE;
            }
            basicStroke = this.a;
        }
        return basicStroke;
    }

    public void setStroke(BasicStroke basicStroke) {
        this.a = basicStroke;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int hashCode() {
        var1_1 = AbstractStyle.b();
        var2_2 = super.hashCode();
        v0 = this.c;
        if (var1_1 == 0) ** GOTO lbl9
        if (v0 == null) {
            v1 = 0;
        } else {
            v0 = this.c;
lbl9:
            // 2 sources

            v1 = v0.hashCode();
        }
        var2_2 = 31 * var2_2 + v1;
        v2 = this.a;
        if (var1_1 == 0) ** GOTO lbl17
        if (v2 == null) {
            v3 = 0;
        } else {
            v2 = this.a;
lbl17:
            // 2 sources

            v3 = v2.hashCode();
        }
        var2_2 = 31 * var2_2 + v3;
        return var2_2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        LineStyle lineStyle;
        LineStyle lineStyle2;
        int n2;
        block20: {
            block21: {
                Paint paint;
                block18: {
                    block19: {
                        LineStyle lineStyle3;
                        block17: {
                            Object object2;
                            block16: {
                                n2 = AbstractStyle.b();
                                lineStyle3 = this;
                                object2 = object;
                                if (n2 == 0) break block16;
                                if (lineStyle3 == object2) {
                                    return true;
                                }
                                lineStyle3 = this;
                                if (n2 == 0) break block17;
                                object2 = object;
                            }
                            if (!super.equals(object2)) {
                                return false;
                            }
                            lineStyle3 = this;
                        }
                        Object object3 = lineStyle3.getClass();
                        if (n2 != 0) {
                            if (object3 != object.getClass()) {
                                return false;
                            }
                            object3 = object;
                        }
                        lineStyle2 = (LineStyle)object3;
                        paint = this.c;
                        if (n2 == 0) break block18;
                        if (paint != null) break block19;
                        lineStyle = lineStyle2;
                        if (n2 == 0) break block20;
                        if (lineStyle.c != null) {
                            return false;
                        }
                        break block21;
                    }
                    lineStyle = this;
                    if (n2 == 0) break block20;
                    paint = lineStyle.c;
                }
                if (!paint.equals(lineStyle2.c)) {
                    return false;
                }
            }
            lineStyle = this;
        }
        BasicStroke basicStroke = lineStyle.a;
        if (n2 != 0) {
            if (basicStroke == null) {
                if (lineStyle2.a == null) return true;
                return false;
            }
            basicStroke = this.a;
        }
        boolean bl2 = basicStroke.equals(lineStyle2.a);
        if (n2 == 0) return bl2;
        if (bl2) return true;
        return false;
    }

    private String a(BasicStroke basicStroke) {
        int n2 = AbstractStyle.c();
        BasicStroke basicStroke2 = basicStroke;
        if (n2 == 0) {
            if (basicStroke2 == null) {
                return "<null>";
            }
            basicStroke2 = basicStroke;
        }
        float f2 = basicStroke2.getLineWidth();
        float f3 = basicStroke.getMiterLimit();
        int n3 = basicStroke.getLineJoin();
        int n4 = basicStroke.getEndCap();
        float f4 = basicStroke.getDashPhase();
        return String.format("#<BasicStroke lineWidth=%f miterLimit=%f lineJoin=%d endCap=%d dashPhase=%f>", Float.valueOf(f2), Float.valueOf(f3), n3, n4, Float.valueOf(f4));
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        var1_1 = AbstractStyle.c();
        v0 = this;
        if (var1_1 != 0) ** GOTO lbl8
        if (v0.a == null) {
            v1 = null;
        } else {
            v0 = this;
lbl8:
            // 2 sources

            v1 = v0.a(this.a);
        }
        var2_2 = v1;
        return String.format("#<LineStyle width=%d stroke=%s color=%s fill=%s>", new Object[]{this.getWidth(), var2_2, this.getColor(), this.getFill()});
    }
}

