/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.api.agent;

public class TrackingOptions {
    public static final TrackingOptions NONE = new TrackingOptions().freeze();
    public static final TrackingOptions PLATFORM_THREAD = new TrackingOptions().platformThread(true).freeze();
    public static final TrackingOptions EXECUTORS = new TrackingOptions().executors(true).freeze();
    public static final TrackingOptions AWT = new TrackingOptions().awt(true).freeze();
    public static final TrackingOptions SWT = new TrackingOptions().swt(true).freeze();
    public static final TrackingOptions RMI = new TrackingOptions().rmi(true).freeze();
    public static final TrackingOptions GRPC = new TrackingOptions().grpc(true).freeze();
    public static final TrackingOptions REMOTE_EJB = new TrackingOptions().remoteEjb(true).freeze();
    public static final TrackingOptions HTTP = new TrackingOptions().http(true).freeze();
    public static final TrackingOptions KOTLIN_COROUTINES = new TrackingOptions().kotlinCoroutines(true).freeze();
    public static final TrackingOptions VIRTUAL_THREAD = new TrackingOptions().virtualThread(true).freeze();
    private boolean platformThread = false;
    private boolean virtualThread = false;
    private boolean executors = false;
    private boolean awt = false;
    private boolean swt = false;
    private boolean rmi = false;
    private boolean grpc = false;
    private boolean remoteEjb = false;
    private boolean http = false;
    private boolean kotlinCoroutines = false;
    private boolean frozen = false;

    public TrackingOptions platformThread(boolean bl) {
        this.checkFrozen();
        this.platformThread = bl;
        return this;
    }

    public TrackingOptions virtualThread(boolean bl) {
        this.checkFrozen();
        this.virtualThread = bl;
        return this;
    }

    public TrackingOptions executors(boolean bl) {
        this.checkFrozen();
        this.executors = bl;
        return this;
    }

    public TrackingOptions awt(boolean bl) {
        this.checkFrozen();
        this.awt = bl;
        return this;
    }

    public TrackingOptions swt(boolean bl) {
        this.checkFrozen();
        this.swt = bl;
        return this;
    }

    public TrackingOptions rmi(boolean bl) {
        this.checkFrozen();
        this.rmi = bl;
        return this;
    }

    public TrackingOptions grpc(boolean bl) {
        this.checkFrozen();
        this.grpc = bl;
        return this;
    }

    public TrackingOptions http(boolean bl) {
        this.checkFrozen();
        this.http = bl;
        return this;
    }

    public TrackingOptions remoteEjb(boolean bl) {
        this.checkFrozen();
        this.remoteEjb = bl;
        return this;
    }

    public TrackingOptions kotlinCoroutines(boolean bl) {
        this.checkFrozen();
        this.kotlinCoroutines = bl;
        return this;
    }

    public boolean isPlatformThread() {
        return this.platformThread;
    }

    public boolean isVirtualThread() {
        return this.virtualThread;
    }

    public boolean isExecutors() {
        return this.executors;
    }

    public boolean isAwt() {
        return this.awt;
    }

    public boolean isSwt() {
        return this.swt;
    }

    public boolean isRemoteEjb() {
        return this.remoteEjb;
    }

    public boolean isHttp() {
        return this.http;
    }

    public boolean isRmi() {
        return this.rmi;
    }

    public boolean isGrpc() {
        return this.grpc;
    }

    public boolean isKotlinCoroutines() {
        return this.kotlinCoroutines;
    }

    public TrackingOptions freeze() {
        this.frozen = true;
        return this;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException("parameters are frozen");
        }
    }
}

