/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.util;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;

class ScriptClassLoader
extends ClassLoader {
    private Map<String, byte[]> byteResourceMap;

    ScriptClassLoader(ClassLoader parent) {
        super(parent);
    }

    void setByteResource(Map<String, byte[]> byteResourceMap) {
        this.byteResourceMap = byteResourceMap;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("com.jprofiler.agent.__JProfiler_")) {
            if (this.byteResourceMap != null && this.byteResourceMap.containsKey(name)) {
                return this.defineClass(name, this.byteResourceMap.get(name));
            }
            throw new ClassNotFoundException("no byte map entry for " + name + ": " + this.byteResourceMap);
        }
        return super.findClass(name);
    }

    private Class defineClass(String name, byte[] data) throws ClassNotFoundException {
        try {
            return AccessController.doPrivileged(() -> this.defineClass(name, data, 0, data.length));
        }
        catch (PrivilegedActionException pae) {
            throw (ClassNotFoundException)pae.getException();
        }
    }
}

