# Rule to save runtime annotations on serializable class.
# If the R8 full mode is used, annotations are removed from classes-files.
#
# For the annotation serializer, it is necessary to read the `Serializable` annotation inside the serializer<T>() function - if it is present,
# then `SealedClassSerializer` is used, if absent, then `PolymorphicSerializer'.
#
# When using R8 full mode, all interfaces will be serialized using `PolymorphicSerializer`.
#
# see https://github.com/Kotlin/kotlinx.serialization/issues/2050

 -if @kotlinx.serialization.Serializable class **
 -keep, allowshrinking, allowoptimization, allowobfuscation, allowaccessmodification class <1>

# Rule to save runtime annotations on named companion class.
# If the R8 full mode is used, annotations are removed from classes-files.
-if @kotlinx.serialization.internal.NamedCompanion class *
-keep, allowshrinking, allowoptimization, allowobfuscation, allowaccessmodification class <1>

# Rule to save INSTANCE field and serializer function for Kotlin serializable objects.
#
# R8 full mode works differently if the instance is not explicitly accessed in the code.
#
# see https://github.com/Kotlin/kotlinx.serialization/issues/2861
# see https://issuetracker.google.com/issues/379996140

-keepclassmembers @kotlinx.serialization.Serializable class ** {
    public static ** INSTANCE;
    kotlinx.serialization.KSerializer serializer(...);
}
