/*
 * Copyright 2026 ej-technologies GmbH
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */
package com.jprofiler.api.probe.injected.parameter;

import com.jprofiler.api.probe.injected.interception.AdditionalInterception;
import com.jprofiler.api.probe.injected.interception.Interception;
import com.jprofiler.api.probe.injected.interception.PayloadInterception;
import com.jprofiler.api.probe.injected.interception.SplitInterception;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Assigns the argument with index {@link #value()} of the intercepted method to a parameter of a probe method. The probe method can be annotated with
 * {@link Interception}, {@link PayloadInterception}, {@link SplitInterception} or {@link AdditionalInterception}.
 * The type of the annotated parameter must be {@code Object} or the declared type of the parameter of the instrumented method. The declared type can only
 * be used if it can be resolved by the system class loader.
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.PARAMETER)
public @interface Parameter {
    /**
     * The zero-based index of the parameter
     * @return the index
     */
    int value();
}
