package com.jprofiler.api.agent.heap;

import org.jetbrains.annotations.Nullable;

import java.nio.ByteBuffer;

/**
 * Represents a primitive array from a heap dump. Provides access to the data stored in the array.
 */
public interface PrimitiveArray extends HeapObject {
    /**
     * Reads the data stored in this primitive array as a {@link ByteBuffer}. You can use
     * {@link ByteBuffer#asIntBuffer()} etc. to access the values of the array.
     * For JProfiler heap dumps, the data will be limited to the first 10.000 elements.
     *
     * @return A {@link ByteBuffer} representation of the data in this primitive array,
     *         or {@code null} if the data is not available.
     */
    @Nullable
    ByteBuffer readData();
}
