package com.jprofiler.api.agent;

/**
 * Represents a request to an LLM model.
 */
public interface ModelRequest {

    /**
     * Retrieves the type of the model request.
     *
     * @return the type of the model request, represented as a {@link ModelRequestType}.
     */
    ModelRequestType type();

    /**
     * Retrieves the name of the model.
     * @return the name of the model
     */
    String modelName();

    /**
     * Retrieves the number of instructions in the model request.
     * @return the number of instructions
     */
    int instructionCount();

    /**
     * Retrieves the instruction type at the specified index. Use {@link #instructionCount()} to determine valid index values.
     * @param index the index of the instruction to retrieve
     * @return the type
     */
    ModelInstructionType instructionType(int index);

    /**
     * Retrieves the instruction at the specified index. Use {@link #instructionCount()}to determine valid index values.
     * @param index the index of the instruction to retrieve
     * @return the instruction text
     */
    String instruction(int index);
}