/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.api.platform.util;

import com.jprofiler.api.platform.connection.Connection;
import com.jprofiler.api.platform.descriptors.Descriptor;
import com.jprofiler.api.platform.structures.Payload;
import com.jprofiler.api.platform.structures.Tree;
import com.jprofiler.core.b.g.b;
import com.jprofiler.core.h.g;
import com.jprofiler.core.util.a;
import com.jprofiler.core.util.i;
import java.util.Iterator;

public abstract class TreePrinter {
    private TreePrinter() {
    }

    public static String getIndentedTree(final Connection connection, Tree tree) {
        final StringBuffer stringBuffer = new StringBuffer();
        ((g)tree).b((i<g>)new a<g>(){
            private int indentation = 0;

            @Override
            public boolean preVisit(g g2) {
                stringBuffer.append(" ".repeat(this.indentation));
                Descriptor descriptor = ((b)connection).a(g2.k());
                if (descriptor == null) {
                    stringBuffer.append("***");
                } else {
                    stringBuffer.append(descriptor.getDescription());
                }
                if (g2.getLineNumber() > 0) {
                    stringBuffer.append(" (line: ");
                    stringBuffer.append(g2.getLineNumber());
                    stringBuffer.append(")");
                }
                stringBuffer.append(": ");
                stringBuffer.append(g2.getValue());
                stringBuffer.append(" (").append(g2.x()).append(")");
                TreePrinter.printPayload(stringBuffer, this.indentation, g2);
                stringBuffer.append("\n");
                this.indentation += 3;
                return true;
            }

            @Override
            public void postVisit(g g2) {
                this.indentation -= 3;
            }
        });
        return stringBuffer.toString();
    }

    private static void printPayload(StringBuffer stringBuffer, int n2, Tree tree) {
        Iterator<Payload> iterator = tree.getPayloadIterator();
        while (iterator.hasNext()) {
            Payload payload = iterator.next();
            stringBuffer.append("\n");
            stringBuffer.append(" ".repeat(n2 + 3));
            stringBuffer.append(payload.getDescription()).append(" (type: ").append(payload.getType()).append(")");
        }
    }
}

