/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.Util;
import com.esotericsoftware.minlog.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeUtil {
    private static final Unsafe _unsafe;
    public static final long byteArrayBaseOffset;
    public static final long floatArrayBaseOffset;
    public static final long doubleArrayBaseOffset;
    public static final long intArrayBaseOffset;
    public static final long longArrayBaseOffset;
    public static final long shortArrayBaseOffset;
    public static final long charArrayBaseOffset;
    public static final long bufferAddressOffset;
    static Constructor<? extends ByteBuffer> directByteBufferConstr;
    private static Method cleanerMethod;
    private static Method cleanMethod;

    public static final Unsafe unsafe() {
        return _unsafe;
    }

    public static Field[] sortFieldsByOffset(List<Field> allFields) {
        Field[] allFieldsArray = allFields.toArray(new Field[0]);
        Comparator<Field> fieldOffsetComparator = new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                long offset2;
                long offset1 = UnsafeUtil.unsafe().objectFieldOffset(f1);
                if (offset1 < (offset2 = UnsafeUtil.unsafe().objectFieldOffset(f2))) {
                    return -1;
                }
                if (offset1 == offset2) {
                    return 0;
                }
                return 1;
            }
        };
        Arrays.sort(allFieldsArray, fieldOffsetComparator);
        for (Field f : allFields) {
            if (!Log.TRACE) continue;
            Log.trace((String)"kryo", (String)("Field '" + f.getName() + "' at offset " + UnsafeUtil.unsafe().objectFieldOffset(f)));
        }
        return allFieldsArray;
    }

    public static final ByteBuffer getDirectBufferAt(long address, int size) {
        if (directByteBufferConstr == null) {
            return null;
        }
        try {
            return directByteBufferConstr.newInstance(address, size, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot allocate ByteBuffer at a given address: " + address, e);
        }
    }

    public static final long getAddress(ByteBuffer byteBuffer) {
        if (_unsafe != null && bufferAddressOffset != 0L) {
            return _unsafe.getLong(byteBuffer, bufferAddressOffset);
        }
        if (byteBuffer instanceof DirectBuffer) {
            return ((DirectBuffer)((Object)byteBuffer)).address();
        }
        return 0L;
    }

    public static void releaseBuffer(ByteBuffer buffer) {
        if (!(buffer instanceof DirectBuffer)) {
            return;
        }
        if (cleanerMethod != null) {
            try {
                cleanMethod.invoke(cleanerMethod.invoke((Object)buffer, new Object[0]), new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        long tmpBufferAddressOffset;
        long tmpCharArrayBaseOffset;
        long tmpShortArrayBaseOffset;
        long tmpLongArrayBaseOffset;
        long tmpIntArrayBaseOffset;
        long tmpDoubleArrayBaseOffset;
        long tmpFloatArrayBaseOffset;
        long tmpByteArrayBaseOffset;
        Unsafe tmpUnsafe;
        block15: {
            tmpUnsafe = null;
            tmpByteArrayBaseOffset = 0L;
            tmpFloatArrayBaseOffset = 0L;
            tmpDoubleArrayBaseOffset = 0L;
            tmpIntArrayBaseOffset = 0L;
            tmpLongArrayBaseOffset = 0L;
            tmpShortArrayBaseOffset = 0L;
            tmpCharArrayBaseOffset = 0L;
            tmpBufferAddressOffset = 0L;
            try {
                if (!Util.IS_ANDROID) {
                    Field field = Unsafe.class.getDeclaredField("theUnsafe");
                    field.setAccessible(true);
                    tmpUnsafe = (Unsafe)field.get(null);
                    tmpByteArrayBaseOffset = tmpUnsafe.arrayBaseOffset(byte[].class);
                    tmpCharArrayBaseOffset = tmpUnsafe.arrayBaseOffset(char[].class);
                    tmpShortArrayBaseOffset = tmpUnsafe.arrayBaseOffset(short[].class);
                    tmpIntArrayBaseOffset = tmpUnsafe.arrayBaseOffset(int[].class);
                    tmpFloatArrayBaseOffset = tmpUnsafe.arrayBaseOffset(float[].class);
                    tmpLongArrayBaseOffset = tmpUnsafe.arrayBaseOffset(long[].class);
                    tmpDoubleArrayBaseOffset = tmpUnsafe.arrayBaseOffset(double[].class);
                    try {
                        Field address = Buffer.class.getDeclaredField("address");
                        if (address.getType() == Long.TYPE) {
                            tmpBufferAddressOffset = tmpUnsafe.objectFieldOffset(address);
                        }
                        break block15;
                    }
                    catch (Throwable t) {
                        if (Log.TRACE) {
                            Log.trace((String)"kryo", (String)"Buffer.address is not available.");
                        }
                        break block15;
                    }
                }
                if (Log.TRACE) {
                    Log.trace((String)"kryo", (String)"Running on Android platform. Use of sun.misc.Unsafe should be disabled");
                }
            }
            catch (Exception e) {
                if (!Log.TRACE) break block15;
                Log.trace((String)"kryo", (String)"sun.misc.Unsafe is not accessible or not available. Use of sun.misc.Unsafe should be disabled");
            }
        }
        byteArrayBaseOffset = tmpByteArrayBaseOffset;
        charArrayBaseOffset = tmpCharArrayBaseOffset;
        shortArrayBaseOffset = tmpShortArrayBaseOffset;
        intArrayBaseOffset = tmpIntArrayBaseOffset;
        floatArrayBaseOffset = tmpFloatArrayBaseOffset;
        longArrayBaseOffset = tmpLongArrayBaseOffset;
        doubleArrayBaseOffset = tmpDoubleArrayBaseOffset;
        bufferAddressOffset = tmpBufferAddressOffset;
        _unsafe = tmpUnsafe;
        if (Util.useBufferReflection) {
            try {
                cleanerMethod = Class.forName("sun.nio.ch.DirectBuffer").getMethod("cleaner", new Class[0]);
                cleanerMethod.setAccessible(true);
                cleanMethod = cleanerMethod.getReturnType().getMethod("clean", new Class[0]);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (Log.DEBUG) {
                    Log.debug((String)"kryo", (String)"No direct ByteBuffer clean method is available.", (Throwable)ex);
                }
                cleanerMethod = null;
            }
        }
        if (Util.useBufferReflection) {
            ByteBuffer buf = ByteBuffer.allocateDirect(1);
            try {
                directByteBufferConstr = buf.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
                directByteBufferConstr.setAccessible(true);
            }
            catch (Throwable e) {
                directByteBufferConstr = null;
            }
        }
    }
}

