/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.agent.triggers.actions;

import com.jprofiler.agent.ControllerImpl;
import com.jprofiler.agent.triggers.actions.ImmediateAction;
import com.jprofiler.agent.triggers.actions.TriggerAction;
import com.jprofiler.agent.triggers.nanoxml.XMLElement;
import com.jprofiler.api.agent.HeapDumpOptions;

public class TriggerHeapdumpAction
extends TriggerAction
implements ImmediateAction {
    public static final boolean DEFAULT_FULL_GC = true;
    public static final boolean DEFAULT_ONLY_RECORDED_OBJECTS = false;
    public static final boolean DEFAULT_CALCULATE_RETAINED_SIZES = true;
    public static final boolean DEFAULT_RETAIN_SOFT_REFERENCES = true;
    public static final boolean DEFAULT_RETAIN_WEAK_REFERENCES = false;
    public static final boolean DEFAULT_RETAIN_PHANTOM_REFERENCES = false;
    public static final boolean DEFAULT_RETAIN_FINALIZER_REFERENCES = false;
    public static final String PRIMITIVE_DEFAULT = "default";
    public static final String PRIMITIVE_TRUE = "true";
    public static final String PRIMITIVE_FALSE = "false";
    private HeapDumpOptions heapDumpOptions = new HeapDumpOptions();

    public TriggerHeapdumpAction(XMLElement xMLElement) {
        this.heapDumpOptions.fullGc(xMLElement.getBooleanAttribute("fullGc", true));
        this.heapDumpOptions.selectRecorded(xMLElement.getBooleanAttribute("onlyRecordedObjects", false));
        String string = xMLElement.getStringAttribute("primitiveData");
        if (string == null) {
            string = !xMLElement.getBooleanAttribute("recordPrimitiveData", true) ? PRIMITIVE_FALSE : PRIMITIVE_DEFAULT;
        }
        if (string.equals(PRIMITIVE_FALSE)) {
            this.heapDumpOptions.primitiveData(false);
        } else if (string.equals(PRIMITIVE_TRUE)) {
            this.heapDumpOptions.primitiveData(true);
        }
        this.heapDumpOptions.calculateRetainedSizes(xMLElement.getBooleanAttribute("calculateRetainedSizes", true));
        this.heapDumpOptions.retainSoftReferences(xMLElement.getBooleanAttribute("retainSoftReferences", true));
        this.heapDumpOptions.retainWeakReferences(xMLElement.getBooleanAttribute("retainWeakReferences", false));
        this.heapDumpOptions.retainPhantomReferences(xMLElement.getBooleanAttribute("retainPhantomReferences", false));
        this.heapDumpOptions.retainFinalizerReferences(xMLElement.getBooleanAttribute("retainFinalizerReferences", false));
    }

    @Override
    public void execute(boolean bl2) {
        ControllerImpl.triggerHeapDump(this.heapDumpOptions);
    }

    @Override
    public void executeImmediate() {
        ControllerImpl.triggerHeapDump(this.heapDumpOptions, true);
    }
}

