/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization;

import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\b\u0007\u0018\u00002\u00020\u0001B5\bB\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nB\u001f\bV\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000bB\u0019\bV\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\rB+\bW\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\u000eB\u0011\bQ\u0012\u0006\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0004\b\t\u0010\u000fJ\u0017\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0080\u0080\u0004\u00a2\u0006\u0002\b\u0016R\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\u0004\u0018\u00010\u0003X\u0086\u0084\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lkotlinx/serialization/MissingFieldException;", "Lkotlinx/serialization/SerializationException;", "message", "", "cause", "", "missingFields", "", "serialName", "<init>", "(Ljava/lang/String;Ljava/lang/Throwable;Ljava/util/List;Ljava/lang/String;)V", "(Ljava/util/List;Ljava/lang/String;)V", "missingField", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/Throwable;)V", "(Ljava/lang/String;)V", "getMissingFields", "()Ljava/util/List;", "getSerialName", "()Ljava/lang/String;", "withNewMessageInternal", "newMessage", "withNewMessageInternal$kotlinx_serialization_core", "kotlinx-serialization-core"})
public final class MissingFieldException
extends SerializationException {
    @NotNull
    private final List<String> missingFields;
    @Nullable
    private final String serialName;

    private MissingFieldException(String message, Throwable cause, List<String> missingFields, String serialName) {
        super(message, cause);
        this.missingFields = missingFields;
        this.serialName = serialName;
    }

    @NotNull
    public final List<String> getMissingFields() {
        return this.missingFields;
    }

    @Nullable
    public final String getSerialName() {
        return this.serialName;
    }

    public MissingFieldException(@NotNull List<String> missingFields, @NotNull String serialName) {
        Intrinsics.checkNotNullParameter(missingFields, (String)"missingFields");
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        String string = missingFields.size() == 1 ? "Field '" + missingFields.get(0) + "' is required for type with serial name '" + serialName + "', but it was missing" : "Fields " + missingFields + " are required for type with serial name '" + serialName + "', but they were missing";
        this(string, null, missingFields, serialName);
    }

    public MissingFieldException(@NotNull String missingField, @NotNull String serialName) {
        Intrinsics.checkNotNullParameter((Object)missingField, (String)"missingField");
        Intrinsics.checkNotNullParameter((Object)serialName, (String)"serialName");
        List list = CollectionsKt.listOf((Object)missingField);
        String string = "Field '" + missingField + "' is required for type with serial name '" + serialName + "', but it was missing";
        this(string, null, list, serialName);
    }

    @Deprecated(message="Use constructor which accepts serialName parameter", replaceWith=@ReplaceWith(expression="MissingFieldException(missingFields, descriptor.serialName, message, cause)", imports={}), level=DeprecationLevel.ERROR)
    public MissingFieldException(@NotNull List<String> missingFields, @Nullable String message, @Nullable Throwable cause) {
        Intrinsics.checkNotNullParameter(missingFields, (String)"missingFields");
        this(message, cause, missingFields, null);
    }

    @Deprecated(message="Constructor used by the serializers generated by plugins older than Kotlin 1.5", level=DeprecationLevel.HIDDEN)
    @PublishedApi
    public /* synthetic */ MissingFieldException(String missingField) {
        Intrinsics.checkNotNullParameter((Object)missingField, (String)"missingField");
        this("Field '" + missingField + "' is required, but it was missing", null, CollectionsKt.listOf((Object)missingField), null);
    }

    @NotNull
    public final MissingFieldException withNewMessageInternal$kotlinx_serialization_core(@NotNull String newMessage) {
        Intrinsics.checkNotNullParameter((Object)newMessage, (String)"newMessage");
        return new MissingFieldException(newMessage, (Throwable)this, this.missingFields, this.serialName);
    }
}

