/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.file.internal.fs;

import io.matthewnelson.kmp.file.AbstractFileStream;
import io.matthewnelson.kmp.file.DirectoryNotEmptyException;
import io.matthewnelson.kmp.file.FsInfo;
import io.matthewnelson.kmp.file.NotDirectoryException;
import io.matthewnelson.kmp.file.OpenExcl;
import io.matthewnelson.kmp.file.internal.Mode;
import io.matthewnelson.kmp.file.internal.NioFileStream;
import io.matthewnelson.kmp.file.internal._JvmPlatformKt;
import io.matthewnelson.kmp.file.internal._ModeKt;
import io.matthewnelson.kmp.file.internal.fs.Fs;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.nio.channels.FileChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u00172\u00020\u0001:\u0003\u0017\u0018\u0019B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\tH\u0004J<\u0010\n\u001a\u00020\u000b*\u00060\bj\u0002`\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0004J\u0011\u0010\u0015\u001a\u00020\u0016*\u00060\bj\u0002`\tH\u0084\b\u00a8\u0006\u001a"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio;", "Lio/matthewnelson/kmp/file/internal/fs/Fs$Jvm;", "info", "Lio/matthewnelson/kmp/file/FsInfo;", "(Lio/matthewnelson/kmp/file/FsInfo;)V", "mapNioException", "", "file", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "openNio", "Lio/matthewnelson/kmp/file/internal/NioFileStream;", "excl", "Lio/matthewnelson/kmp/file/OpenExcl;", "isAppending", "", "options", "", "Ljava/nio/file/StandardOpenOption;", "attrs", "Ljava/nio/file/attribute/FileAttribute;", "toNioPath", "Ljava/nio/file/Path;", "Companion", "NonPosix", "Posix", "io.matthewnelson.kmp-file_file_jvm"})
@SourceDebugExtension(value={"SMAP\n-FsJvmNio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio\n+ 2 Exceptions.kt\nio/matthewnelson/kmp/file/Exceptions\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -KmpFileConfig.kt\nio/matthewnelson/kmp/file/internal/_KmpFileConfigKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 KmpFile.kt\nio/matthewnelson/kmp/file/KmpFile\n+ 7 -JvmException.kt\nio/matthewnelson/kmp/file/internal/_JvmExceptionKt\n*L\n1#1,374:1\n337#1,4:375\n341#1:385\n143#2,3:379\n146#2,2:383\n143#2,3:390\n146#2,2:394\n1#3:382\n1#3:393\n9#4:386\n9#4:387\n37#5,2:388\n83#6:396\n83#6:401\n83#6:410\n31#7,2:397\n31#7,2:399\n31#7,2:402\n31#7,2:404\n31#7,2:406\n31#7,2:408\n31#7,2:411\n27#7,6:413\n*S KotlinDebug\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio\n*L\n304#1:375,4\n304#1:385\n304#1:379,3\n304#1:383,2\n340#1:390,3\n340#1:394,2\n304#1:382\n340#1:393\n318#1:386\n321#1:387\n325#1:388,2\n346#1:396\n349#1:401\n360#1:410\n346#1:397,2\n348#1:399,2\n349#1:402,2\n351#1:404,2\n352#1:406,2\n358#1:408,2\n360#1:411,2\n370#1:413,6\n*E\n"})
public abstract class FsJvmNio
extends Fs.Jvm {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FsJvmNio(FsInfo info) {
        super(info, null);
    }

    @NotNull
    protected final NioFileStream openNio(@NotNull File $this$openNio, @NotNull OpenExcl excl, boolean isAppending, @NotNull Set<StandardOpenOption> options, @Nullable FileAttribute<?> attrs) throws IOException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$openNio, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        FsJvmNio fsJvmNio = this;
        File $this$toNioPath$iv = $this$openNio;
        boolean $i$f$toNioPath = false;
        try {
            object = $this$toNioPath$iv.toPath();
            Intrinsics.checkNotNull((Object)object);
        }
        catch (InvalidPathException e$iv) {
            IOException iOException;
            Throwable $this$wrapIOException$iv$iv = e$iv;
            boolean $i$f$wrapIO = false;
            Throwable throwable = $this$wrapIOException$iv$iv;
            if (throwable instanceof IOException) {
                iOException = (IOException)$this$wrapIOException$iv$iv;
            } else if (throwable instanceof InterruptedException) {
                InterruptedIOException interruptedIOException;
                InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                iOException = interruptedIOException;
            } else {
                iOException = new IOException($this$wrapIOException$iv$iv);
            }
            throw iOException;
        }
        FileAttribute[] path = object;
        OpenExcl this_$iv = excl;
        if (this_$iv instanceof OpenExcl.MaybeCreate) {
            options.add(StandardOpenOption.CREATE);
        } else if (this_$iv instanceof OpenExcl.MustCreate) {
            options.add(StandardOpenOption.CREATE_NEW);
        } else if (this_$iv instanceof OpenExcl.MustExist) {
            // empty if block
        }
        boolean canRead = options.contains(StandardOpenOption.READ);
        boolean canWrite = options.contains(StandardOpenOption.WRITE);
        boolean $i$f$disappearingCheck = false;
        $i$f$disappearingCheck = false;
        try {
            FileChannel fileChannel;
            if (attrs == null) {
                Collection $this$toTypedArray$iv = options;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                object = thisCollection$iv.toArray(new StandardOpenOption[0]);
                fileChannel = FileChannel.open((Path)path, (OpenOption[])Arrays.copyOf(object, ((FileAttribute[])object).length));
            } else {
                object = new FileAttribute[]{attrs};
                fileChannel = FileChannel.open((Path)path, options, object);
            }
            object = fileChannel;
        }
        catch (Throwable t) {
            throw this.mapNioException(t, $this$openNio);
        }
        Object ch = object;
        Intrinsics.checkNotNull((Object)ch);
        object = new Closeable[]{};
        return NioFileStream.Companion.of$io_matthewnelson_kmp_file_file_jvm((FileChannel)ch, canRead, canWrite, isAppending, (Closeable[])Arrays.copyOf(object, ((FileAttribute[])object).length));
    }

    @NotNull
    protected final Path toNioPath(@NotNull File $this$toNioPath) throws IOException {
        Path path;
        Intrinsics.checkNotNullParameter((Object)$this$toNioPath, (String)"<this>");
        boolean $i$f$toNioPath = false;
        try {
            path = $this$toNioPath.toPath();
            Intrinsics.checkNotNull((Object)path);
        }
        catch (InvalidPathException e) {
            IOException iOException;
            Throwable $this$wrapIOException$iv = e;
            boolean $i$f$wrapIO = false;
            Throwable throwable = $this$wrapIOException$iv;
            if (throwable instanceof IOException) {
                iOException = (IOException)$this$wrapIOException$iv;
            } else if (throwable instanceof InterruptedException) {
                InterruptedIOException interruptedIOException;
                InterruptedIOException it$iv = interruptedIOException = new InterruptedIOException();
                boolean bl = false;
                ExceptionsKt.addSuppressed((Throwable)it$iv, (Throwable)$this$wrapIOException$iv);
                iOException = interruptedIOException;
            } else {
                iOException = new IOException($this$wrapIOException$iv);
            }
            throw iOException;
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final Throwable mapNioException(@NotNull Throwable $this$mapNioException, @NotNull File file) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter((Object)$this$mapNioException, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Throwable throwable2 = $this$mapNioException;
        if (throwable2 instanceof FileSystemException) {
            IOException iOException;
            Throwable throwable3 = $this$mapNioException;
            if (throwable3 instanceof AccessDeniedException) {
                void $this$alsoAddSuppressed$iv;
                File file2;
                String string = ((AccessDeniedException)$this$mapNioException).getOtherFile();
                if (string != null) {
                    String $this$toFile$iv = string;
                    boolean $i$f$get = false;
                    file2 = new File($this$toFile$iv);
                } else {
                    file2 = null;
                }
                Throwable throwable4 = (Throwable)new kotlin.io.AccessDeniedException(file, file2, ((AccessDeniedException)$this$mapNioException).getReason());
                Throwable t$iv = $this$mapNioException;
                boolean $i$f$alsoAddSuppressed = false;
                ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                iOException = (IOException)$this$alsoAddSuppressed$iv;
            } else if (throwable3 instanceof java.nio.file.DirectoryNotEmptyException) {
                Throwable $this$alsoAddSuppressed$iv = (Throwable)((Object)new DirectoryNotEmptyException(file));
                Throwable t$iv = $this$mapNioException;
                boolean $i$f$alsoAddSuppressed = false;
                ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                iOException = (IOException)$this$alsoAddSuppressed$iv;
            } else if (throwable3 instanceof FileAlreadyExistsException) {
                File file3;
                String string = ((FileAlreadyExistsException)$this$mapNioException).getOtherFile();
                if (string != null) {
                    String $this$toFile$iv = string;
                    boolean $i$f$get = false;
                    file3 = new File($this$toFile$iv);
                } else {
                    file3 = null;
                }
                Throwable $this$alsoAddSuppressed$iv = (Throwable)new kotlin.io.FileAlreadyExistsException(file, file3, ((FileAlreadyExistsException)$this$mapNioException).getReason());
                Throwable t$iv = $this$mapNioException;
                boolean $i$f$alsoAddSuppressed = false;
                ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                iOException = (IOException)$this$alsoAddSuppressed$iv;
            } else if (throwable3 instanceof NoSuchFileException) {
                Throwable $this$alsoAddSuppressed$iv = new FileNotFoundException($this$mapNioException.getMessage());
                Throwable t$iv = $this$mapNioException;
                boolean $i$f$alsoAddSuppressed = false;
                ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                iOException = (IOException)$this$alsoAddSuppressed$iv;
            } else if (throwable3 instanceof java.nio.file.NotDirectoryException) {
                Throwable $this$alsoAddSuppressed$iv = (Throwable)((Object)new NotDirectoryException(file));
                Throwable t$iv = $this$mapNioException;
                boolean $i$f$alsoAddSuppressed = false;
                ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                iOException = (IOException)$this$alsoAddSuppressed$iv;
            } else if (Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass($this$mapNioException.getClass()).getQualifiedName(), (Object)"java.nio.file.FileSystemException")) {
                kotlin.io.FileSystemException fileSystemException;
                String string = ((FileSystemException)$this$mapNioException).getReason();
                boolean bl = string != null ? StringsKt.equals((String)string, (String)"Not a directory", (boolean)true) : false;
                if (bl) {
                    Throwable $this$alsoAddSuppressed$iv = (Throwable)((Object)new NotDirectoryException(file));
                    Throwable t$iv = $this$mapNioException;
                    boolean $i$f$alsoAddSuppressed = false;
                    ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                    fileSystemException = (kotlin.io.FileSystemException)$this$alsoAddSuppressed$iv;
                } else {
                    File file4;
                    String string2 = ((FileSystemException)$this$mapNioException).getOtherFile();
                    if (string2 != null) {
                        String $this$toFile$iv = string2;
                        boolean $i$f$get = false;
                        file4 = new File($this$toFile$iv);
                    } else {
                        file4 = null;
                    }
                    Throwable $this$alsoAddSuppressed$iv = (Throwable)new kotlin.io.FileSystemException(file, file4, ((FileSystemException)$this$mapNioException).getReason());
                    Throwable t$iv = $this$mapNioException;
                    boolean $i$f$alsoAddSuppressed = false;
                    ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv, (Throwable)t$iv);
                    fileSystemException = (kotlin.io.FileSystemException)$this$alsoAddSuppressed$iv;
                }
                iOException = (IOException)fileSystemException;
            } else {
                iOException = (IOException)$this$mapNioException;
            }
            throwable = iOException;
        } else if (throwable2 instanceof kotlin.io.FileSystemException) {
            throwable = $this$mapNioException instanceof kotlin.io.NoSuchFileException ? (IOException)new FileNotFoundException($this$mapNioException.getMessage()) : (IOException)$this$mapNioException;
        } else if (throwable2 instanceof SecurityException) {
            void $this$alsoAddSuppressed$iv$iv;
            void $this$toAccessDeniedException$iv;
            SecurityException securityException = (SecurityException)$this$mapNioException;
            File file$iv = file;
            boolean $i$f$toAccessDeniedException = false;
            Throwable $i$f$alsoAddSuppressed = (Throwable)new kotlin.io.AccessDeniedException(file$iv, null, "SecurityException", 2, null);
            Throwable t$iv$iv = (Throwable)$this$toAccessDeniedException$iv;
            boolean $i$f$alsoAddSuppressed2 = false;
            ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv$iv, (Throwable)t$iv$iv);
            throwable = (Throwable)((kotlin.io.AccessDeniedException)$this$alsoAddSuppressed$iv$iv);
        } else {
            throwable = $this$mapNioException;
        }
        return throwable;
    }

    public /* synthetic */ FsJvmNio(FsInfo info, DefaultConstructorMarker $constructor_marker) {
        this(info);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio$Companion;", "", "()V", "get", "Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio;", "get$io_matthewnelson_kmp_file_file_jvm", "io.matthewnelson.kmp-file_file_jvm"})
    public static final class Companion {
        private Companion() {
        }

        public final /* synthetic */ FsJvmNio get$io_matthewnelson_kmp_file_file_jvm() throws VerifyError {
            boolean isPosix = FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
            return isPosix ? (FsJvmNio)new Posix() : (FsJvmNio)new NonPosix();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u000bJ.\u0010\f\u001a\u00020\u00042\n\u0010\r\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0013\u001a\u00020\u00142\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0010\u00a2\u0006\u0002\b\u0017J)\u0010\u0018\u001a\u00020\u00142\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u001aJ9\u0010\u001b\u001a\u00020\u001c*\u00060\u0006j\u0002`\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\t2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020 0\u001fj\b\u0012\u0004\u0012\u00020 `!H\u0082\b\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\""}, d2={"Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio$NonPosix;", "Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio;", "()V", "delete", "", "file", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "ignoreReadOnly", "", "mustExist", "delete$io_matthewnelson_kmp_file_file_jvm", "mkdir", "dir", "mode", "Lio/matthewnelson/kmp/file/internal/Mode;", "mustCreate", "mkdir-HnoeHPA$io_matthewnelson_kmp_file_file_jvm", "(Ljava/io/File;Ljava/lang/String;Z)V", "openReadWrite", "Lio/matthewnelson/kmp/file/AbstractFileStream;", "excl", "Lio/matthewnelson/kmp/file/OpenExcl;", "openReadWrite$io_matthewnelson_kmp_file_file_jvm", "openWrite", "appending", "openWrite$io_matthewnelson_kmp_file_file_jvm", "openNonPosix", "Lio/matthewnelson/kmp/file/internal/NioFileStream;", "isAppending", "options", "Ljava/util/LinkedHashSet;", "Ljava/nio/file/StandardOpenOption;", "Lkotlin/collections/LinkedHashSet;", "io.matthewnelson.kmp-file_file_jvm"})
    @SourceDebugExtension(value={"SMAP\n-FsJvmNio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio$NonPosix\n+ 2 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio\n+ 3 Exceptions.kt\nio/matthewnelson/kmp/file/Exceptions\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 -JvmException.kt\nio/matthewnelson/kmp/file/internal/_JvmExceptionKt\n*L\n1#1,374:1\n165#1,31:403\n165#1,31:434\n337#2,4:375\n341#2:385\n337#2,4:392\n341#2:402\n143#3,3:379\n146#3,2:383\n143#3,3:396\n146#3,2:400\n1#4:382\n1#4:399\n27#5,6:386\n*S KotlinDebug\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio$NonPosix\n*L\n142#1:403,31\n157#1:434,31\n68#1:375,4\n68#1:385\n107#1:392,4\n107#1:402\n68#1:379,3\n68#1:383,2\n107#1:396,3\n107#1:400,2\n68#1:382\n107#1:399\n98#1:386,6\n*E\n"})
    private static final class NonPosix
    extends FsJvmNio {
        public NonPosix() {
            super(FsInfo.Companion.of$io_matthewnelson_kmp_file_file_jvm("FsJvmNioNonPosix", false), null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void delete$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, boolean ignoreReadOnly, boolean mustExist) throws IOException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.checkThread();
            FsJvmNio fsJvmNio = this;
            File $this$toNioPath$iv = file;
            boolean $i$f$toNioPath = false;
            try {
                path = $this$toNioPath$iv.toPath();
                Intrinsics.checkNotNull((Object)path);
            }
            catch (InvalidPathException e$iv) {
                IOException iOException;
                Throwable $this$wrapIOException$iv$iv = e$iv;
                boolean $i$f$wrapIO = false;
                Throwable throwable = $this$wrapIOException$iv$iv;
                if (throwable instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv$iv;
                } else if (throwable instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv$iv);
                }
                throw iOException;
            }
            Path path2 = path;
            try {
                Files.delete(path2);
            }
            catch (Throwable t) {
                Throwable ee;
                Throwable e = this.mapNioException(t, file);
                if (e instanceof FileNotFoundException && !mustExist) {
                    return;
                }
                if (!(e instanceof kotlin.io.AccessDeniedException)) {
                    throw e;
                }
                String string = ((kotlin.io.AccessDeniedException)e).getReason();
                boolean bl = string != null ? StringsKt.startsWith$default((String)string, (String)"SecurityException", (boolean)false, (int)2, null) : false;
                if (bl) {
                    throw e;
                }
                try {
                    if (file.canWrite()) {
                        throw e;
                    }
                    if (!ignoreReadOnly) {
                        throw new kotlin.io.AccessDeniedException(file, null, "File is read-only && ignoreReadOnly = false", 2, null);
                    }
                    file.setWritable(true);
                    try {
                        Files.delete(path2);
                    }
                    catch (Throwable tt) {
                        ee = this.mapNioException(tt, file);
                        ExceptionsKt.addSuppressed((Throwable)ee, (Throwable)e);
                        throw ee;
                    }
                }
                catch (SecurityException tt) {
                    void $this$alsoAddSuppressed$iv$iv;
                    void $this$toAccessDeniedException$iv;
                    SecurityException e$iv = tt;
                    File file$iv = file;
                    boolean $i$f$toAccessDeniedException = false;
                    Throwable throwable = (Throwable)new kotlin.io.AccessDeniedException(file$iv, null, "SecurityException", 2, null);
                    Throwable t$iv$iv = (Throwable)$this$toAccessDeniedException$iv;
                    boolean $i$f$alsoAddSuppressed = false;
                    ExceptionsKt.addSuppressed((Throwable)$this$alsoAddSuppressed$iv$iv, (Throwable)t$iv$iv);
                    ee = (kotlin.io.AccessDeniedException)$this$alsoAddSuppressed$iv$iv;
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)ee);
                    throw e;
                }
            }
        }

        @Override
        public void mkdir-HnoeHPA$io_matthewnelson_kmp_file_file_jvm(@NotNull File dir, @NotNull String string, boolean mustCreate) throws IOException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$io-matthewnelson-kmp-file-internal-Mode$-mode$0");
            FsJvmNio fsJvmNio = this;
            File $this$toNioPath$iv = dir;
            boolean $i$f$toNioPath = false;
            try {
                path = $this$toNioPath$iv.toPath();
                Intrinsics.checkNotNull((Object)path);
            }
            catch (InvalidPathException e$iv) {
                IOException iOException;
                Throwable $this$wrapIOException$iv$iv = e$iv;
                boolean $i$f$wrapIO = false;
                Throwable throwable = $this$wrapIOException$iv$iv;
                if (throwable instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv$iv;
                } else if (throwable instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv$iv);
                }
                throw iOException;
            }
            Path path2 = path;
            try {
                Files.createDirectory(path2, new FileAttribute[0]);
            }
            catch (Throwable t) {
                Throwable e = this.mapNioException(t, dir);
                if (e instanceof kotlin.io.FileAlreadyExistsException && !mustCreate) {
                    return;
                }
                if (!(e instanceof FileNotFoundException)) {
                    throw e;
                }
                try {
                    File parent;
                    File file = parent = dir.getParentFile();
                    path = file != null ? Boolean.valueOf(file.exists() && !parent.isDirectory()) : null;
                }
                catch (SecurityException tt) {
                    ExceptionsKt.addSuppressed((Throwable)e, (Throwable)tt);
                    path = null;
                }
                Path parentExistsAndIsNotADir = path;
                if (Intrinsics.areEqual((Object)parentExistsAndIsNotADir, (Object)true)) {
                    throw new NotDirectoryException(dir);
                }
                throw e;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public AbstractFileStream openReadWrite$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, @NotNull OpenExcl excl) throws IOException {
            void isAppending$iv;
            void $this$openNonPosix$iv;
            void this_$iv;
            boolean bl;
            void excl$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
            Object object = new LinkedHashSet<StandardOpenOption>(2, 1.0f);
            Serializable $this$openReadWrite_u24lambda_u240 = object;
            boolean $i$a$-apply-FsJvmNio$NonPosix$openReadWrite$options$22 = false;
            $this$openReadWrite_u24lambda_u240.add(StandardOpenOption.READ);
            $this$openReadWrite_u24lambda_u240.add(StandardOpenOption.WRITE);
            LinkedHashSet<StandardOpenOption> options = object;
            object = this;
            $this$openReadWrite_u24lambda_u240 = file;
            OpenExcl $i$a$-apply-FsJvmNio$NonPosix$openReadWrite$options$22 = excl;
            boolean bl2 = false;
            LinkedHashSet<StandardOpenOption> options$iv = options;
            boolean $i$f$openNonPosix = false;
            Boolean bl3 = Mode.equals-impl0(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), Mode.Companion.getDEFAULT_FILE-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : (_JvmPlatformKt.getIsWindows() ? (_ModeKt.getContainsOwnerWriteAccess-TczEVHM(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : null) : null);
            if (bl3 != null) {
                bl = bl3;
            } else {
                void var10_11 = excl$iv;
                if (var10_11 instanceof OpenExcl.MaybeCreate) {
                    bl = !this_$iv.exists$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv);
                } else if (var10_11 instanceof OpenExcl.MustCreate) {
                    bl = true;
                } else if (var10_11 instanceof OpenExcl.MustExist) {
                    bl = false;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean doChmod$iv = bl;
            NioFileStream s$iv = this_$iv.openNio((File)$this$openNonPosix$iv, (OpenExcl)excl$iv, (boolean)isAppending$iv, (Set<StandardOpenOption>)options$iv, null);
            if (doChmod$iv) {
                try {
                    this_$iv.chmod-HnoeHPA$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv, excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), true);
                }
                catch (IOException e$iv) {
                    try {
                        s$iv.close();
                    }
                    catch (IOException ee$iv) {
                        ExceptionsKt.addSuppressed((Throwable)e$iv, (Throwable)ee$iv);
                    }
                    try {
                        this_$iv.delete$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv, true, true);
                    }
                    catch (IOException ee$iv) {
                        ExceptionsKt.addSuppressed((Throwable)e$iv, (Throwable)ee$iv);
                    }
                    throw e$iv;
                }
            }
            return s$iv;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public AbstractFileStream openWrite$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, @NotNull OpenExcl excl, boolean appending) throws IOException {
            void isAppending$iv;
            void $this$openNonPosix$iv;
            void this_$iv;
            boolean bl;
            void excl$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
            Object object = new LinkedHashSet<StandardOpenOption>(2, 1.0f);
            Serializable $this$openWrite_u24lambda_u240 = object;
            boolean $i$a$-apply-FsJvmNio$NonPosix$openWrite$options$22 = false;
            $this$openWrite_u24lambda_u240.add(StandardOpenOption.WRITE);
            if (!appending) {
                $this$openWrite_u24lambda_u240.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            LinkedHashSet<StandardOpenOption> options = object;
            object = this;
            $this$openWrite_u24lambda_u240 = file;
            OpenExcl $i$a$-apply-FsJvmNio$NonPosix$openWrite$options$22 = excl;
            boolean bl2 = appending;
            LinkedHashSet<StandardOpenOption> options$iv = options;
            boolean $i$f$openNonPosix = false;
            Boolean bl3 = Mode.equals-impl0(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), Mode.Companion.getDEFAULT_FILE-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : (_JvmPlatformKt.getIsWindows() ? (_ModeKt.getContainsOwnerWriteAccess-TczEVHM(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : null) : null);
            if (bl3 != null) {
                bl = bl3;
            } else {
                void var11_12 = excl$iv;
                if (var11_12 instanceof OpenExcl.MaybeCreate) {
                    bl = !this_$iv.exists$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv);
                } else if (var11_12 instanceof OpenExcl.MustCreate) {
                    bl = true;
                } else if (var11_12 instanceof OpenExcl.MustExist) {
                    bl = false;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean doChmod$iv = bl;
            NioFileStream s$iv = this_$iv.openNio((File)$this$openNonPosix$iv, (OpenExcl)excl$iv, (boolean)isAppending$iv, (Set<StandardOpenOption>)options$iv, null);
            if (doChmod$iv) {
                try {
                    this_$iv.chmod-HnoeHPA$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv, excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), true);
                }
                catch (IOException e$iv) {
                    try {
                        s$iv.close();
                    }
                    catch (IOException ee$iv) {
                        ExceptionsKt.addSuppressed((Throwable)e$iv, (Throwable)ee$iv);
                    }
                    try {
                        this_$iv.delete$io_matthewnelson_kmp_file_file_jvm((File)$this$openNonPosix$iv, true, true);
                    }
                    catch (IOException ee$iv) {
                        ExceptionsKt.addSuppressed((Throwable)e$iv, (Throwable)ee$iv);
                    }
                    throw e$iv;
                }
            }
            return s$iv;
        }

        private final NioFileStream openNonPosix(File $this$openNonPosix, OpenExcl excl, boolean isAppending, LinkedHashSet<StandardOpenOption> options) {
            boolean bl;
            boolean $i$f$openNonPosix = false;
            Boolean bl2 = Mode.equals-impl0(excl.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), Mode.Companion.getDEFAULT_FILE-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : (_JvmPlatformKt.getIsWindows() ? (_ModeKt.getContainsOwnerWriteAccess-TczEVHM(excl.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm()) ? Boolean.valueOf(false) : null) : null);
            if (bl2 != null) {
                bl = bl2;
            } else {
                OpenExcl openExcl = excl;
                if (openExcl instanceof OpenExcl.MaybeCreate) {
                    bl = !this.exists$io_matthewnelson_kmp_file_file_jvm($this$openNonPosix);
                } else if (openExcl instanceof OpenExcl.MustCreate) {
                    bl = true;
                } else if (openExcl instanceof OpenExcl.MustExist) {
                    bl = false;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
            }
            boolean doChmod = bl;
            NioFileStream s = this.openNio($this$openNonPosix, excl, isAppending, (Set<StandardOpenOption>)options, null);
            if (doChmod) {
                try {
                    this.chmod-HnoeHPA$io_matthewnelson_kmp_file_file_jvm($this$openNonPosix, excl.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm(), true);
                }
                catch (IOException e) {
                    try {
                        s.close();
                    }
                    catch (IOException ee) {
                        ExceptionsKt.addSuppressed((Throwable)e, (Throwable)ee);
                    }
                    try {
                        this.delete$io_matthewnelson_kmp_file_file_jvm($this$openNonPosix, true, true);
                    }
                    catch (IOException ee) {
                        ExceptionsKt.addSuppressed((Throwable)e, (Throwable)ee);
                    }
                    throw e;
                }
            }
            return s;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\f\u0010\rJ)\u0010\u000e\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\u0010J.\u0010\u0011\u001a\u00020\u00042\n\u0010\u0012\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0010\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\rJ!\u0010\u0015\u001a\u00020\u00162\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0010\u00a2\u0006\u0002\b\u0019J)\u0010\u001a\u001a\u00020\u00162\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bH\u0010\u00a2\u0006\u0002\b\u001cJ9\u0010\u001d\u001a\u00020\u001e*\u00060\u0006j\u0002`\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\"0!j\b\u0012\u0004\u0012\u00020\"`#H\u0082\bJ\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%*\u00020\tH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b'\u0010(\u0082\u0002\u0007\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006)"}, d2={"Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio$Posix;", "Lio/matthewnelson/kmp/file/internal/fs/FsJvmNio;", "()V", "chmod", "", "file", "Ljava/io/File;", "Lio/matthewnelson/kmp/file/File;", "mode", "Lio/matthewnelson/kmp/file/internal/Mode;", "mustExist", "", "chmod-HnoeHPA$io_matthewnelson_kmp_file_file_jvm", "(Ljava/io/File;Ljava/lang/String;Z)V", "delete", "ignoreReadOnly", "delete$io_matthewnelson_kmp_file_file_jvm", "mkdir", "dir", "mustCreate", "mkdir-HnoeHPA$io_matthewnelson_kmp_file_file_jvm", "openReadWrite", "Lio/matthewnelson/kmp/file/AbstractFileStream;", "excl", "Lio/matthewnelson/kmp/file/OpenExcl;", "openReadWrite$io_matthewnelson_kmp_file_file_jvm", "openWrite", "appending", "openWrite$io_matthewnelson_kmp_file_file_jvm", "openPosix", "Lio/matthewnelson/kmp/file/internal/NioFileStream;", "isAppending", "options", "Ljava/util/LinkedHashSet;", "Ljava/nio/file/StandardOpenOption;", "Lkotlin/collections/LinkedHashSet;", "toPosixFilePermissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "toPosixFilePermissions-TczEVHM", "(Ljava/lang/String;)Ljava/util/Set;", "io.matthewnelson.kmp-file_file_jvm"})
    @SourceDebugExtension(value={"SMAP\n-FsJvmNio.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio$Posix\n+ 2 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio\n+ 3 Exceptions.kt\nio/matthewnelson/kmp/file/Exceptions\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,374:1\n271#1,3:408\n271#1,3:411\n337#2,4:375\n341#2:385\n337#2,4:386\n341#2:396\n337#2,4:397\n341#2:407\n143#3,3:379\n146#3,2:383\n143#3,3:390\n146#3,2:394\n143#3,3:401\n146#3,2:405\n1#4:382\n1#4:393\n1#4:404\n1179#5,2:414\n*S KotlinDebug\n*F\n+ 1 -FsJvmNio.kt\nio/matthewnelson/kmp/file/internal/fs/FsJvmNio$Posix\n*L\n249#1:408,3\n263#1:411,3\n203#1:375,4\n203#1:385\n218#1:386,4\n218#1:396\n230#1:397,4\n230#1:407\n203#1:379,3\n203#1:383,2\n218#1:390,3\n218#1:394,2\n230#1:401,3\n230#1:405,2\n203#1:382\n218#1:393\n230#1:404\n278#1:414,2\n*E\n"})
    private static final class Posix
    extends FsJvmNio {
        public Posix() {
            super(FsInfo.Companion.of$io_matthewnelson_kmp_file_file_jvm("FsJvmNioPosix", true), null);
        }

        @Override
        public void chmod-HnoeHPA$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, @NotNull String string, boolean mustExist) throws IOException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$io-matthewnelson-kmp-file-internal-Mode$-mode$0");
            FsJvmNio fsJvmNio = this;
            File $this$toNioPath$iv = file;
            boolean $i$f$toNioPath = false;
            try {
                path = $this$toNioPath$iv.toPath();
                Intrinsics.checkNotNull((Object)path);
            }
            catch (InvalidPathException e$iv) {
                IOException iOException;
                Throwable $this$wrapIOException$iv$iv = e$iv;
                boolean $i$f$wrapIO = false;
                Throwable throwable = $this$wrapIOException$iv$iv;
                if (throwable instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv$iv;
                } else if (throwable instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv$iv);
                }
                throw iOException;
            }
            Path path2 = path;
            Set<PosixFilePermission> perms = this.toPosixFilePermissions-TczEVHM(string);
            try {
                Files.setPosixFilePermissions(path2, perms);
            }
            catch (Throwable t) {
                Throwable e = this.mapNioException(t, file);
                if (e instanceof FileNotFoundException && !mustExist) {
                    return;
                }
                throw e;
            }
        }

        @Override
        public void delete$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, boolean ignoreReadOnly, boolean mustExist) throws IOException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.checkThread();
            FsJvmNio fsJvmNio = this;
            File $this$toNioPath$iv = file;
            boolean $i$f$toNioPath = false;
            try {
                path = $this$toNioPath$iv.toPath();
                Intrinsics.checkNotNull((Object)path);
            }
            catch (InvalidPathException e$iv) {
                IOException iOException;
                Throwable $this$wrapIOException$iv$iv = e$iv;
                boolean $i$f$wrapIO = false;
                Throwable throwable = $this$wrapIOException$iv$iv;
                if (throwable instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv$iv;
                } else if (throwable instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv$iv);
                }
                throw iOException;
            }
            Path path2 = path;
            try {
                Files.delete(path2);
            }
            catch (Throwable t) {
                Throwable e = this.mapNioException(t, file);
                if (e instanceof FileNotFoundException && !mustExist) {
                    return;
                }
                throw e;
            }
        }

        @Override
        public void mkdir-HnoeHPA$io_matthewnelson_kmp_file_file_jvm(@NotNull File dir, @NotNull String string, boolean mustCreate) throws IOException {
            Path path;
            Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)string, (String)"$v$c$io-matthewnelson-kmp-file-internal-Mode$-mode$0");
            FsJvmNio fsJvmNio = this;
            File $this$toNioPath$iv = dir;
            boolean $i$f$toNioPath2 = false;
            try {
                path = $this$toNioPath$iv.toPath();
                Intrinsics.checkNotNull((Object)path);
            }
            catch (InvalidPathException e$iv) {
                IOException iOException;
                Throwable $this$wrapIOException$iv$iv = e$iv;
                boolean $i$f$wrapIO = false;
                Throwable throwable = $this$wrapIOException$iv$iv;
                if (throwable instanceof IOException) {
                    iOException = (IOException)$this$wrapIOException$iv$iv;
                } else if (throwable instanceof InterruptedException) {
                    InterruptedIOException interruptedIOException;
                    InterruptedIOException it$iv$iv = interruptedIOException = new InterruptedIOException();
                    boolean bl = false;
                    ExceptionsKt.addSuppressed((Throwable)it$iv$iv, (Throwable)$this$wrapIOException$iv$iv);
                    iOException = interruptedIOException;
                } else {
                    iOException = new IOException($this$wrapIOException$iv$iv);
                }
                throw iOException;
            }
            Path path2 = path;
            Set<PosixFilePermission> perms = this.toPosixFilePermissions-TczEVHM(string);
            FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(perms);
            try {
                FileAttribute[] $i$f$toNioPath2 = new FileAttribute[]{attrs};
                Files.createDirectory(path2, $i$f$toNioPath2);
            }
            catch (Throwable t) {
                Throwable e = this.mapNioException(t, dir);
                if (e instanceof kotlin.io.FileAlreadyExistsException && !mustCreate) {
                    return;
                }
                throw e;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public AbstractFileStream openReadWrite$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, @NotNull OpenExcl excl) throws IOException {
            void isAppending$iv;
            void $this$openPosix$iv;
            void excl$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
            Object object = new LinkedHashSet<StandardOpenOption>(2, 1.0f);
            Serializable $this$openReadWrite_u24lambda_u240 = object;
            boolean $i$a$-apply-FsJvmNio$Posix$openReadWrite$options$22 = false;
            $this$openReadWrite_u24lambda_u240.add(StandardOpenOption.READ);
            $this$openReadWrite_u24lambda_u240.add(StandardOpenOption.WRITE);
            LinkedHashSet<StandardOpenOption> options = object;
            object = this;
            $this$openReadWrite_u24lambda_u240 = file;
            OpenExcl $i$a$-apply-FsJvmNio$Posix$openReadWrite$options$22 = excl;
            boolean bl = false;
            LinkedHashSet<StandardOpenOption> options$iv = options;
            boolean $i$f$openPosix = false;
            Set<PosixFilePermission> perms$iv = super.toPosixFilePermissions-TczEVHM(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm());
            FileAttribute<Set<PosixFilePermission>> attrs$iv = PosixFilePermissions.asFileAttribute(perms$iv);
            return this_$iv.openNio((File)$this$openPosix$iv, (OpenExcl)excl$iv, (boolean)isAppending$iv, (Set<StandardOpenOption>)options$iv, attrs$iv);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public AbstractFileStream openWrite$io_matthewnelson_kmp_file_file_jvm(@NotNull File file, @NotNull OpenExcl excl, boolean appending) throws IOException {
            void isAppending$iv;
            void $this$openPosix$iv;
            void excl$iv;
            void this_$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)excl, (String)"excl");
            Object object = new LinkedHashSet<StandardOpenOption>(2, 1.0f);
            Serializable $this$openWrite_u24lambda_u240 = object;
            boolean $i$a$-apply-FsJvmNio$Posix$openWrite$options$22 = false;
            $this$openWrite_u24lambda_u240.add(StandardOpenOption.WRITE);
            if (!appending) {
                $this$openWrite_u24lambda_u240.add(StandardOpenOption.TRUNCATE_EXISTING);
            }
            LinkedHashSet<StandardOpenOption> options = object;
            object = this;
            $this$openWrite_u24lambda_u240 = file;
            OpenExcl $i$a$-apply-FsJvmNio$Posix$openWrite$options$22 = excl;
            boolean bl = appending;
            LinkedHashSet<StandardOpenOption> options$iv = options;
            boolean $i$f$openPosix = false;
            Set<PosixFilePermission> perms$iv = super.toPosixFilePermissions-TczEVHM(excl$iv.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm());
            FileAttribute<Set<PosixFilePermission>> attrs$iv = PosixFilePermissions.asFileAttribute(perms$iv);
            return this_$iv.openNio((File)$this$openPosix$iv, (OpenExcl)excl$iv, (boolean)isAppending$iv, (Set<StandardOpenOption>)options$iv, attrs$iv);
        }

        private final NioFileStream openPosix(File $this$openPosix, OpenExcl excl, boolean isAppending, LinkedHashSet<StandardOpenOption> options) {
            boolean $i$f$openPosix = false;
            Set<PosixFilePermission> perms = this.toPosixFilePermissions-TczEVHM(excl.get_mode-ANzw5ME$io_matthewnelson_kmp_file_file_jvm());
            FileAttribute<Set<PosixFilePermission>> attrs = PosixFilePermissions.asFileAttribute(perms);
            return this.openNio($this$openPosix, excl, isAppending, (Set<StandardOpenOption>)options, attrs);
        }

        private final Set<PosixFilePermission> toPosixFilePermissions-TczEVHM(String string) {
            String perms = null;
            perms = "";
            CharSequence $this$forEach$iv = string;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                String string2;
                char element$iv;
                char c = element$iv = $this$forEach$iv.charAt(i);
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder().append(perms);
                switch (c) {
                    case '7': {
                        string2 = "rwx";
                        break;
                    }
                    case '6': {
                        string2 = "rw-";
                        break;
                    }
                    case '5': {
                        string2 = "r-x";
                        break;
                    }
                    case '4': {
                        string2 = "r--";
                        break;
                    }
                    case '3': {
                        string2 = "-wx";
                        break;
                    }
                    case '2': {
                        string2 = "-w-";
                        break;
                    }
                    case '1': {
                        string2 = "--x";
                        break;
                    }
                    case '0': {
                        string2 = "---";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown mode digit[" + c + "]. Acceptable digits >> 0-7");
                    }
                }
                perms = stringBuilder.append(string2).toString();
            }
            Set<PosixFilePermission> set = PosixFilePermissions.fromString(perms);
            Intrinsics.checkNotNullExpressionValue(set, (String)"fromString(...)");
            return set;
        }
    }
}

