/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u0012\u0010\u0013\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J:\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lutil/LightOrDarkColor;", "Ljava/awt/Color;", "lightColor", "darkColor", "<init>", "(Ljava/awt/Color;Ljava/awt/Color;)V", "isDark", "", "getRed", "", "getGreen", "getBlue", "getAlpha", "getRGB", "getRGBComponents", "", "compArray", "getRGBColorComponents", "getComponents", "getColorComponents", "cspace", "Ljava/awt/color/ColorSpace;", "getColorSpace", "createContext", "Ljava/awt/PaintContext;", "cm", "Ljava/awt/image/ColorModel;", "r", "Ljava/awt/Rectangle;", "r2d", "Ljava/awt/geom/Rectangle2D;", "xform", "Ljava/awt/geom/AffineTransform;", "hints", "Ljava/awt/RenderingHints;", "getTransparency", "browser"})
public final class LightOrDarkColor
extends Color {
    @NotNull
    private final Color darkColor;

    public LightOrDarkColor(@NotNull Color lightColor, @NotNull Color darkColor) {
        Intrinsics.checkNotNullParameter((Object)lightColor, (String)"lightColor");
        Intrinsics.checkNotNullParameter((Object)darkColor, (String)"darkColor");
        super(lightColor.getRGB());
        this.darkColor = darkColor;
    }

    private final boolean isDark() {
        String id = UIManager.getLookAndFeel().getID();
        Intrinsics.checkNotNull((Object)id);
        return StringsKt.contains((CharSequence)id, (CharSequence)"dark", (boolean)true) || StringsKt.contains((CharSequence)id, (CharSequence)"darcula", (boolean)true);
    }

    @Override
    public int getRed() {
        return this.isDark() ? this.darkColor.getRed() : super.getRed();
    }

    @Override
    public int getGreen() {
        return this.isDark() ? this.darkColor.getGreen() : super.getGreen();
    }

    @Override
    public int getBlue() {
        return this.isDark() ? this.darkColor.getBlue() : super.getBlue();
    }

    @Override
    public int getAlpha() {
        return this.isDark() ? this.darkColor.getAlpha() : super.getAlpha();
    }

    @Override
    public int getRGB() {
        return this.isDark() ? this.darkColor.getRGB() : super.getRGB();
    }

    @Override
    @NotNull
    public float[] getRGBComponents(@Nullable float[] compArray) {
        float[] fArray;
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getRGBComponents(compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getRGBComponents(...)");
        } else {
            float[] fArray3 = super.getRGBComponents(compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getRGBComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getRGBColorComponents(@Nullable float[] compArray) {
        float[] fArray;
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getRGBColorComponents(compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getRGBColorComponents(...)");
        } else {
            float[] fArray3 = super.getRGBColorComponents(compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getRGBColorComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getComponents(@Nullable float[] compArray) {
        float[] fArray;
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getComponents(compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getComponents(...)");
        } else {
            float[] fArray3 = super.getComponents(compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getColorComponents(@Nullable float[] compArray) {
        float[] fArray;
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getColorComponents(compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getColorComponents(...)");
        } else {
            float[] fArray3 = super.getColorComponents(compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getColorComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getComponents(@NotNull ColorSpace cspace, @Nullable float[] compArray) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)cspace, (String)"cspace");
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getComponents(cspace, compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getComponents(...)");
        } else {
            float[] fArray3 = super.getComponents(cspace, compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public float[] getColorComponents(@NotNull ColorSpace cspace, @Nullable float[] compArray) {
        float[] fArray;
        Intrinsics.checkNotNullParameter((Object)cspace, (String)"cspace");
        if (this.isDark()) {
            float[] fArray2 = this.darkColor.getColorComponents(cspace, compArray);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"getColorComponents(...)");
        } else {
            float[] fArray3 = super.getColorComponents(cspace, compArray);
            fArray = fArray3;
            Intrinsics.checkNotNullExpressionValue((Object)fArray3, (String)"getColorComponents(...)");
        }
        return fArray;
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        ColorSpace colorSpace;
        if (this.isDark()) {
            ColorSpace colorSpace2 = this.darkColor.getColorSpace();
            colorSpace = colorSpace2;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace2, (String)"getColorSpace(...)");
        } else {
            ColorSpace colorSpace3 = super.getColorSpace();
            colorSpace = colorSpace3;
            Intrinsics.checkNotNullExpressionValue((Object)colorSpace3, (String)"getColorSpace(...)");
        }
        return colorSpace;
    }

    @Override
    @NotNull
    public synchronized PaintContext createContext(@Nullable ColorModel cm, @Nullable Rectangle r, @Nullable Rectangle2D r2d, @Nullable AffineTransform xform, @Nullable RenderingHints hints) {
        PaintContext paintContext;
        if (this.isDark()) {
            PaintContext paintContext2 = this.darkColor.createContext(cm, r, r2d, xform, hints);
            paintContext = paintContext2;
            Intrinsics.checkNotNullExpressionValue((Object)paintContext2, (String)"createContext(...)");
        } else {
            PaintContext paintContext3 = super.createContext(cm, r, r2d, xform, hints);
            paintContext = paintContext3;
            Intrinsics.checkNotNullExpressionValue((Object)paintContext3, (String)"createContext(...)");
        }
        return paintContext;
    }

    @Override
    public int getTransparency() {
        return this.isDark() ? this.darkColor.getTransparency() : super.getTransparency();
    }
}

