/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gjt.jclasslib.browser.BrowserBundle;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.BrowserTreeNode;
import org.gjt.jclasslib.browser.DetailPane;
import org.gjt.jclasslib.browser.NodeType;
import org.gjt.jclasslib.browser.detail.KeyValueDetailPane;
import org.gjt.jclasslib.browser.detail.TableDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.AttributeDetailPane;
import org.gjt.jclasslib.browser.detail.attributes.CodeAttributeDetailPane;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.Structure;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableEntry;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableAttribute;
import org.gjt.jclasslib.structures.attributes.TypeAnnotation;
import org.gjt.jclasslib.structures.attributes.TypePathEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J<\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00130\u0011\"\b\b\u0000\u0010\u0013*\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u001d\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J \u0010$\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00122\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0016H\u0002J\"\u0010%\u001a\u00020\u00122\u000e\u0010&\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012H\u0002R\u0014\u0010 \u001a\u00020!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006("}, d2={"Lorg/gjt/jclasslib/browser/detail/TypeAnnotationDetailPane;", "Lorg/gjt/jclasslib/browser/detail/KeyValueDetailPane;", "Lorg/gjt/jclasslib/structures/attributes/TypeAnnotation;", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Lorg/gjt/jclasslib/browser/BrowserServices;)V", "addLabels", "", "handleLink", "description", "", "handleExceptionsLink", "index", "", "handleLocalVarLink", "findAttributeViaParent", "Lkotlin/Pair;", "Ljavax/swing/tree/TreePath;", "T", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "parentClass", "Ljava/lang/Class;", "Lorg/gjt/jclasslib/structures/Structure;", "attributeClass", "getLinkIndex", "attribute", "Lorg/gjt/jclasslib/structures/attributes/LocalVariableTableAttribute;", "handleInterfaceLink", "handleListLink", "path", "selectPath", "tree", "Ljavax/swing/JTree;", "getTree", "()Ljavax/swing/JTree;", "findAttributeChildNode", "findParentNode", "elementClass", "", "browser"})
@SourceDebugExtension(value={"SMAP\nTypeAnnotationDetailPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeAnnotationDetailPane.kt\norg/gjt/jclasslib/browser/detail/TypeAnnotationDetailPane\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n13870#2,3:134\n1#3:137\n*S KotlinDebug\n*F\n+ 1 TypeAnnotationDetailPane.kt\norg/gjt/jclasslib/browser/detail/TypeAnnotationDetailPane\n*L\n77#1:134,3\n*E\n"})
public final class TypeAnnotationDetailPane
extends KeyValueDetailPane<TypeAnnotation> {
    public TypeAnnotationDetailPane(@NotNull BrowserServices services) {
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        super(TypeAnnotation.class, services);
    }

    @Override
    protected void addLabels() {
        this.addDetail(BrowserBundle.INSTANCE.getString("key.target.type", new Object[0]), TypeAnnotationDetailPane::addLabels$lambda$0);
        this.addMultiLineHtmlDetail(BrowserBundle.INSTANCE.getString("key.target.info", new Object[0]), TypeAnnotationDetailPane::addLabels$lambda$1).linkHandler((Function1<String, Unit>)((Function1)arg_0 -> TypeAnnotationDetailPane.addLabels$lambda$2(this, arg_0)));
        this.addMultiLineHtmlDetail(BrowserBundle.INSTANCE.getString("key.type.path", new Object[0]), TypeAnnotationDetailPane::addLabels$lambda$3).visibilityPredicate(TypeAnnotationDetailPane::addLabels$lambda$4);
    }

    private final void handleLink(String description) {
        char type = description.charAt(0);
        String string = description.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        int index = Integer.parseInt(string);
        switch (type) {
            case 'E': {
                this.handleExceptionsLink(index);
                break;
            }
            case 'L': {
                this.handleLocalVarLink(index);
                break;
            }
            case 'I': {
                this.handleInterfaceLink(index);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid link type " + type);
            }
        }
    }

    private final void handleExceptionsLink(int index) {
        TreePath path = this.findParentNode(CodeAttribute.class, this.getTree().getSelectionPath());
        this.selectPath(path);
        DetailPane<?> detailPane = this.getServices().getBrowserComponent().getDetailPane().getCurrentDetailPane();
        Intrinsics.checkNotNull(detailPane, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.attributes.AttributeDetailPane");
        AttributeDetailPane detailPane2 = (AttributeDetailPane)detailPane;
        DetailPane<?> detailPane3 = detailPane2.getDetailPane(CodeAttribute.class);
        Intrinsics.checkNotNull(detailPane3, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.attributes.CodeAttributeDetailPane");
        CodeAttributeDetailPane codeAttributeDetailPane = (CodeAttributeDetailPane)detailPane3;
        codeAttributeDetailPane.selectExceptionTableDetailPane();
        codeAttributeDetailPane.getExceptionTableDetailPane().selectIndex(index);
    }

    private final void handleLocalVarLink(int index) {
        Pair<TreePath, LocalVariableTableAttribute> pair = this.findAttributeViaParent(CodeAttribute.class, LocalVariableTableAttribute.class);
        TreePath path = (TreePath)pair.component1();
        LocalVariableTableAttribute attribute = (LocalVariableTableAttribute)pair.component2();
        this.handleListLink(this.getLinkIndex(index, attribute), path, (AttributeInfo)attribute);
    }

    private final <T extends AttributeInfo> Pair<TreePath, T> findAttributeViaParent(Class<? extends Structure> parentClass, Class<T> attributeClass) {
        TreePath path = this.findAttributeChildNode(this.findParentNode(parentClass, this.getTree().getSelectionPath()), attributeClass);
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        return new Pair((Object)path, attributeClass.cast(((BrowserTreeNode)object).getElement()));
    }

    /*
     * WARNING - void declaration
     */
    private final int getLinkIndex(int index, LocalVariableTableAttribute attribute) {
        LocalVariableEntry[] localVariableTable;
        LocalVariableEntry[] $this$forEachIndexed$iv = localVariableTable = attribute.getLocalVariableEntries();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (LocalVariableEntry item$iv : $this$forEachIndexed$iv) {
            void localVariableEntry;
            int n = index$iv++;
            LocalVariableEntry localVariableEntry2 = item$iv;
            int i = n;
            boolean bl = false;
            if (localVariableEntry.getIndex() != index) continue;
            return i;
        }
        throw new IllegalArgumentException("index " + index + " not found in local variable table");
    }

    private final void handleInterfaceLink(int index) {
        TreePath interfacesPath = this.getServices().getBrowserComponent().getTreePane().getPathForCategory(NodeType.INTERFACE);
        Object object = interfacesPath.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        BrowserTreeNode interfacesNode = (BrowserTreeNode)object;
        if (!(index < interfacesNode.getChildCount())) {
            boolean bl = false;
            String string = "Invalid interface index " + index;
            throw new IllegalArgumentException(string.toString());
        }
        TreePath path = interfacesPath.pathByAddingChild(interfacesNode.getChildAt(index));
        Intrinsics.checkNotNull((Object)path);
        this.selectPath(path);
    }

    private final void handleListLink(int index, TreePath path, AttributeInfo attribute) {
        this.selectPath(path);
        DetailPane<?> detailPane = this.getServices().getBrowserComponent().getDetailPane().getCurrentDetailPane();
        Intrinsics.checkNotNull(detailPane, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.attributes.AttributeDetailPane");
        AttributeDetailPane detailPane2 = (AttributeDetailPane)detailPane;
        DetailPane<?> detailPane3 = detailPane2.getDetailPane(attribute.getClass());
        Intrinsics.checkNotNull(detailPane3, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.TableDetailPane<*>");
        ((TableDetailPane)detailPane3).selectIndex(index);
    }

    private final void selectPath(TreePath path) {
        JTree jTree;
        JTree $this$selectPath_u24lambda_u240 = jTree = this.getTree();
        boolean bl = false;
        $this$selectPath_u24lambda_u240.setSelectionPath(path);
        $this$selectPath_u24lambda_u240.scrollPathToVisible(path);
    }

    private final JTree getTree() {
        return this.getServices().getBrowserComponent().getTreePane().getTree();
    }

    private final TreePath findAttributeChildNode(TreePath path, Class<? extends AttributeInfo> attributeClass) {
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        BrowserTreeNode node = (BrowserTreeNode)object;
        Enumeration<TreeNode> enumeration = node.children();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"children(...)");
        Iterator iterator = CollectionsKt.iterator(enumeration);
        while (iterator.hasNext()) {
            Class<?> clazz;
            TreeNode child = (TreeNode)iterator.next();
            Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
            BrowserTreeNode attributeNode = (BrowserTreeNode)child;
            if (attributeNode.getElement() != null) {
                Object it;
                boolean bl = false;
                clazz = it.getClass();
            } else {
                clazz = null;
            }
            if (!Intrinsics.areEqual(clazz, attributeClass)) continue;
            TreePath treePath = path.pathByAddingChild(attributeNode);
            Intrinsics.checkNotNullExpressionValue((Object)treePath, (String)"pathByAddingChild(...)");
            return treePath;
        }
        throw new RuntimeException("No attribute node for class " + attributeClass + " found");
    }

    private final TreePath findParentNode(Class<? extends Object> elementClass, TreePath path) {
        Class<?> clazz;
        if (path == null) {
            throw new RuntimeException("No parent node with element class " + elementClass + " found");
        }
        Object object = path.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.BrowserTreeNode");
        BrowserTreeNode node = (BrowserTreeNode)object;
        Object object2 = node.getElement();
        if (object2 != null) {
            Object it = object2;
            boolean bl = false;
            clazz = it.getClass();
        } else {
            clazz = null;
        }
        return Intrinsics.areEqual(clazz, elementClass) ? path : this.findParentNode(elementClass, path.getParentPath());
    }

    private static final String addLabels$lambda$0(TypeAnnotation typeAnnotation) {
        Intrinsics.checkNotNullParameter((Object)typeAnnotation, (String)"typeAnnotation");
        return typeAnnotation.getTargetType().toString();
    }

    private static final String addLabels$lambda$1(TypeAnnotation typeAnnotation) {
        Intrinsics.checkNotNullParameter((Object)typeAnnotation, (String)"typeAnnotation");
        return StringsKt.replace$default((String)typeAnnotation.getTargetInfo().getVerbose(), (String)"\n", (String)"<br>", (boolean)false, (int)4, null);
    }

    private static final Unit addLabels$lambda$2(TypeAnnotationDetailPane this$0, String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this$0.handleLink(description);
        return Unit.INSTANCE;
    }

    private static final String addLabels$lambda$3(TypeAnnotation typeAnnotation) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)typeAnnotation, (String)"typeAnnotation");
        StringBuilder $this$addLabels_u24lambda_u243_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (TypePathEntry typePathEntry : typeAnnotation.getTypePathEntries()) {
            $this$addLabels_u24lambda_u243_u240.append(typePathEntry.getTypePathKind());
            $this$addLabels_u24lambda_u243_u240.append(", argument index ").append(typePathEntry.getTypeArgumentIndex());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final boolean addLabels$lambda$4(TypeAnnotation typeAnnotation) {
        Intrinsics.checkNotNullParameter((Object)typeAnnotation, (String)"typeAnnotation");
        return !(typeAnnotation.getTypePathEntries().length == 0);
    }
}

