/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.detail;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gjt.jclasslib.browser.BrowserServices;
import org.gjt.jclasslib.browser.detail.DetailPaneWithKeyValues;
import org.gjt.jclasslib.browser.detail.attributes.Column;
import org.gjt.jclasslib.browser.detail.attributes.ColumnTableModel;
import org.gjt.jclasslib.browser.detail.attributes.Link;
import org.gjt.jclasslib.browser.detail.attributes.LinkRenderer;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.util.GUIHelper;
import org.gjt.jclasslib.util.LinkMouseListener;
import org.gjt.jclasslib.util.UiDefaultsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\b&\u0018\u0000 2*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0003012B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0010\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bJ\u0019\u0010 \u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0015\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0016J\b\u0010'\u001a\u00020\u001bH\u0014J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010)\u001a\u00020\u001bH\u0002J\u000e\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001dR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00028\u0000\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&R\u0014\u0010*\u001a\u00020+8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00063"}, d2={"Lorg/gjt/jclasslib/browser/detail/TableDetailPane;", "T", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "Lorg/gjt/jclasslib/browser/detail/DetailPaneWithKeyValues;", "elementClass", "Ljava/lang/Class;", "services", "Lorg/gjt/jclasslib/browser/BrowserServices;", "<init>", "(Ljava/lang/Class;Lorg/gjt/jclasslib/browser/BrowserServices;)V", "table", "Ljavax/swing/JTable;", "getTable", "()Ljavax/swing/JTable;", "tableModel", "Lorg/gjt/jclasslib/browser/detail/attributes/ColumnTableModel;", "getTableModel", "()Lorg/gjt/jclasslib/browser/detail/attributes/ColumnTableModel;", "attributeToTableModel", "Ljava/util/WeakHashMap;", "createTableModel", "attribute", "(Lorg/gjt/jclasslib/structures/AttributeInfo;)Lorg/gjt/jclasslib/browser/detail/attributes/ColumnTableModel;", "Ljavax/swing/table/TableModel;", "treePath", "Ljavax/swing/tree/TreePath;", "link", "", "row", "", "column", "createTableColumnModel", "getCachedTableModel", "autoResizeMode", "getAutoResizeMode", "()I", "isVariableRowHeight", "", "()Z", "setupComponent", "show", "updateRowHeights", "rowHeightFactor", "", "getRowHeightFactor", "()F", "selectIndex", "index", "NoFocusTableCellRenderer", "TableLinkListener", "Companion", "browser"})
@SourceDebugExtension(value={"SMAP\nTableDetailPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableDetailPane.kt\norg/gjt/jclasslib/browser/detail/TableDetailPane\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,202:1\n32#2:203\n33#2:205\n1#3:204\n382#4,7:206\n*S KotlinDebug\n*F\n+ 1 TableDetailPane.kt\norg/gjt/jclasslib/browser/detail/TableDetailPane\n*L\n95#1:203\n95#1:205\n110#1:206,7\n*E\n"})
public abstract class TableDetailPane<T extends AttributeInfo>
extends DetailPaneWithKeyValues<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JTable table;
    @NotNull
    private final WeakHashMap<T, ColumnTableModel<?>> attributeToTableModel;
    @NotNull
    private static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

    /*
     * WARNING - void declaration
     */
    public TableDetailPane(@NotNull Class<T> elementClass, @NotNull BrowserServices services) {
        void $this$table_u24lambda_u240;
        JTable jTable;
        Intrinsics.checkNotNullParameter(elementClass, (String)"elementClass");
        Intrinsics.checkNotNullParameter((Object)services, (String)"services");
        super(elementClass, services);
        JTable jTable2 = jTable = new JTable();
        TableDetailPane tableDetailPane = this;
        boolean bl = false;
        $this$table_u24lambda_u240.setAutoResizeMode(0);
        $this$table_u24lambda_u240.getSelectionModel().setSelectionMode(0);
        UiDefaultsKt.applyTableRowHeight((JTable)$this$table_u24lambda_u240, this.getRowHeightFactor());
        new TableLinkListener((JComponent)$this$table_u24lambda_u240);
        $this$table_u24lambda_u240.setGridColor(UIManager.getColor("control"));
        $this$table_u24lambda_u240.setAutoResizeMode(this.getAutoResizeMode());
        $this$table_u24lambda_u240.addMouseMotionListener(new MouseMotionAdapter((JTable)$this$table_u24lambda_u240){
            final /* synthetic */ JTable $this_apply;
            {
                this.$this_apply = $receiver;
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int col = this.$this_apply.columnAtPoint(e.getPoint());
                int row = this.$this_apply.rowAtPoint(e.getPoint());
                if (col >= 0 && row >= 0 && this.$this_apply.getModel().isCellEditable(row, col)) {
                    this.$this_apply.editCellAt(row, col);
                }
            }
        });
        if (this.isVariableRowHeight()) {
            $this$table_u24lambda_u240.getColumnModel().addColumnModelListener(new TableColumnModelListener(this){
                final /* synthetic */ TableDetailPane<T> this$0;
                {
                    this.this$0 = $receiver;
                }

                public void columnAdded(TableColumnModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                public void columnRemoved(TableColumnModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                public void columnMoved(TableColumnModelEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                public void columnMarginChanged(ChangeEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TableDetailPane.access$updateRowHeights(this.this$0);
                }

                public void columnSelectionChanged(ListSelectionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
        }
        tableDetailPane.table = jTable;
        this.attributeToTableModel = new WeakHashMap();
    }

    @NotNull
    protected final JTable getTable() {
        return this.table;
    }

    private final ColumnTableModel<?> getTableModel() {
        TableModel tableModel = this.table.getModel();
        Intrinsics.checkNotNull((Object)tableModel, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.attributes.ColumnTableModel<*>");
        return (ColumnTableModel)tableModel;
    }

    @NotNull
    protected abstract ColumnTableModel<?> createTableModel(@NotNull T var1);

    @NotNull
    public final TableModel getTableModel(@NotNull TreePath treePath) {
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        return this.getCachedTableModel((AttributeInfo)this.getElement(treePath));
    }

    public final void link(int row, int column) {
        this.getTableModel().link(row, column);
    }

    public final void createTableColumnModel(@NotNull JTable table2) {
        JTable jTable;
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        JTable $this$createTableColumnModel_u24lambda_u240 = jTable = table2;
        boolean bl = false;
        $this$createTableColumnModel_u24lambda_u240.createDefaultColumnsFromModel();
        Enumeration<TableColumn> enumeration = $this$createTableColumnModel_u24lambda_u240.getColumnModel().getColumns();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getColumns(...)");
        Iterator $this$forEach$iv = CollectionsKt.withIndex((Iterator)CollectionsKt.iterator(enumeration));
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            int it;
            Column<?> column;
            Object element$iv = iterator.next();
            IndexedValue it2 = (IndexedValue)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(this.getTableModel().getColumns().get(it2.getIndex()), (String)"get(...)");
            Object object = it2.getValue();
            TableColumn $this$createTableColumnModel_u24lambda_u240_u240_u240 = (TableColumn)object;
            boolean bl3 = false;
            $this$createTableColumnModel_u24lambda_u240_u240_u240.setMinWidth(GUIHelper.INSTANCE.scale(column.getMinWidth()));
            int n = column.getMaxWidth();
            TableColumn tableColumn = $this$createTableColumnModel_u24lambda_u240_u240_u240;
            boolean bl4 = false;
            tableColumn.setMaxWidth(((Number)(it == Integer.MAX_VALUE ? it : GUIHelper.INSTANCE.scale(it))).intValue());
            $this$createTableColumnModel_u24lambda_u240_u240_u240.setWidth(GUIHelper.INSTANCE.scale(column.getWidth()));
            $this$createTableColumnModel_u24lambda_u240_u240_u240.setPreferredWidth(GUIHelper.INSTANCE.scale(column.getWidth()));
            $this$createTableColumnModel_u24lambda_u240_u240_u240.setCellRenderer(column.createTableCellRenderer());
            $this$createTableColumnModel_u24lambda_u240_u240_u240.setCellEditor(column.createTableCellEditor());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ColumnTableModel<?> getCachedTableModel(T attribute) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.attributeToTableModel;
        T key$iv = attribute;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            ColumnTableModel<?> answer$iv = this.createTableModel(attribute);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (ColumnTableModel)object;
    }

    protected int getAutoResizeMode() {
        return 0;
    }

    protected boolean isVariableRowHeight() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void setupComponent() {
        void $this$setupComponent_u24lambda_u240;
        super.setupComponent();
        Object object = UiDefaultsKt.getScrollPaneFactory().invoke((Object)this.table);
        JScrollPane jScrollPane = (JScrollPane)object;
        TableDetailPane tableDetailPane = this;
        boolean bl = false;
        $this$setupComponent_u24lambda_u240.getViewport().setBackground(UIManager.getColor("Table.background"));
        tableDetailPane.add((Component)object, "dock center");
    }

    @Override
    public void show(@NotNull TreePath treePath) {
        JTable jTable;
        Intrinsics.checkNotNullParameter((Object)treePath, (String)"treePath");
        super.show(treePath);
        TableModel tableModel = this.getTableModel(treePath);
        JTable $this$show_u24lambda_u240 = jTable = this.table;
        boolean bl = false;
        $this$show_u24lambda_u240.setModel(tableModel);
        this.createTableColumnModel($this$show_u24lambda_u240);
        $this$show_u24lambda_u240.setDefaultRenderer(Link.class, new LinkRenderer());
        $this$show_u24lambda_u240.setDefaultRenderer(Number.class, new NoFocusTableCellRenderer());
        $this$show_u24lambda_u240.setDefaultRenderer(String.class, new NoFocusTableCellRenderer());
        if (this.isVariableRowHeight()) {
            this.updateRowHeights();
        }
    }

    private final void updateRowHeights() {
        int n = this.table.getRowCount();
        for (int row = 0; row < n; ++row) {
            Comparable comparable;
            Iterator iterator = ((Iterable)RangesKt.until((int)0, (int)this.table.getColumnCount())).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                Dimension dimension;
                int column = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Component component = this.table.prepareRenderer(this.table.getCellRenderer(row, column), row, column);
                Intrinsics.checkNotNull((Object)component, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                JComponent c = (JComponent)component;
                Dimension dimension2 = dimension = c.getPreferredSize();
                Serializable serializable = c;
                boolean bl2 = false;
                $this$updateRowHeights_u24lambda_u240_u240.width = this.table.getColumnModel().getColumn(column).getWidth();
                serializable.setSize(dimension);
                Comparable comparable2 = Integer.valueOf(c.getPreferredSize().height);
                while (iterator.hasNext()) {
                    int column2 = ((IntIterator)iterator).nextInt();
                    $i$a$-maxOfOrNull-TableDetailPane$updateRowHeights$rowHeight$1 = false;
                    Component component2 = this.table.prepareRenderer(this.table.getCellRenderer(row, column2), row, column2);
                    Intrinsics.checkNotNull((Object)component2, (String)"null cannot be cast to non-null type javax.swing.JComponent");
                    JComponent c2 = (JComponent)component2;
                    dimension2 = c2.getPreferredSize();
                    serializable = dimension2;
                    JComponent jComponent = c2;
                    $i$a$-apply-TableDetailPane$updateRowHeights$rowHeight$1$1 = false;
                    $this$updateRowHeights_u24lambda_u240_u240.width = this.table.getColumnModel().getColumn(column2).getWidth();
                    jComponent.setSize(dimension2);
                    Comparable comparable3 = Integer.valueOf(c2.getPreferredSize().height);
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n2 = (Integer)comparable;
            int rowHeight = n2 != null ? n2.intValue() : this.table.getRowHeight();
            this.table.setRowHeight(row, rowHeight);
        }
    }

    protected float getRowHeightFactor() {
        return 1.0f;
    }

    public final void selectIndex(int index) {
        if (!(0 <= index ? index <= this.table.getRowCount() : false)) {
            boolean bl = false;
            String string = "Invalid index: " + index;
            throw new IllegalArgumentException(string.toString());
        }
        this.table.getSelectionModel().setSelectionInterval(index, index);
    }

    public static final /* synthetic */ void access$updateRowHeights(TableDetailPane $this) {
        $this.updateRowHeights();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/gjt/jclasslib/browser/detail/TableDetailPane$Companion;", "", "<init>", "()V", "noFocusBorder", "Ljavax/swing/border/Border;", "getNoFocusBorder", "()Ljavax/swing/border/Border;", "browser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Border getNoFocusBorder() {
            return noFocusBorder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/gjt/jclasslib/browser/detail/TableDetailPane$NoFocusTableCellRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "<init>", "()V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "browser"})
    private static final class NoFocusTableCellRenderer
    extends DefaultTableCellRenderer {
        public NoFocusTableCellRenderer() {
            this.setVerticalAlignment(1);
        }

        @Override
        @NotNull
        public Component getTableCellRendererComponent(@Nullable JTable table2, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
            this.setBorder(DefaultTableCellRenderer.noFocusBorder);
            return this;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0014J \u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/gjt/jclasslib/browser/detail/TableDetailPane$TableLinkListener;", "Lorg/gjt/jclasslib/util/LinkMouseListener;", "component", "Ljavax/swing/JComponent;", "<init>", "(Lorg/gjt/jclasslib/browser/detail/TableDetailPane;Ljavax/swing/JComponent;)V", "isLink", "", "point", "Ljava/awt/Point;", "link", "", "isLinkLabelHit", "row", "", "column", "browser"})
    private final class TableLinkListener
    extends LinkMouseListener {
        public TableLinkListener(JComponent component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            super(component);
        }

        @Override
        protected boolean isLink(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            int column = TableDetailPane.this.getTable().columnAtPoint(point);
            int row = TableDetailPane.this.getTable().rowAtPoint(point);
            return row >= 0 && column >= 0 && Intrinsics.areEqual(TableDetailPane.this.getTable().getColumnClass(column), Link.class) && !Intrinsics.areEqual((Object)TableDetailPane.this.getTable().getModel().getValueAt(row, column).toString(), (Object)"cp_info #0") && this.isLinkLabelHit(point, row, column);
        }

        @Override
        protected void link(@NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            TableDetailPane.this.link(TableDetailPane.this.getTable().rowAtPoint(point), TableDetailPane.this.getTable().columnAtPoint(point));
        }

        private final boolean isLinkLabelHit(Point point, int row, int column) {
            TableCellRenderer tableCellRenderer = TableDetailPane.this.getTable().getCellRenderer(row, column);
            Intrinsics.checkNotNull((Object)tableCellRenderer, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.detail.attributes.LinkRenderer");
            LinkRenderer renderer = (LinkRenderer)tableCellRenderer;
            renderer.getTableCellRendererComponent(TableDetailPane.this.getTable(), TableDetailPane.this.getTable().getModel().getValueAt(row, column), false, false, row, column);
            Rectangle cellRect = TableDetailPane.this.getTable().getCellRect(row, column, false);
            Point translatedPoint = new Point(point.x - cellRect.x, point.y - cellRect.y);
            return renderer.isLinkLabelHit(translatedPoint);
        }
    }
}

