/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.browser.config.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dom.build.BuilderKt;
import org.gjt.jclasslib.browser.config.classpath.ClassTreeNode;
import org.gjt.jclasslib.browser.config.classpath.ClasspathEntry;
import org.gjt.jclasslib.browser.config.classpath.ClasspathFileEntry;
import org.gjt.jclasslib.browser.config.classpath.FindResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002J(\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0013H\u0002R\u001b\u0010\u0006\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\""}, d2={"Lorg/gjt/jclasslib/browser/config/classpath/ClasspathDirectoryEntry;", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathFileEntry;", "fileName", "", "<init>", "(Ljava/lang/String;)V", "moduleName", "getModuleName", "()Ljava/lang/String;", "moduleName$delegate", "Lkotlin/Lazy;", "saveWorkspace", "", "element", "Lorg/w3c/dom/Element;", "findClass", "Lorg/gjt/jclasslib/browser/config/classpath/FindResult;", "className", "modulePathSelection", "", "mergeClassesIntoTree", "classPathModel", "Ljavax/swing/tree/DefaultTreeModel;", "modulePathModel", "reset", "mergeClassesIntoClassPath", "mergeClassesIntoModulePath", "mergeDirectory", "directory", "Ljava/io/File;", "parentNode", "Lorg/gjt/jclasslib/browser/config/classpath/ClassTreeNode;", "model", "Companion", "browser"})
public final class ClasspathDirectoryEntry
extends ClasspathFileEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy moduleName$delegate;
    @NotNull
    public static final String NODE_NAME = "directory";
    @NotNull
    private static final String ATTRIBUTE_PATH = "path";

    public ClasspathDirectoryEntry(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        super(fileName);
        this.moduleName$delegate = LazyKt.lazy(() -> ClasspathDirectoryEntry.moduleName_delegate$lambda$0(this));
    }

    private final String getModuleName() {
        Lazy lazy = this.moduleName$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public void saveWorkspace(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        BuilderKt.addElement$default((Element)element, (String)NODE_NAME, null, arg_0 -> ClasspathDirectoryEntry.saveWorkspace$lambda$0(this, arg_0), (int)2, null);
    }

    @Override
    @Nullable
    public FindResult findClass(@NotNull String className, boolean modulePathSelection) {
        File classFile;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        if ((!modulePathSelection || Intrinsics.areEqual((Object)ClasspathEntry.Companion.getModuleName(className), (Object)this.getModuleName())) && (classFile = new File(this.getFile(), StringsKt.replace$default((String)ClasspathEntry.Companion.getClassPathClassName(className, modulePathSelection), (char)'.', (char)'/', (boolean)false, (int)4, null) + ".class")).exists() && classFile.canRead()) {
            String string = classFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return new FindResult(string, this.getModuleName());
        }
        return null;
    }

    @Override
    public void mergeClassesIntoTree(@NotNull DefaultTreeModel classPathModel, @NotNull DefaultTreeModel modulePathModel, boolean reset) {
        Intrinsics.checkNotNullParameter((Object)classPathModel, (String)"classPathModel");
        Intrinsics.checkNotNullParameter((Object)modulePathModel, (String)"modulePathModel");
        this.mergeClassesIntoClassPath(classPathModel, reset);
        this.mergeClassesIntoModulePath(modulePathModel, reset);
    }

    private final void mergeClassesIntoClassPath(DefaultTreeModel classPathModel, boolean reset) {
        Object object = classPathModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.config.classpath.ClassTreeNode");
        ClassTreeNode rootNode = (ClassTreeNode)object;
        this.mergeDirectory(this.getFile(), rootNode, classPathModel, reset);
    }

    private final void mergeClassesIntoModulePath(DefaultTreeModel modulePathModel, boolean reset) {
        Object object = modulePathModel.getRoot();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gjt.jclasslib.browser.config.classpath.ClassTreeNode");
        ClassTreeNode rootNode = (ClassTreeNode)object;
        ClassTreeNode moduleNode = this.addOrFindNode(this.getModuleName(), rootNode, true, modulePathModel, reset);
        this.mergeDirectory(this.getFile(), moduleNode, modulePathModel, reset);
    }

    private final void mergeDirectory(File directory, ClassTreeNode parentNode, DefaultTreeModel model, boolean reset) {
        File[] fileArray = directory.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                String string = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                ClassTreeNode directoryNode = this.addOrFindNode(string, parentNode, true, model, reset);
                Intrinsics.checkNotNull((Object)file);
                this.mergeDirectory(file, directoryNode, model, reset);
                if (directoryNode.getChildCount() != 0) continue;
                int deletionIndex = parentNode.getIndex(directoryNode);
                parentNode.remove(directoryNode);
                if (reset) continue;
                Object[] objectArray = new int[]{deletionIndex};
                int[] nArray = objectArray;
                objectArray = new Object[1];
                objectArray[0] = (int)directoryNode;
                model.nodesWereRemoved(parentNode, nArray, objectArray);
                continue;
            }
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) continue;
            String string3 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            if (StringsKt.endsWith$default((String)string3, (String)"module-info.class", (boolean)false, (int)2, null) && parentNode.getParent() == null) continue;
            String string4 = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
            this.addOrFindNode(this.stripClassSuffix(string4), parentNode, false, model, reset);
        }
    }

    private static final String moduleName_delegate$lambda$0(ClasspathDirectoryEntry this$0) {
        File moduleInfoFile = new File(this$0.getFile(), "module-info.class");
        String string = moduleInfoFile.exists() ? this$0.getModuleName(new FileInputStream(moduleInfoFile)) : null;
        if (string == null) {
            string = "<unnamed module>";
        }
        return string;
    }

    private static final Unit saveWorkspace$lambda$0(ClasspathDirectoryEntry this$0, Element $this$addElement) {
        Intrinsics.checkNotNullParameter((Object)$this$addElement, (String)"$this$addElement");
        $this$addElement.setAttribute(ATTRIBUTE_PATH, this$0.getFile().getPath());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/gjt/jclasslib/browser/config/classpath/ClasspathDirectoryEntry$Companion;", "", "<init>", "()V", "NODE_NAME", "", "ATTRIBUTE_PATH", "create", "Lorg/gjt/jclasslib/browser/config/classpath/ClasspathDirectoryEntry;", "element", "Lorg/w3c/dom/Element;", "browser"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClasspathDirectoryEntry create(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string = element.getAttribute(ClasspathDirectoryEntry.ATTRIBUTE_PATH);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttribute(...)");
            return new ClasspathDirectoryEntry(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

