/*
 * Decompiled with CFR 0.152.
 */
package com.exe4j.runtime.util;

import com.exe4j.runtime.util.FileUtil;
import com.exe4j.runtime.util.LauncherPlatformUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Properties;

public class ResourceHelper {
    private static final String URL_JAR_PREFIX = "jar:file:";
    private static final String URL_NESTED_JAR_PREFIX = "jar:nested:";
    private static final String URL_FILE_PREFIX = "file:";
    public static final String DEVELOPMENT_RUNTIME_DIR = "dist/install4j/resource";
    private static final String PROPERTY_INSTALL4J_RUNTIME_DIR = "install4j.runtimeDir";
    private static final String NATIVE_RESOURCE_PATH = "com/install4j/native/";
    private static final String NATIVE_FILE_LIST_PATH = "com/install4j/native/files.txt";
    private static File runtimeDir;
    private static boolean fromFile;

    public static URL getImageURL(String fileName) {
        try {
            return new File(ResourceHelper.getRuntimeDir(), fileName).toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setRuntimeDir(File runtimeDir) {
        ResourceHelper.runtimeDir = runtimeDir;
    }

    public static boolean isFromFile() {
        ResourceHelper.getRuntimeDir();
        return fromFile;
    }

    public static File getRuntimeDir() {
        if (runtimeDir == null) {
            String className = ResourceHelper.class.getName().replace('.', '/') + ".class";
            String simpleName = className.substring(className.lastIndexOf(47) + 1);
            URL resource = ResourceHelper.class.getResource(simpleName);
            if (resource == null) {
                return null;
            }
            String classLocation = resource.toString();
            String baseName = classLocation.substring(0, classLocation.lastIndexOf(className) - 1);
            int lastIndex = (baseName = ResourceHelper.getDecodedPath(baseName)).lastIndexOf(47);
            if (lastIndex == -1) {
                lastIndex = baseName.lastIndexOf(92);
            }
            if (lastIndex == -1 && !classLocation.startsWith("rsrc:")) {
                return null;
            }
            String externalRuntimeDir = System.getProperty(PROPERTY_INSTALL4J_RUNTIME_DIR);
            if (externalRuntimeDir != null && !externalRuntimeDir.isEmpty()) {
                try {
                    runtimeDir = new File(externalRuntimeDir).getCanonicalFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String moduleName = System.getProperty("exe4j.moduleName");
                if (baseName.startsWith(URL_FILE_PREFIX)) {
                    fromFile = true;
                    baseName = baseName.substring(URL_FILE_PREFIX.length(), lastIndex);
                    ResourceHelper.initDevelopmentRuntimeDir(new File(baseName, "../../"));
                } else if (baseName.startsWith(URL_JAR_PREFIX) || baseName.startsWith(URL_NESTED_JAR_PREFIX)) {
                    baseName = baseName.startsWith(URL_JAR_PREFIX) ? baseName.substring(URL_JAR_PREFIX.length(), lastIndex) : baseName.substring(URL_NESTED_JAR_PREFIX.length(), lastIndex);
                    String nativePlatform = ResourceHelper.getNativePlatform();
                    runtimeDir = nativePlatform != null && moduleName == null && ResourceHelper.isNativeFileListAvailable() ? ResourceHelper.extractNativeDir(nativePlatform) : new File(baseName);
                } else if (moduleName != null) {
                    File file = new File(moduleName);
                    while (file.getParentFile() != null && !new File(file.getParentFile(), ".install4j").isDirectory()) {
                        file = file.getParentFile();
                    }
                    runtimeDir = new File(file.getParentFile(), ".install4j");
                }
            }
            if (runtimeDir == null) {
                throw new RuntimeException("cannot find runtime dir from " + classLocation + " or " + System.getProperty("exe4j.moduleName"));
            }
        }
        return runtimeDir;
    }

    private static boolean isNativeFileListAvailable() {
        return ResourceHelper.class.getClassLoader().getResource(NATIVE_FILE_LIST_PATH) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractNativeDir(String nativePlatform) {
        try {
            File nativeDir = new File(System.getProperty("java.io.tmpdir"), "install4jNative");
            File nativeBuildDir = new File(nativeDir, ResourceHelper.getBuildNumber());
            File nativePlatformDir = new File(nativeBuildDir, nativePlatform);
            if (ResourceHelper.isNativePlatformDirEmpty(nativePlatformDir)) {
                InputStream stream = ResourceHelper.class.getClassLoader().getResourceAsStream(NATIVE_FILE_LIST_PATH);
                String platformPrefix = nativePlatform + "/";
                List<String> paths = FileUtil.readLines(stream);
                for (String path : paths) {
                    if (!path.startsWith(platformPrefix)) continue;
                    InputStream input = ResourceHelper.class.getClassLoader().getResourceAsStream(NATIVE_RESOURCE_PATH + path);
                    File outputFile = new File(nativeBuildDir, path);
                    outputFile.getParentFile().mkdirs();
                    try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(outputFile));){
                        FileUtil.pumpStream(input, output);
                    }
                }
            }
            return nativePlatformDir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isNativePlatformDirEmpty(File nativePlatformDir) {
        if (!nativePlatformDir.exists()) {
            return true;
        }
        File[] files = nativePlatformDir.listFiles();
        return files == null || files.length == 0;
    }

    private static String getBuildNumber() throws IOException {
        InputStream stream = ResourceHelper.class.getClassLoader().getResourceAsStream("META-INF/install4j.properties");
        Properties properties = new Properties();
        properties.load(stream);
        return properties.getProperty("build");
    }

    private static String getNativePlatform() {
        if (LauncherPlatformUtil.isWindows()) {
            if (LauncherPlatformUtil.isAarch64()) {
                return "windows-arm64";
            }
            if (LauncherPlatformUtil.isX86()) {
                return "windows-x32";
            }
            return "windows-x64";
        }
        if (LauncherPlatformUtil.isMacOS()) {
            return "macos";
        }
        return null;
    }

    private static void initDevelopmentRuntimeDir(File buildDir) {
        try {
            buildDir = buildDir.getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        runtimeDir = new File(buildDir, "c");
        if (!new File(runtimeDir, "i4jinst.dll.64").exists()) {
            runtimeDir = new File(buildDir, "../dist/install4j/resource");
        }
    }

    private static String getDecodedPath(String path) {
        StringBuilder stringbuffer = new StringBuilder();
        int i = 0;
        while (i < path.length()) {
            char c = path.charAt(i);
            if (c != '%') {
                ++i;
            } else {
                try {
                    c = ResourceHelper.unescape(path, i);
                    i += 3;
                    if ((c & 0x80) != 0) {
                        switch (c >> 4) {
                            case 12: 
                            case 13: {
                                char c1 = ResourceHelper.unescape(path, i);
                                i += 3;
                                c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                                break;
                            }
                            case 14: {
                                char c2 = ResourceHelper.unescape(path, i);
                                char c3 = ResourceHelper.unescape(path, i += 3);
                                i += 3;
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException();
                }
            }
            stringbuffer.append(c);
        }
        return stringbuffer.toString();
    }

    private static char unescape(String s, int i) {
        return (char)Integer.parseInt(s.substring(i + 1, i + 3), 16);
    }

    private ResourceHelper() {
    }
}

