/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Contour;
import com.jidesoft.swing.HeavyweightWrapper;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSplitPaneDivider;
import com.jidesoft.swing.JideSplitPaneLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class JideSplitPane
extends JPanel
implements ContainerListener,
ComponentListener,
Accessible {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    public static final int VERTICAL_SPLIT = 0;
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final String PROPERTY_DIVIDER_LOCATION = "dividerLocation";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String GRIPPER_PROPERTY = "gripper";
    public static final String PROPORTIONAL_LAYOUT_PROPERTY = "proportionalLayout";
    public static final String PROPORTIONS_PROPERTY = "proportions";
    public static final String PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED = "heavyweightComponentEnabled";
    private int _orientation;
    private int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    private HeavyweightWrapper _nonContinuousLayoutDividerWrapper;
    private boolean _continuousLayout = false;
    private Container _layeredPane;
    private boolean _showGripper = false;
    private boolean _proportionalLayout = false;
    private double[] _proportions;
    private boolean _initiallyEven = true;
    private boolean _heavyweightComponentEnabled = false;
    public WindowAdapter _windowDeactivatedListener;
    private int _dividerStepSize = 0;
    private boolean _dragResizable = true;
    private boolean _hiddenByMyself = false;
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    private boolean _oneTouchExpandable = false;
    private int oneTouchExpandableDividerSize = 8;
    private ImageIcon _leftOneTouchButtonImageIcon = null;
    private ImageIcon _rightOneTouchButtonImageIcon = null;

    public JideSplitPane() {
        this(1);
    }

    public JideSplitPane(int n2) {
        this._orientation = n2;
        if (this._orientation != 1 && this._orientation != 0) {
            throw new IllegalArgumentException("cannot create JideSplitPane, orientation must be one of JideSplitPane.HORIZONTAL_SPLIT or JideSplitPane.VERTICAL_SPLIT");
        }
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        super.setLayout(jideSplitPaneLayout);
        this.setOpaque(false);
        this.installListeners();
    }

    public int getDividerStepSize() {
        return this._dividerStepSize;
    }

    public void setDividerStepSize(int n2) {
        if (n2 < 0) {
            return;
        }
        this._dividerStepSize = n2;
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get("JideSplitPane.dividerSize") == null) {
            LookAndFeelFactory.installJideExtension();
        }
        super.updateUI();
    }

    private void installListeners() {
        this.addContainerListener(this);
    }

    public void setDividerSize(int n2) {
        int n3 = this._dividerSize;
        if (n3 != n2) {
            this._dividerSize = n2;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n3, n2);
            this.invalidate();
        }
    }

    public int getDividerSize() {
        return this._dividerSize;
    }

    public Component insertPane(Component component, int n2) {
        return this.insertPane(component, null, n2);
    }

    public Component insertPane(Component component, Object object, int n2) {
        if (n2 <= 0) {
            this.addImpl(component, object, 0);
        } else if (n2 >= this.getPaneCount()) {
            this.addImpl(component, object, -1);
        } else {
            this.addImpl(component, object, (n2 << 1) - 1);
        }
        return component;
    }

    public Component addPane(Component component) {
        if (component == null) {
            return null;
        }
        return super.add(component);
    }

    public void removePane(Component component) {
        this.removePane(this.indexOfPane(component));
    }

    public void setPaneAt(Component component, int n2) {
        this.setPaneAt(component, null, n2);
    }

    public void setPaneAt(Component component, Object object, int n2) {
        double[] dArray = this._proportions;
        this._proportions = null;
        this.removePane(n2);
        this.insertPane(component, object, n2);
        this._proportions = dArray;
        this.validate();
    }

    public void removePane(int n2) {
        if (n2 == 0) {
            super.remove(0);
        } else {
            super.remove(n2 << 1);
        }
    }

    public void setOrientation(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("JideSplitPane: orientation must be one of JideSplitPane.VERTICAL_SPLIT or JideSplitPane.HORIZONTAL_SPLIT");
        }
        if (this._orientation == n2) {
            return;
        }
        int n3 = this._orientation;
        this._orientation = n2;
        JideSplitPaneLayout jideSplitPaneLayout = this._orientation == 1 ? new JideSplitPaneLayout(this, 0) : new JideSplitPaneLayout(this, 1);
        Component[] componentArray = this.getComponents();
        LayoutManager layoutManager = this.getLayout();
        Map<Component, Object> map = null;
        if (layoutManager instanceof JideSplitPaneLayout) {
            map = ((JideSplitPaneLayout)layoutManager).getConstraintMap();
        }
        if (componentArray != null && map != null) {
            for (Component component : componentArray) {
                jideSplitPaneLayout.addLayoutComponent(component, map.get(component));
            }
        }
        super.setLayout(jideSplitPaneLayout);
        this.doLayout();
        this.firePropertyChange(ORIENTATION_PROPERTY, n3, n2);
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void resetToPreferredSizes() {
        if (this.getLayout() instanceof JideBoxLayout) {
            boolean bl2 = ((JideBoxLayout)this.getLayout()).isResetWhenInvalidate();
            try {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(true);
                ((JideBoxLayout)this.getLayout()).invalidateLayout(this);
            }
            finally {
                ((JideBoxLayout)this.getLayout()).setResetWhenInvalidate(bl2);
            }
        }
        this.doLayout();
    }

    public void setProportionalLayout(boolean bl2) {
        if (bl2 == this._proportionalLayout) {
            return;
        }
        this._proportionalLayout = bl2;
        this.revalidate();
        this.firePropertyChange(PROPORTIONAL_LAYOUT_PROPERTY, !bl2, bl2);
        if (!bl2) {
            this.setProportions(null);
        }
    }

    public boolean isProportionalLayout() {
        return this._proportionalLayout;
    }

    void internalSetProportions(double[] dArray) {
        this._proportions = dArray;
    }

    public void setProportions(double[] dArray) {
        int n2;
        if (!this._proportionalLayout && dArray != null) {
            throw new IllegalStateException("Can't set proportions on a non-proportional split pane");
        }
        if (Arrays.equals(dArray, this._proportions)) {
            return;
        }
        if (dArray != null && dArray.length != this.getPaneCount() - 1) {
            throw new IllegalArgumentException("Must provide one fewer proportions than there are panes: got " + dArray.length + ", expected " + (this.getPaneCount() - 1));
        }
        if (dArray != null) {
            double d2 = 0.0;
            for (n2 = 0; n2 < dArray.length; ++n2) {
                if (dArray[n2] < 0.0) {
                    dArray[n2] = 0.0;
                }
                if (dArray[n2] > 1.0) {
                    dArray[n2] = 1.0;
                }
                d2 += dArray[n2];
            }
            if (d2 > 1.0) {
                throw new IllegalArgumentException("Sum of proportions must be no more than 1, got " + d2);
            }
        }
        double[] dArray2 = this._proportions;
        this._proportions = dArray == null ? null : (double[])dArray.clone();
        LayoutManager layoutManager = this.getLayout();
        n2 = 0;
        if (layoutManager instanceof JideBoxLayout) {
            n2 = ((JideBoxLayout)layoutManager).isResetWhenInvalidate() ? 1 : 0;
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
        }
        this.revalidate();
        if (n2 != 0) {
            ((JideBoxLayout)layoutManager).setResetWhenInvalidate(n2 != 0);
        }
        this.firePropertyChange(PROPORTIONS_PROPERTY, dArray2, dArray);
    }

    public double[] getProportions() {
        double[] dArray = this._proportions;
        if (dArray != null) {
            dArray = (double[])dArray.clone();
        }
        return dArray;
    }

    public void setInitiallyEven(boolean bl2) {
        this._initiallyEven = bl2;
    }

    public boolean isInitiallyEven() {
        return this._initiallyEven;
    }

    @Override
    public boolean isValidateRoot() {
        return true;
    }

    protected void startDragging(JideSplitPaneDivider jideSplitPaneDivider) {
        if (!this.isContinuousLayout()) {
            Container container = this.getTopLevelAncestor();
            if (this._windowDeactivatedListener == null) {
                this._windowDeactivatedListener = new WindowAdapter(){

                    @Override
                    public void windowDeactivated(WindowEvent windowEvent) {
                        JideSplitPane.this.stopDragging();
                        if (windowEvent.getWindow() != null) {
                            windowEvent.getWindow().removeWindowListener(JideSplitPane.this._windowDeactivatedListener);
                        }
                    }
                };
            }
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this._windowDeactivatedListener);
            }
            if (container instanceof RootPaneContainer) {
                Serializable serializable;
                this._layeredPane = ((RootPaneContainer)((Object)container)).getLayeredPane();
                if (this._nonContinuousLayoutDividerWrapper == null) {
                    serializable = new JideSplitPaneContour();
                    this._nonContinuousLayoutDividerWrapper = new JideSplitPaneHeavyweightWrapper((Component)serializable);
                    this._nonContinuousLayoutDividerWrapper.setHeavyweight(this.isHeavyweightComponentEnabled());
                }
                this._nonContinuousLayoutDividerWrapper.delegateSetCursor(this._orientation == 1 ? JideSplitPaneDivider.HORIZONTAL_CURSOR : JideSplitPaneDivider.VERTICAL_CURSOR);
                this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
                this._nonContinuousLayoutDividerWrapper.delegateAdd(this._layeredPane, JLayeredPane.DRAG_LAYER);
                serializable = this.getVisibleRect();
                Rectangle rectangle = SwingUtilities.convertRectangle(this, (Rectangle)serializable, this._layeredPane);
                int n2 = Math.min(4, this.getDividerSize());
                if (this.getOrientation() == 1) {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, n2, rectangle.height);
                } else {
                    this._nonContinuousLayoutDividerWrapper.delegateSetBounds(rectangle.x, rectangle.y, rectangle.width, n2);
                }
            }
        }
    }

    private void stopDragging() {
        if (!this.isContinuousLayout() && this._layeredPane != null && this._nonContinuousLayoutDividerWrapper != null) {
            Component[] componentArray;
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(false);
            this._nonContinuousLayoutDividerWrapper.delegateRemove(this._layeredPane);
            this._nonContinuousLayoutDividerWrapper.delegateSetNull();
            this._nonContinuousLayoutDividerWrapper = null;
            for (Component component : componentArray = this._layeredPane.getComponents()) {
                if (!(component instanceof JideSplitPaneContour) && !(component instanceof JideSplitPaneHeavyweightWrapper)) continue;
                this._layeredPane.remove(component);
            }
        }
    }

    protected void dragDividerTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this._layeredPane == null || this.isContinuousLayout()) {
            this.setDividerLocation(jideSplitPaneDivider, n2);
        } else if (this._nonContinuousLayoutDividerWrapper != null) {
            Point point;
            Dimension dimension = new Dimension();
            Rectangle rectangle = this.getVisibleRect();
            int n3 = Math.min(4, this.getDividerSize());
            Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, this._layeredPane);
            if (this.getOrientation() == 1) {
                point = SwingUtilities.convertPoint(this, n2, rectangle.y, this._layeredPane);
                point.x += this.getDividerSize() - n3 >> 1;
                dimension.width = n3;
                dimension.height = rectangle2.height;
            } else {
                point = SwingUtilities.convertPoint(this, rectangle.x, n2, this._layeredPane);
                point.y += this.getDividerSize() - n3 >> 1;
                dimension.width = rectangle2.width;
                dimension.height = n3;
            }
            this._nonContinuousLayoutDividerWrapper.delegateSetBounds(new Rectangle(point, dimension));
            this._nonContinuousLayoutDividerWrapper.delegateSetVisible(true);
        }
    }

    protected void finishDraggingTo(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        if (this.isContinuousLayout() || this._nonContinuousLayoutDividerWrapper != null) {
            this.stopDragging();
            this.setDividerLocation(jideSplitPaneDivider, n2);
        }
    }

    public int indexOfDivider(JideSplitPaneDivider jideSplitPaneDivider) {
        int n2 = this.indexOf(jideSplitPaneDivider);
        if (n2 == -1) {
            return n2;
        }
        if (n2 % 2 == 0) {
            System.err.println("Warning: divider's index is even. (index = " + n2 + ")");
        }
        return (n2 - 1) / 2;
    }

    public int indexOfPane(Component component) {
        int n2 = this.indexOf(component);
        if (n2 == -1) {
            return -1;
        }
        if (n2 % 2 != 0) {
            System.err.println("Warning: pane's index is odd. (index = " + n2 + ")");
        }
        return n2 >> 1;
    }

    public int indexOf(Component component) {
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            if (!this.getComponent(i2).equals(component)) continue;
            return i2;
        }
        return -1;
    }

    public JideSplitPaneDivider getDividerAt(int n2) {
        if (n2 < 0 || n2 * 2 + 1 >= this.getComponentCount()) {
            return null;
        }
        return (JideSplitPaneDivider)this.getComponent(n2 * 2 + 1);
    }

    public Component getPaneAt(int n2) {
        if (n2 < 0 || n2 << 1 >= this.getComponentCount()) {
            return null;
        }
        return this.getComponent(n2 << 1);
    }

    public int getPaneCount() {
        return this.getComponentCount() + 1 >> 1;
    }

    public void setDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, int n2) {
        this.setDividerLocation(this.indexOfDivider(jideSplitPaneDivider), n2);
    }

    public void setDividerLocation(int n2, int n3) {
        ((JideSplitPaneLayout)this.getLayout()).setDividerLocation(n2, n3, true);
        this.validate();
    }

    public int getDividerLocation(int n2) {
        return ((JideSplitPaneLayout)this.getLayout()).getDividerLocation(n2);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        containerEvent.getChild().addComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.addExtraDividers();
            if (this.isOneTouchExpandable()) {
                containerEvent.getChild().setMinimumSize(new Dimension(0, 0));
            }
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        containerEvent.getChild().removeComponentListener(this);
        if (!(containerEvent.getChild() instanceof JideSplitPaneDivider)) {
            this.removeExtraDividers();
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() instanceof JideSplitPaneDivider) {
            return;
        }
        this.setDividersVisible();
        this.resetToPreferredSizes();
    }

    protected boolean removeExtraDividers() {
        int n2 = 0;
        if (this.getComponentCount() == 0) {
            if (this._proportions != null) {
                this.setProportions(null);
            }
            return false;
        }
        boolean bl2 = false;
        if (this.getComponent(0) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(0)).setJideSplitPane(null);
            this.remove(0);
            this.removeProportion(0);
            bl2 = true;
        }
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (component instanceof JideSplitPaneDivider) {
                if (++n2 != 2) continue;
                component = this.getComponent(i2 - 1);
                ((JideSplitPaneDivider)component).setJideSplitPane(null);
                this.remove(component);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length) {
                    this.removeProportion(i2 / 2);
                }
                bl2 = true;
                --n2;
                --i2;
                continue;
            }
            n2 = 0;
        }
        if (n2 == 1 && this.getComponent(this.getComponentCount() - 1) instanceof JideSplitPaneDivider) {
            ((JideSplitPaneDivider)this.getComponent(this.getComponentCount() - 1)).setJideSplitPane(null);
            this.remove(this.getComponentCount() - 1);
            this.removeProportion((this.getComponentCount() + 1) / 2);
            bl2 = true;
        }
        return bl2;
    }

    protected void removeProportion(int n2) {
        int n3;
        double d2;
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        if (dArray.length <= 1) {
            this.setProportions(null);
            return;
        }
        double[] dArray2 = new double[dArray.length - 1];
        if (n2 < dArray.length) {
            d2 = dArray[n2];
        } else {
            d2 = 1.0;
            double[] dArray3 = dArray;
            int n4 = dArray3.length;
            for (n3 = 0; n3 < n4; ++n3) {
                double d3 = dArray3[n3];
                d2 -= d3;
            }
        }
        double d4 = 1.0 - d2;
        for (n3 = 0; n3 < dArray2.length; ++n3) {
            int n5 = n3 < n2 ? n3 : n3 + 1;
            dArray2[n3] = dArray[n5] / d4;
        }
        if (dArray2.length == 1) {
            // empty if block
        }
        this.setProportions(dArray2);
    }

    protected void addExtraDividers() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            if (!(component instanceof JideSplitPaneDivider)) {
                if (++n2 != 2) continue;
                this.add(this.createSplitPaneDivider(), "fix", i2);
                if (this._proportions != null && this.getPaneCount() == this._proportions.length + 2) {
                    this.addProportion((i2 + 1) / 2);
                }
                n2 = 0;
                continue;
            }
            n2 = 0;
        }
    }

    protected void addProportion(int n2) {
        double[] dArray = this._proportions;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = new double[dArray.length + 1];
        double d2 = 1.0 / (double)(dArray2.length + 1);
        double d3 = 1.0 - d2;
        for (int i2 = 0; i2 < dArray2.length; ++i2) {
            if (i2 == n2) {
                dArray2[i2] = d2;
                continue;
            }
            int n3 = i2 < n2 ? i2 : i2 - 1;
            dArray2[i2] = n3 < dArray.length ? dArray[n3] * d3 : d2;
        }
        this.setProportions(dArray2);
    }

    @Override
    public void setVisible(boolean bl2) {
        this._hiddenByMyself = false;
        super.setVisible(bl2);
    }

    protected void setDividersVisible() {
        boolean bl2 = false;
        if (this.getComponentCount() == 1) {
            bl2 = this.getComponent(0).isVisible();
        } else if (this.getComponentCount() > 1) {
            boolean bl3 = false;
            for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
                boolean bl4;
                Component component = this.getComponent(i2);
                if (!(component instanceof JideSplitPaneDivider)) {
                    if (!component.isVisible() || bl2) continue;
                    bl2 = true;
                    continue;
                }
                boolean bl5 = i2 - 1 >= 0 && this.getComponent(i2 - 1).isVisible();
                boolean bl6 = bl4 = i2 + 1 < this.getComponentCount() && this.getComponent(i2 + 1).isVisible();
                if (bl5 && bl4) {
                    component.setVisible(true);
                    continue;
                }
                if (!bl5 && !bl4) {
                    component.setVisible(false);
                    continue;
                }
                if (bl5 && !bl4) {
                    component.setVisible(false);
                    bl3 = true;
                    continue;
                }
                if (bl3) {
                    component.setVisible(true);
                    bl3 = false;
                    continue;
                }
                component.setVisible(false);
            }
        }
        if (!bl2) {
            super.setVisible(false);
            this._hiddenByMyself = true;
        } else if (this._hiddenByMyself) {
            super.setVisible(true);
        }
    }

    protected JideSplitPaneDivider createSplitPaneDivider() {
        return new JideSplitPaneDivider(this);
    }

    protected int getPreviousDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl2, boolean bl3) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (bl3) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl2 || this.getDividerAt(n4).isVisible()) {
                        n3 = this._orientation == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl2 && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 + this.getDividerSize();
        }
        return 0;
    }

    public int getNextDividerLocation(JideSplitPaneDivider jideSplitPaneDivider, boolean bl2, boolean bl3) {
        int n2 = this.indexOfDivider(jideSplitPaneDivider);
        int n3 = -1;
        if (!bl3) {
            if ((n2 + 1) * 2 + 1 <= this.getComponentCount()) {
                int n4 = n2 + 1;
                while (n4 * 2 + 1 < this.getComponentCount()) {
                    if (bl2 || this.getDividerAt(n4).isVisible()) {
                        n3 = this._orientation == 1 ? this.getDividerAt((int)n4).getBounds().x : this.getDividerAt((int)n4).getBounds().y;
                        break;
                    }
                    ++n4;
                }
            }
        } else if (n2 > 0) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (!bl2 && !this.getDividerAt(i2).isVisible()) continue;
                n3 = this._orientation == 1 ? this.getDividerAt((int)i2).getBounds().x : this.getDividerAt((int)i2).getBounds().y;
                break;
            }
        }
        if (n3 != -1) {
            return n3 - this.getDividerSize();
        }
        return this.getOrientation() == 1 ? this.getWidth() - this.getDividerSize() : this.getHeight() - this.getDividerSize();
    }

    public boolean isShowGripper() {
        return this._showGripper;
    }

    public void setShowGripper(boolean bl2) {
        boolean bl3 = this._showGripper;
        if (bl3 != bl2) {
            this._showGripper = bl2;
            this.firePropertyChange(GRIPPER_PROPERTY, bl3, this._showGripper);
        }
    }

    @Override
    public void doLayout() {
        if (this.removeExtraDividers()) {
            ((JideSplitPaneLayout)this.getLayout()).invalidateLayout(this);
        }
        super.doLayout();
    }

    public boolean isContinuousLayout() {
        return this._continuousLayout;
    }

    public void setContinuousLayout(boolean bl2) {
        boolean bl3 = this._continuousLayout;
        this._continuousLayout = bl2;
        this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl3, bl2);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJideSplitPane();
        }
        return this.accessibleContext;
    }

    public boolean isDragResizable() {
        return this._dragResizable;
    }

    public void setDragResizable(boolean bl2) {
        this._dragResizable = bl2;
    }

    public boolean isHeavyweightComponentEnabled() {
        return this._heavyweightComponentEnabled;
    }

    public void setHeavyweightComponentEnabled(boolean bl2) {
        boolean bl3 = this._heavyweightComponentEnabled;
        if (this._heavyweightComponentEnabled != bl2) {
            this._heavyweightComponentEnabled = bl2;
            this.firePropertyChange(PROPERTY_HEAVYWEIGHT_COMPONENT_ENABLED, bl3, this._heavyweightComponentEnabled);
        }
    }

    public void setOneTouchExpandable(boolean bl2) {
        boolean bl3 = this._oneTouchExpandable;
        if (bl3 != bl2) {
            this._oneTouchExpandable = bl2;
            LayoutManager layoutManager = this.getLayout();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(true);
            }
            if (bl2) {
                this.setDividerSize(this.oneTouchExpandableDividerSize);
            } else {
                this.setDividerSize(UIDefaultsLookup.getInt("JideSplitPane.dividerSize"));
            }
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl3, this._oneTouchExpandable);
            this.revalidate();
            this.repaint();
            if (layoutManager instanceof JideBoxLayout) {
                ((JideBoxLayout)layoutManager).setResetWhenInvalidate(false);
            }
        }
    }

    public boolean isOneTouchExpandable() {
        return this._oneTouchExpandable;
    }

    public void setLeftOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._leftOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getLeftOneTouchButtonImageIcon() {
        return this._leftOneTouchButtonImageIcon;
    }

    public void setRightOneTouchButtonImageIcon(ImageIcon imageIcon) {
        this._rightOneTouchButtonImageIcon = imageIcon;
    }

    public ImageIcon getRightOneTouchButtonImageIcon() {
        return this._rightOneTouchButtonImageIcon;
    }

    public void setDividerLocations(int[] nArray) {
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            this.setDividerLocation(i2, n2);
        }
    }

    public int[] getDividerLocations() {
        int n2 = this.getPaneCount();
        if (this.getPaneCount() == 0) {
            return new int[0];
        }
        int[] nArray = new int[n2 - 1];
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            nArray[i2] = this.getDividerLocation(i2);
        }
        return nArray;
    }

    private class JideSplitPaneContour
    extends Contour {
        public JideSplitPaneContour() {
        }

        public JideSplitPaneContour(int n2) {
            super(n2);
        }
    }

    private class JideSplitPaneHeavyweightWrapper
    extends HeavyweightWrapper {
        public JideSplitPaneHeavyweightWrapper(Component component) {
            super(component);
        }
    }

    protected class AccessibleJideSplitPane
    extends JComponent.AccessibleJComponent {
        private static final long serialVersionUID = -6167624875135108683L;

        protected AccessibleJideSplitPane() {
            super(JideSplitPane.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JideSplitPane.this.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            } else {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            }
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }
    }
}

