/*
 * Decompiled with CFR 0.152.
 */
package com.jprofiler.api.controller;

public class TrackingOptions {
    public static final TrackingOptions NONE = new TrackingOptions().freeze();
    public static final TrackingOptions PLATFORM_THREAD = new TrackingOptions().platformThread(true).freeze();
    public static final TrackingOptions EXECUTORS = new TrackingOptions().executors(true).freeze();
    public static final TrackingOptions AWT = new TrackingOptions().awt(true).freeze();
    public static final TrackingOptions SWT = new TrackingOptions().swt(true).freeze();
    public static final TrackingOptions RMI = new TrackingOptions().rmi(true).freeze();
    public static final TrackingOptions GRPC = new TrackingOptions().grpc(true).freeze();
    public static final TrackingOptions REMOTE_EJB = new TrackingOptions().remoteEjb(true).freeze();
    public static final TrackingOptions HTTP = new TrackingOptions().http(true).freeze();
    public static final TrackingOptions KOTLIN_COROUTINES = new TrackingOptions().kotlinCoroutines(true).freeze();
    public static final TrackingOptions VIRTUAL_THREAD = new TrackingOptions().virtualThread(true).freeze();
    private boolean platformThread = false;
    private boolean virtualThread = false;
    private boolean executors = false;
    private boolean awt = false;
    private boolean swt = false;
    private boolean rmi = false;
    private boolean grpc = false;
    private boolean remoteEjb = false;
    private boolean http = false;
    private boolean kotlinCoroutines = false;
    private boolean frozen = false;

    public TrackingOptions platformThread(boolean threadStart) {
        this.checkFrozen();
        this.platformThread = threadStart;
        return this;
    }

    public TrackingOptions virtualThread(boolean threadStart) {
        this.checkFrozen();
        this.virtualThread = threadStart;
        return this;
    }

    public TrackingOptions executors(boolean executors) {
        this.checkFrozen();
        this.executors = executors;
        return this;
    }

    public TrackingOptions awt(boolean awt) {
        this.checkFrozen();
        this.awt = awt;
        return this;
    }

    public TrackingOptions swt(boolean swt) {
        this.checkFrozen();
        this.swt = swt;
        return this;
    }

    public TrackingOptions rmi(boolean rmi) {
        this.checkFrozen();
        this.rmi = rmi;
        return this;
    }

    public TrackingOptions grpc(boolean grpc) {
        this.checkFrozen();
        this.grpc = grpc;
        return this;
    }

    public TrackingOptions http(boolean http) {
        this.checkFrozen();
        this.http = http;
        return this;
    }

    public TrackingOptions remoteEjb(boolean remoteEjb) {
        this.checkFrozen();
        this.remoteEjb = remoteEjb;
        return this;
    }

    public TrackingOptions kotlinCoroutines(boolean kotlinCoroutines) {
        this.checkFrozen();
        this.kotlinCoroutines = kotlinCoroutines;
        return this;
    }

    public boolean isPlatformThread() {
        return this.platformThread;
    }

    public boolean isVirtualThread() {
        return this.virtualThread;
    }

    public boolean isExecutors() {
        return this.executors;
    }

    public boolean isAwt() {
        return this.awt;
    }

    public boolean isSwt() {
        return this.swt;
    }

    public boolean isRmi() {
        return this.rmi;
    }

    public boolean isGrpc() {
        return this.grpc;
    }

    public boolean isHttp() {
        return this.http;
    }

    public boolean isRemoteEjb() {
        return this.remoteEjb;
    }

    public boolean isKotlinCoroutines() {
        return this.kotlinCoroutines;
    }

    public TrackingOptions freeze() {
        this.frozen = true;
        return this;
    }

    private void checkFrozen() {
        if (this.frozen) {
            throw new UnsupportedOperationException("parameters are frozen");
        }
    }
}

