/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KClasses;
import org.gjt.jclasslib.Expect_jvmKt;
import org.gjt.jclasslib.io.DataInput;
import org.gjt.jclasslib.io.DataOutput;
import org.gjt.jclasslib.structures.AttributeInfo;
import org.gjt.jclasslib.structures.ClassFile;
import org.gjt.jclasslib.structures.Package;
import org.gjt.jclasslib.structures.attributes.AnnotationDefaultAttribute;
import org.gjt.jclasslib.structures.attributes.BootstrapMethodsAttribute;
import org.gjt.jclasslib.structures.attributes.CodeAttribute;
import org.gjt.jclasslib.structures.attributes.ConstantValueAttribute;
import org.gjt.jclasslib.structures.attributes.DeprecatedAttribute;
import org.gjt.jclasslib.structures.attributes.EnclosingMethodAttribute;
import org.gjt.jclasslib.structures.attributes.ExceptionsAttribute;
import org.gjt.jclasslib.structures.attributes.InnerClassesAttribute;
import org.gjt.jclasslib.structures.attributes.LineNumberTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTableAttribute;
import org.gjt.jclasslib.structures.attributes.LocalVariableTypeTableAttribute;
import org.gjt.jclasslib.structures.attributes.MethodParametersAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleHashesAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleMainClassAttribute;
import org.gjt.jclasslib.structures.attributes.ModulePackagesAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleResolutionAttribute;
import org.gjt.jclasslib.structures.attributes.ModuleTargetAttribute;
import org.gjt.jclasslib.structures.attributes.NestHostAttribute;
import org.gjt.jclasslib.structures.attributes.NestMembersAttribute;
import org.gjt.jclasslib.structures.attributes.PermittedSubclassesAttribute;
import org.gjt.jclasslib.structures.attributes.RecordAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleParameterAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeInvisibleTypeAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleParameterAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.RuntimeVisibleTypeAnnotationsAttribute;
import org.gjt.jclasslib.structures.attributes.SignatureAttribute;
import org.gjt.jclasslib.structures.attributes.SourceDebugExtensionAttribute;
import org.gjt.jclasslib.structures.attributes.SourceFileAttribute;
import org.gjt.jclasslib.structures.attributes.StackMapTableAttribute;
import org.gjt.jclasslib.structures.attributes.SyntheticAttribute;
import org.gjt.jclasslib.structures.attributes.UnknownAttribute;
import org.gjt.jclasslib.structures.constants.ConstantUtf8Info;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J'\u0010\t\u001a\u0004\u0018\u0001H\n\"\b\b\u0000\u0010\n*\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\n0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001c\u0010\u0012\u001a\u00020\u0013*\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010\u001c\u001a\u00020\u0013*\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f\u00c0\u0006\u0003"}, d2={"Lorg/gjt/jclasslib/structures/AttributeContainer;", "", "attributes", "", "Lorg/gjt/jclasslib/structures/AttributeInfo;", "getAttributes", "()[Lorg/gjt/jclasslib/structures/AttributeInfo;", "setAttributes", "([Lorg/gjt/jclasslib/structures/AttributeInfo;)V", "findAttribute", "T", "attributeClass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)Lorg/gjt/jclasslib/structures/AttributeInfo;", "totalAttributesLength", "", "getTotalAttributesLength", "()I", "readAttributes", "", "input", "Lorg/gjt/jclasslib/io/DataInput;", "classFile", "Lorg/gjt/jclasslib/structures/ClassFile;", "create", "attributeLength", "attributeName", "", "writeAttributes", "output", "Lorg/gjt/jclasslib/io/DataOutput;", "data"})
@SourceDebugExtension(value={"SMAP\nAttributeContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AttributeContainer.kt\norg/gjt/jclasslib/structures/AttributeContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,124:1\n1#2:125\n13805#3,2:126\n*S KotlinDebug\n*F\n+ 1 AttributeContainer.kt\norg/gjt/jclasslib/structures/AttributeContainer\n*L\n115#1:126,2\n*E\n"})
public interface AttributeContainer {
    @NotNull
    public AttributeInfo[] getAttributes();

    public void setAttributes(@NotNull AttributeInfo[] var1);

    @Nullable
    default public <T extends AttributeInfo> T findAttribute(@NotNull KClass<T> attributeClass) {
        AttributeInfo attributeInfo;
        block2: {
            Intrinsics.checkNotNullParameter(attributeClass, (String)"attributeClass");
            for (AttributeInfo it : this.getAttributes()) {
                boolean bl = false;
                attributeInfo = (AttributeInfo)KClasses.safeCast(attributeClass, (Object)it);
                if (attributeInfo == null) {
                    continue;
                }
                break block2;
            }
            attributeInfo = null;
        }
        return (T)attributeInfo;
    }

    /*
     * WARNING - void declaration
     */
    default public int getTotalAttributesLength() {
        int n;
        AttributeInfo[] attributeInfoArray = this.getAttributes();
        int n2 = 6 * this.getAttributes().length;
        int n3 = 0;
        int n4 = attributeInfoArray.length;
        for (int i = 0; i < n4; ++i) {
            void it;
            AttributeInfo attributeInfo;
            AttributeInfo attributeInfo2 = attributeInfo = attributeInfoArray[i];
            n = n3;
            boolean bl = false;
            int n5 = it.getAttributeLength();
            n3 = n + n5;
        }
        n = n3;
        return n2 + n;
    }

    /*
     * WARNING - void declaration
     */
    default public void readAttributes(@NotNull AttributeContainer $this$readAttributes, @NotNull DataInput input, @NotNull ClassFile classFile) {
        Intrinsics.checkNotNullParameter((Object)$this$readAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        int attributesCount = input.readUnsignedShort();
        if (Intrinsics.areEqual((Object)Expect_jvmKt.getSystemProperty("jclasslib.io.skipAttributes"), (Object)"true")) {
            int n = 0;
            AttributeInfo[] attributeInfoArray = new AttributeInfo[attributesCount];
            AttributeContainer attributeContainer = $this$readAttributes;
            while (n < attributesCount) {
                int n2 = n++;
                input.skip(2);
                int attributeLength = input.readInt();
                input.skip(attributeLength);
                attributeInfoArray[n2] = new UnknownAttribute(attributeLength, classFile);
            }
            attributeContainer.setAttributes(attributeInfoArray);
        } else {
            AttributeInfo[] attributeInfoArray = new AttributeInfo[attributesCount];
            AttributeContainer attributeContainer = $this$readAttributes;
            for (int i = 0; i < attributesCount; ++i) {
                void $this$readAttributes_u24lambda_u240;
                AttributeInfo attributeInfo;
                int n = i;
                int attributeNameIndex = input.readUnsignedShort();
                int attributeLength = input.readInt();
                ConstantUtf8Info cpInfoName = classFile.getConstantPoolUtf8Entry(attributeNameIndex);
                AttributeInfo attributeInfo2 = attributeInfo = $this$readAttributes.create(attributeLength, cpInfoName.getString(), input, classFile);
                int n3 = n;
                AttributeInfo[] attributeInfoArray2 = attributeInfoArray;
                boolean bl = false;
                $this$readAttributes_u24lambda_u240.setAttributeNameIndex(attributeNameIndex);
                if (!($this$readAttributes_u24lambda_u240 instanceof AnnotationDefaultAttribute)) {
                    $this$readAttributes_u24lambda_u240.read(input);
                }
                Unit unit = Unit.INSTANCE;
                attributeInfoArray2[n3] = attributeInfo;
            }
            attributeContainer.setAttributes(attributeInfoArray);
            if (Package.isDebug()) {
                Package.debug("read " + attributesCount + " attributes", input);
            }
        }
    }

    private AttributeInfo create(int attributeLength, String attributeName, DataInput input, ClassFile classFile) {
        AttributeInfo attributeInfo;
        switch (attributeName) {
            case "ConstantValue": {
                attributeInfo = new ConstantValueAttribute(classFile);
                break;
            }
            case "Code": {
                attributeInfo = new CodeAttribute(classFile);
                break;
            }
            case "Exceptions": {
                attributeInfo = new ExceptionsAttribute(classFile);
                break;
            }
            case "InnerClasses": {
                attributeInfo = new InnerClassesAttribute(classFile);
                break;
            }
            case "SourceDebugExtension": {
                attributeInfo = new SourceDebugExtensionAttribute(attributeLength, classFile);
                break;
            }
            case "Synthetic": {
                attributeInfo = new SyntheticAttribute(classFile);
                break;
            }
            case "SourceFile": {
                attributeInfo = new SourceFileAttribute(classFile);
                break;
            }
            case "LineNumberTable": {
                attributeInfo = new LineNumberTableAttribute(classFile);
                break;
            }
            case "LocalVariableTable": {
                attributeInfo = new LocalVariableTableAttribute(classFile);
                break;
            }
            case "Deprecated": {
                attributeInfo = new DeprecatedAttribute(classFile);
                break;
            }
            case "EnclosingMethod": {
                attributeInfo = new EnclosingMethodAttribute(classFile);
                break;
            }
            case "Signature": {
                attributeInfo = new SignatureAttribute(classFile);
                break;
            }
            case "LocalVariableTypeTable": {
                attributeInfo = new LocalVariableTypeTableAttribute(classFile);
                break;
            }
            case "RuntimeVisibleAnnotations": {
                attributeInfo = new RuntimeVisibleAnnotationsAttribute(classFile);
                break;
            }
            case "RuntimeInvisibleAnnotations": {
                attributeInfo = new RuntimeInvisibleAnnotationsAttribute(classFile);
                break;
            }
            case "RuntimeVisibleParameterAnnotations": {
                attributeInfo = new RuntimeVisibleParameterAnnotationsAttribute(classFile);
                break;
            }
            case "RuntimeInvisibleParameterAnnotations": {
                attributeInfo = new RuntimeInvisibleParameterAnnotationsAttribute(classFile);
                break;
            }
            case "RuntimeVisibleTypeAnnotations": {
                attributeInfo = new RuntimeVisibleTypeAnnotationsAttribute(classFile);
                break;
            }
            case "RuntimeInvisibleTypeAnnotations": {
                attributeInfo = new RuntimeInvisibleTypeAnnotationsAttribute(classFile);
                break;
            }
            case "AnnotationDefault": {
                attributeInfo = new AnnotationDefaultAttribute(classFile, input);
                break;
            }
            case "BootstrapMethods": {
                attributeInfo = new BootstrapMethodsAttribute(classFile);
                break;
            }
            case "StackMapTable": {
                attributeInfo = new StackMapTableAttribute(classFile);
                break;
            }
            case "MethodParameters": {
                attributeInfo = new MethodParametersAttribute(classFile);
                break;
            }
            case "Module": {
                attributeInfo = new ModuleAttribute(classFile);
                break;
            }
            case "ModulePackages": {
                attributeInfo = new ModulePackagesAttribute(classFile);
                break;
            }
            case "ModuleMainClass": {
                attributeInfo = new ModuleMainClassAttribute(classFile);
                break;
            }
            case "ModuleTarget": {
                attributeInfo = new ModuleTargetAttribute(classFile);
                break;
            }
            case "ModuleHashes": {
                attributeInfo = new ModuleHashesAttribute(classFile);
                break;
            }
            case "ModuleResolution": {
                attributeInfo = new ModuleResolutionAttribute(classFile);
                break;
            }
            case "NestHost": {
                attributeInfo = new NestHostAttribute(classFile);
                break;
            }
            case "NestMembers": {
                attributeInfo = new NestMembersAttribute(classFile);
                break;
            }
            case "Record": {
                attributeInfo = new RecordAttribute(classFile);
                break;
            }
            case "PermittedSubclasses": {
                attributeInfo = new PermittedSubclassesAttribute(classFile);
                break;
            }
            default: {
                attributeInfo = new UnknownAttribute(attributeLength, classFile);
            }
        }
        return attributeInfo;
    }

    default public void writeAttributes(@NotNull AttributeContainer $this$writeAttributes, @NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)$this$writeAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        int attributesCount = $this$writeAttributes.getAttributes().length;
        output.writeShort(attributesCount);
        AttributeInfo[] $this$forEach$iv = $this$writeAttributes.getAttributes();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            AttributeInfo element$iv;
            AttributeInfo it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            output.writeShort(it.getAttributeNameIndex());
            output.writeInt(it.getAttributeLength());
            it.write(output);
        }
        if (Package.isDebug()) {
            Package.debug("wrote " + attributesCount + " attributes", output);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @Nullable
        public static <T extends AttributeInfo> T findAttribute(@NotNull AttributeContainer $this, @NotNull KClass<T> attributeClass) {
            Intrinsics.checkNotNullParameter(attributeClass, (String)"attributeClass");
            return (T)$this.findAttribute(attributeClass);
        }

        @Deprecated
        public static int getTotalAttributesLength(@NotNull AttributeContainer $this) {
            return $this.getTotalAttributesLength();
        }

        @Deprecated
        public static void readAttributes(@NotNull AttributeContainer $this, @NotNull AttributeContainer $receiver, @NotNull DataInput input, @NotNull ClassFile classFile) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
            $this.readAttributes($receiver, input, classFile);
        }

        @Deprecated
        public static void writeAttributes(@NotNull AttributeContainer $this, @NotNull AttributeContainer $receiver, @NotNull DataOutput output) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            $this.writeAttributes($receiver, output);
        }
    }
}

