/*
 * Decompiled with CFR 0.152.
 */
package net.jafama;

import net.jafama.NumbersUtils;

abstract class CmnFastMath {
    static final boolean FM_USE_JDK_MATH = CmnFastMath.getBooleanProperty("jafama.usejdk", false);
    static final boolean FM_USE_REDEFINED_LOG = CmnFastMath.getBooleanProperty("jafama.fastlog", false);
    static final boolean FM_USE_REDEFINED_SQRT = CmnFastMath.getBooleanProperty("jafama.fastsqrt", false);
    static final boolean SFM_USE_JDK_MATH = CmnFastMath.getBooleanProperty("jafama.strict.usejdk", false);
    static final boolean SFM_USE_REDEFINED_LOG = CmnFastMath.getBooleanProperty("jafama.strict.fastlog", true);
    static final boolean SFM_USE_REDEFINED_SQRT = CmnFastMath.getBooleanProperty("jafama.strict.fastsqrt", false);
    public static final double PI_SUP = Double.longBitsToDouble(Double.doubleToRawLongBits(Math.PI) + 1L);
    static final float TWO_POW_23_F = (float)NumbersUtils.twoPow(23);
    static final double TWO_POW_24 = NumbersUtils.twoPow(24);
    private static final double TWO_POW_N24 = NumbersUtils.twoPow(-24);
    static final double TWO_POW_26 = NumbersUtils.twoPow(26);
    static final double TWO_POW_N26 = NumbersUtils.twoPow(-26);
    static final double TWO_POW_27 = NumbersUtils.twoPow(27);
    static final double TWO_POW_N27 = NumbersUtils.twoPow(-27);
    static final double TWO_POW_N28 = NumbersUtils.twoPow(-28);
    static final double TWO_POW_52 = NumbersUtils.twoPow(52);
    static final double TWO_POW_N55 = NumbersUtils.twoPow(-55);
    static final double TWO_POW_66 = NumbersUtils.twoPow(66);
    static final double TWO_POW_512 = NumbersUtils.twoPow(512);
    static final double TWO_POW_N512 = NumbersUtils.twoPow(-512);
    static final double DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
    private static final double SQRT_2 = StrictMath.sqrt(2.0);
    static final double LOG_2 = StrictMath.log(2.0);
    static final double LOG_TWO_POW_27 = StrictMath.log(TWO_POW_27);
    static final double LOG_DOUBLE_MAX_VALUE = StrictMath.log(Double.MAX_VALUE);
    static final double INV_LOG_10 = 1.0 / StrictMath.log(10.0);
    static final double DOUBLE_BEFORE_60 = Double.longBitsToDouble(Double.doubleToRawLongBits(60.0) - 1L);
    private static final double[] TWO_OVER_PI_TAB = new double[]{1.0680707E7, 7228996.0, 1387004.0, 2578385.0, 1.6069853E7, 1.2639074E7, 9804092.0, 4427841.0, 1.6666979E7, 1.1263675E7, 1.2935607E7, 2387514.0, 4345298.0, 1.4681673E7, 3074569.0, 1.3734428E7, 1.6653803E7, 1880361.0, 1.0960616E7, 8533493.0, 3062596.0, 8710556.0, 7349940.0, 6258241.0, 3772886.0, 3769171.0, 3798172.0, 8675211.0, 1.2450088E7, 3874808.0, 9961438.0, 366607.0, 1.5675153E7, 9132554.0, 7151469.0, 3571407.0, 2607881.0, 1.2013382E7, 4155038.0, 6285869.0, 7677882.0, 1.3102053E7, 1.5825725E7, 473591.0, 9065106.0, 1.5363067E7, 6271263.0, 9264392.0, 5636912.0, 4652155.0, 7056368.0, 1.3614112E7, 1.0155062E7, 1944035.0, 9527646.0, 1.50802E7, 6658437.0, 6231200.0, 6832269.0, 1.6767104E7, 5075751.0, 3212806.0, 1398474.0, 7579849.0, 6349435.0, 1.2618859E7};
    private static final double PIO2_TAB0 = Double.longBitsToDouble(4609753056584663040L);
    private static final double PIO2_TAB1 = Double.longBitsToDouble(4500296887714185216L);
    private static final double PIO2_TAB2 = Double.longBitsToDouble(4393339057296375808L);
    private static final double PIO2_TAB3 = Double.longBitsToDouble(4285399695318056960L);
    private static final double PIO2_TAB4 = Double.longBitsToDouble(4174867106174599168L);
    private static final double PIO2_TAB5 = Double.longBitsToDouble(4069606033725587456L);
    static final double PIO2_INV = Double.longBitsToDouble(4603909380684499075L);
    static final double PIO2_HI = Double.longBitsToDouble(4609753056924401664L);
    static final double PIO2_LO = Double.longBitsToDouble(4454258360616903473L);
    static final double PI_INV = PIO2_INV / 2.0;
    static final double PI_HI = 2.0 * PIO2_HI;
    static final double PI_LO = 2.0 * PIO2_LO;
    static final double TWOPI_INV = PIO2_INV / 4.0;
    static final double TWOPI_HI = 4.0 * PIO2_HI;
    static final double TWOPI_LO = 4.0 * PIO2_LO;
    static final double NORMALIZE_ANGLE_MAX_MEDIUM_DOUBLE_PIO2 = StrictMath.pow(2.0, 19.0) * 1.5707963267948966;
    static final int SIN_COS_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(11)) + 1;
    static final double SIN_COS_DELTA_HI = TWOPI_HI / (double)(SIN_COS_TABS_SIZE - 1);
    static final double SIN_COS_DELTA_LO = TWOPI_LO / (double)(SIN_COS_TABS_SIZE - 1);
    static final double SIN_COS_INDEXER = 1.0 / (SIN_COS_DELTA_HI + SIN_COS_DELTA_LO);
    static final double SIN_COS_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / SIN_COS_INDEXER * 0.99;
    static final int TAN_VIRTUAL_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(12)) + 1;
    static final double TAN_MAX_VALUE_FOR_TABS = StrictMath.toRadians(77.0);
    static final int TAN_TABS_SIZE = (int)(TAN_MAX_VALUE_FOR_TABS / 1.5707963267948966 * (double)(TAN_VIRTUAL_TABS_SIZE - 1)) + 1;
    static final double TAN_DELTA_HI = PIO2_HI / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
    static final double TAN_DELTA_LO = PIO2_LO / (double)(TAN_VIRTUAL_TABS_SIZE - 1);
    static final double TAN_INDEXER = 1.0 / (TAN_DELTA_HI + TAN_DELTA_LO);
    static final double TAN_MAX_VALUE_FOR_INT_MODULO = 4194303.0 / TAN_INDEXER * 0.99;
    static final double ASIN_MAX_VALUE_FOR_TABS = StrictMath.sin(StrictMath.toRadians(73.0));
    static final int ASIN_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(13)) + 1;
    static final double ASIN_DELTA = ASIN_MAX_VALUE_FOR_TABS / (double)(ASIN_TABS_SIZE - 1);
    static final double ASIN_INDEXER = 1.0 / ASIN_DELTA;
    static final double ASIN_MAX_VALUE_FOR_POWTABS = StrictMath.sin(StrictMath.toRadians(88.6));
    static final double ASIN_POWTABS_ONE_DIV_MAX_VALUE = 1.0 / ASIN_MAX_VALUE_FOR_POWTABS;
    static final int ASIN_POWTABS_SIZE = 0;
    static final int ASIN_POWTABS_SIZE_MINUS_ONE = ASIN_POWTABS_SIZE - 1;
    static final double ASIN_PIO2_HI = Double.longBitsToDouble(4609753056924675352L);
    static final double ASIN_PIO2_LO = Double.longBitsToDouble(4364452196894661639L);
    static final double ASIN_PS0 = Double.longBitsToDouble(4595172819793696085L);
    static final double ASIN_PS1 = Double.longBitsToDouble(-4623835544539140227L);
    static final double ASIN_PS2 = Double.longBitsToDouble(4596417465768494165L);
    static final double ASIN_PS3 = Double.longBitsToDouble(-4637438604930937029L);
    static final double ASIN_PS4 = Double.longBitsToDouble(4560439845004096136L);
    static final double ASIN_PS5 = Double.longBitsToDouble(4540259411154564873L);
    static final double ASIN_QS1 = Double.longBitsToDouble(-4610777653840302773L);
    static final double ASIN_QS2 = Double.longBitsToDouble(4611733184086379208L);
    static final double ASIN_QS3 = Double.longBitsToDouble(-4618997306433404583L);
    static final double ASIN_QS4 = Double.longBitsToDouble(4590215604441354882L);
    static final double ATAN_MAX_VALUE_FOR_TABS = StrictMath.tan(StrictMath.toRadians(74.0));
    static final int ATAN_TABS_SIZE = (1 << CmnFastMath.getTabSizePower(12)) + 1;
    static final double ATAN_DELTA = ATAN_MAX_VALUE_FOR_TABS / (double)(ATAN_TABS_SIZE - 1);
    static final double ATAN_INDEXER = 1.0 / ATAN_DELTA;
    static final double ATAN_HI3 = Double.longBitsToDouble(4609753056924675352L);
    static final double ATAN_LO3 = Double.longBitsToDouble(4364452196894661639L);
    static final double ATAN_AT0 = Double.longBitsToDouble(4599676419421066509L);
    static final double ATAN_AT1 = Double.longBitsToDouble(-4626998257160492092L);
    static final double ATAN_AT2 = Double.longBitsToDouble(4594314991288484863L);
    static final double ATAN_AT3 = Double.longBitsToDouble(-4630701217362536847L);
    static final double ATAN_AT4 = Double.longBitsToDouble(4591215095208222830L);
    static final double ATAN_AT5 = Double.longBitsToDouble(-4633165035261879699L);
    static final double ATAN_AT6 = Double.longBitsToDouble(4589464229703073105L);
    static final double ATAN_AT7 = Double.longBitsToDouble(-4634804155249132134L);
    static final double ATAN_AT8 = Double.longBitsToDouble(4587333258118041067L);
    static final double ATAN_AT9 = Double.longBitsToDouble(-4637946461342241745L);
    static final double ATAN_AT10 = Double.longBitsToDouble(4580351289466214929L);
    static final double EXP_OVERFLOW_LIMIT = Double.longBitsToDouble(4649454530587146735L);
    static final double EXP_UNDERFLOW_LIMIT = Double.longBitsToDouble(-4573606559926636463L);
    static final int EXP_LO_TAB_SIZE_POT = CmnFastMath.getTabSizePower(11);
    static final int EXP_LO_TAB_SIZE = (1 << EXP_LO_TAB_SIZE_POT) + 1;
    static final int EXP_LO_TAB_MID_INDEX = (EXP_LO_TAB_SIZE - 1) / 2;
    static final int EXP_LO_INDEXING = EXP_LO_TAB_MID_INDEX / 1;
    static final int EXP_LO_INDEXING_DIV_SHIFT = EXP_LO_TAB_SIZE_POT - 1 - 0;
    static final int LOG_BITS = CmnFastMath.getTabSizePower(12);
    static final int LOG_TAB_SIZE = 1 << LOG_BITS;
    static final int SQRT_LO_BITS = CmnFastMath.getTabSizePower(12);
    static final int SQRT_LO_TAB_SIZE = 1 << SQRT_LO_BITS;
    static final int CBRT_LO_BITS = CmnFastMath.getTabSizePower(12);
    static final int CBRT_LO_TAB_SIZE = 1 << CBRT_LO_BITS;
    static final double HYPOT_MAX_MAG = NumbersUtils.twoPow(511);
    static final double HYPOT_FACTOR = NumbersUtils.twoPow(750);

    static double twoPowNormal(int power) {
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    static double twoPowNormalOrSubnormal(int power) {
        if (power <= -1023) {
            return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    static long encodeRemainderAndQuadrant(double remainder, int quadrant) {
        long bits = Double.doubleToRawLongBits(remainder);
        return bits & 0xCFFFFFFFFFFFFFFFL | (long)quadrant << 60;
    }

    static double decodeRemainder(long bits) {
        return Double.longBitsToDouble(bits & 0xCFFFFFFFFFFFFFFFL | 0x3000000000000000L);
    }

    static int decodeQuadrant(long bits) {
        return (int)(bits >> 60) & 3;
    }

    static strictfp long jdkRemainderPiO2(double angle, boolean negateRem) {
        double cosForAtan2;
        double sinForAtan2;
        int q;
        double sin = StrictMath.sin(angle);
        double cos = StrictMath.cos(angle);
        if (cos >= SQRT_2 / 2.0) {
            q = 0;
            sinForAtan2 = sin;
            cosForAtan2 = cos;
        } else if (cos <= -(SQRT_2 / 2.0)) {
            q = 2;
            sinForAtan2 = -sin;
            cosForAtan2 = -cos;
        } else if (sin > 0.0) {
            q = 1;
            sinForAtan2 = -cos;
            cosForAtan2 = sin;
        } else {
            q = 3;
            sinForAtan2 = cos;
            cosForAtan2 = -sin;
        }
        double fw = StrictMath.atan2(sinForAtan2, cosForAtan2);
        return CmnFastMath.encodeRemainderAndQuadrant(negateRem ? -fw : fw, q);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static strictfp long heavyRemainderPiO2(double angle, boolean negateRem) {
        double q5;
        boolean carry;
        int i;
        double q4;
        double q3;
        double q2;
        double q1;
        double q0;
        double f5;
        double f6;
        long lx = Double.doubleToRawLongBits(angle);
        long exp = (lx >> 52 & 0x7FFL) - 1046L;
        double z = Double.longBitsToDouble(lx - (exp << 52));
        double x0 = (int)z;
        z = (z - x0) * TWO_POW_24;
        double x1 = (int)z;
        z = (z - x1) * TWO_POW_24;
        double x2 = (int)z;
        int e0 = (int)exp;
        int nx = x2 == 0.0 ? (x1 == 0.0 ? 1 : 2) : 3;
        int jk = 4;
        int jx = nx - 1;
        int jv = Math.max(0, (e0 - 3) / 24);
        int qZero = e0 - 24 * (jv + 1);
        int j = jv - jx;
        if (jx == 0) {
            f6 = 0.0;
            f5 = 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f0;
            q1 = x0 * f1;
            q2 = x0 * f2;
            q3 = x0 * f3;
            q4 = x0 * f4;
        } else if (jx == 1) {
            f6 = 0.0;
            f5 = j >= -5 ? TWO_OVER_PI_TAB[j + 5] : 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f1 + x1 * f0;
            q1 = x0 * f2 + x1 * f1;
            q2 = x0 * f3 + x1 * f2;
            q3 = x0 * f4 + x1 * f3;
            q4 = x0 * f5 + x1 * f4;
        } else {
            f6 = j >= -6 ? TWO_OVER_PI_TAB[j + 6] : 0.0;
            f5 = j >= -5 ? TWO_OVER_PI_TAB[j + 5] : 0.0;
            double f4 = j >= -4 ? TWO_OVER_PI_TAB[j + 4] : 0.0;
            double f3 = j >= -3 ? TWO_OVER_PI_TAB[j + 3] : 0.0;
            double f2 = j >= -2 ? TWO_OVER_PI_TAB[j + 2] : 0.0;
            double f1 = j >= -1 ? TWO_OVER_PI_TAB[j + 1] : 0.0;
            double f0 = j >= 0 ? TWO_OVER_PI_TAB[j] : 0.0;
            q0 = x0 * f2 + x1 * f1 + x2 * f0;
            q1 = x0 * f3 + x1 * f2 + x2 * f1;
            q2 = x0 * f4 + x1 * f3 + x2 * f2;
            q3 = x0 * f5 + x1 * f4 + x2 * f3;
            q4 = x0 * f6 + x1 * f5 + x2 * f4;
        }
        double twoPowQZero = CmnFastMath.twoPowNormal(qZero);
        int jz = jk;
        z = q4;
        double fw = (int)(TWO_POW_N24 * z);
        int iq0 = (int)(z - TWO_POW_24 * fw);
        z = q3 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq1 = (int)(z - TWO_POW_24 * fw);
        z = q2 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq2 = (int)(z - TWO_POW_24 * fw);
        z = q1 + fw;
        fw = (int)(TWO_POW_N24 * z);
        int iq3 = (int)(z - TWO_POW_24 * fw);
        z = q0 + fw;
        int iq4 = 0;
        int iq5 = 0;
        z = z * twoPowQZero % 8.0;
        int n = (int)z;
        z -= (double)n;
        int ih = 0;
        if (qZero > 0) {
            i = iq3 >> 24 - qZero;
            n += i;
            ih = (iq3 -= i << 24 - qZero) >> 23 - qZero;
        } else if (qZero == 0) {
            ih = iq3 >> 23;
        } else if (z >= 0.5) {
            ih = 2;
        }
        if (ih > 0) {
            ++n;
            carry = true;
            if (iq0 != 0) {
                iq0 = 0x1000000 - iq0;
                iq1 = 0xFFFFFF - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq1 != 0) {
                iq1 = 0x1000000 - iq1;
                iq2 = 0xFFFFFF - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq2 != 0) {
                iq2 = 0x1000000 - iq2;
                iq3 = 0xFFFFFF - iq3;
            } else if (iq3 != 0) {
                iq3 = 0x1000000 - iq3;
            } else {
                carry = false;
            }
            if (qZero > 0) {
                if (qZero == 1) {
                    iq3 &= 0x7FFFFF;
                } else if (qZero == 2) {
                    iq3 &= 0x3FFFFF;
                }
            }
            if (ih == 2) {
                z = 1.0 - z;
                if (carry) {
                    z -= twoPowQZero;
                }
            }
        }
        if (z == 0.0) {
            if (iq3 == 0) {
                return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
            }
            if (jx == 0) {
                f5 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f5;
            } else if (jx == 1) {
                f6 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f6 + x1 * f5;
            } else {
                double f7 = TWO_OVER_PI_TAB[jv + 5];
                q5 = x0 * f7 + x1 * f6 + x2 * f5;
            }
            ++jz;
            z = q5;
            fw = (int)(TWO_POW_N24 * z);
            iq0 = (int)(z - TWO_POW_24 * fw);
            z = q4 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq1 = (int)(z - TWO_POW_24 * fw);
            z = q3 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq2 = (int)(z - TWO_POW_24 * fw);
            z = q2 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq3 = (int)(z - TWO_POW_24 * fw);
            z = q1 + fw;
            fw = (int)(TWO_POW_N24 * z);
            iq4 = (int)(z - TWO_POW_24 * fw);
            z = q0 + fw;
            iq5 = 0;
            z = z * twoPowQZero % 8.0;
            n = (int)z;
            z -= (double)n;
            ih = 0;
            if (qZero > 0) {
                i = iq4 >> 24 - qZero;
                n += i;
                ih = (iq4 -= i << 24 - qZero) >> 23 - qZero;
            } else if (qZero == 0) {
                ih = iq4 >> 23;
            } else if (z >= 0.5) {
                ih = 2;
            }
            if (ih > 0) {
                ++n;
                carry = true;
                if (iq0 != 0) {
                    iq0 = 0x1000000 - iq0;
                    iq1 = 0xFFFFFF - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq1 != 0) {
                    iq1 = 0x1000000 - iq1;
                    iq2 = 0xFFFFFF - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq2 != 0) {
                    iq2 = 0x1000000 - iq2;
                    iq3 = 0xFFFFFF - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq3 != 0) {
                    iq3 = 0x1000000 - iq3;
                    iq4 = 0xFFFFFF - iq4;
                } else if (iq4 != 0) {
                    iq4 = 0x1000000 - iq4;
                } else {
                    carry = false;
                }
                if (qZero > 0) {
                    if (qZero == 1) {
                        iq4 &= 0x7FFFFF;
                    } else if (qZero == 2) {
                        iq4 &= 0x3FFFFF;
                    }
                }
                if (ih == 2) {
                    z = 1.0 - z;
                    if (carry) {
                        z -= twoPowQZero;
                    }
                }
            }
            if (z == 0.0) {
                if (iq4 == 0) {
                    return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
                }
                --jz;
                twoPowQZero *= TWO_POW_N24;
            }
        }
        if (z != 0.0) {
            if ((z /= twoPowQZero) >= TWO_POW_24) {
                fw = (int)(TWO_POW_N24 * z);
                if (jz != jk) return CmnFastMath.jdkRemainderPiO2(angle, negateRem);
                iq4 = (int)(z - TWO_POW_24 * fw);
                ++jz;
                twoPowQZero *= TWO_POW_24;
                iq5 = (int)fw;
            } else if (jz == jk) {
                iq4 = (int)z;
            } else {
                iq5 = (int)z;
            }
        }
        fw = twoPowQZero;
        if (jz == 5) {
            q5 = fw * (double)iq5;
            fw *= TWO_POW_N24;
        } else {
            q5 = 0.0;
        }
        q4 = fw * (double)iq4;
        q3 = (fw *= TWO_POW_N24) * (double)iq3;
        q2 = (fw *= TWO_POW_N24) * (double)iq2;
        q1 = (fw *= TWO_POW_N24) * (double)iq1;
        q0 = (fw *= TWO_POW_N24) * (double)iq0;
        fw = PIO2_TAB0 * q5;
        fw += PIO2_TAB0 * q4 + PIO2_TAB1 * q5;
        fw += PIO2_TAB0 * q3 + PIO2_TAB1 * q4 + PIO2_TAB2 * q5;
        fw += PIO2_TAB0 * q2 + PIO2_TAB1 * q3 + PIO2_TAB2 * q4 + PIO2_TAB3 * q5;
        fw += PIO2_TAB0 * q1 + PIO2_TAB1 * q2 + PIO2_TAB2 * q3 + PIO2_TAB3 * q4 + PIO2_TAB4 * q5;
        if (!(ih != 0 ^ negateRem)) return CmnFastMath.encodeRemainderAndQuadrant(fw += PIO2_TAB0 * q0 + PIO2_TAB1 * q1 + PIO2_TAB2 * q2 + PIO2_TAB3 * q3 + PIO2_TAB4 * q4 + PIO2_TAB5 * q5, n & 3);
        fw = -fw;
        return CmnFastMath.encodeRemainderAndQuadrant(fw += PIO2_TAB0 * q0 + PIO2_TAB1 * q1 + PIO2_TAB2 * q2 + PIO2_TAB3 * q3 + PIO2_TAB4 * q4 + PIO2_TAB5 * q5, n & 3);
    }

    private static boolean getBooleanProperty(String key, boolean defaultValue) {
        String tmp = System.getProperty(key);
        if (tmp != null) {
            return Boolean.parseBoolean(tmp);
        }
        return defaultValue;
    }

    private static int getTabSizePower(int tabSizePower) {
        return FM_USE_JDK_MATH && SFM_USE_JDK_MATH ? Math.min(2, tabSizePower) : tabSizePower;
    }

    static final class MyTSqrt {
        static final double[] sqrtXSqrtHiTab = new double[2098];
        static final double[] sqrtXSqrtLoTab = new double[SQRT_LO_TAB_SIZE];
        static final double[] sqrtSlopeHiTab = new double[2098];
        static final double[] sqrtSlopeLoTab = new double[SQRT_LO_TAB_SIZE];

        private static strictfp void init() {
            for (int i = -1074; i <= 1023; ++i) {
                double twoPowExpDiv2 = StrictMath.pow(2.0, (double)i * 0.5);
                MyTSqrt.sqrtXSqrtHiTab[i - -1074] = twoPowExpDiv2 * 0.5;
                MyTSqrt.sqrtSlopeHiTab[i - -1074] = 1.0 / twoPowExpDiv2;
            }
            MyTSqrt.sqrtXSqrtLoTab[0] = 1.0;
            MyTSqrt.sqrtSlopeLoTab[0] = 1.0;
            long SQRT_LO_MASK = 0x3FF0000000000000L | 0xFFFFFFFFFFFFFL >> SQRT_LO_BITS;
            for (int i = 1; i < SQRT_LO_TAB_SIZE; ++i) {
                double sqrtX;
                long xBits = SQRT_LO_MASK | (long)(i - 1) << 52 - SQRT_LO_BITS;
                MyTSqrt.sqrtXSqrtLoTab[i] = sqrtX = StrictMath.sqrt(Double.longBitsToDouble(xBits));
                MyTSqrt.sqrtSlopeLoTab[i] = 1.0 / sqrtX;
            }
        }

        static {
            MyTSqrt.init();
        }
    }

    static final class MyTLog {
        static final double[] logXLogTab = new double[LOG_TAB_SIZE];
        static final double[] logXTab = new double[LOG_TAB_SIZE];
        static final double[] logXInvTab = new double[LOG_TAB_SIZE];

        private static strictfp void init() {
            for (int i = 0; i < LOG_TAB_SIZE; ++i) {
                double x = 1.0 + (double)i * (1.0 / (double)LOG_TAB_SIZE);
                MyTLog.logXLogTab[i] = StrictMath.log(x);
                MyTLog.logXTab[i] = x;
                MyTLog.logXInvTab[i] = 1.0 / x;
            }
        }

        static {
            MyTLog.init();
        }
    }

    static final class MyTExp {
        static final double[] expHiTab = new double[1 + (int)EXP_OVERFLOW_LIMIT - (int)EXP_UNDERFLOW_LIMIT];
        static final double[] expLoPosTab = new double[EXP_LO_TAB_SIZE];
        static final double[] expLoNegTab = new double[EXP_LO_TAB_SIZE];

        private static strictfp void init() {
            int i;
            for (i = (int)EXP_UNDERFLOW_LIMIT; i <= (int)EXP_OVERFLOW_LIMIT; ++i) {
                MyTExp.expHiTab[i - (int)CmnFastMath.EXP_UNDERFLOW_LIMIT] = StrictMath.exp(i);
            }
            for (i = 0; i < EXP_LO_TAB_SIZE; ++i) {
                double x = -1.0 + (double)i / (double)EXP_LO_INDEXING;
                MyTExp.expLoPosTab[i] = StrictMath.exp(x);
                MyTExp.expLoNegTab[i] = -StrictMath.expm1(-x);
            }
        }

        static {
            MyTExp.init();
        }
    }

    static final class MyTSinCos {
        static final double[] sinTab = new double[SIN_COS_TABS_SIZE];
        static final double[] cosTab = new double[SIN_COS_TABS_SIZE];

        private static strictfp void init() {
            int SIN_COS_PI_INDEX = (SIN_COS_TABS_SIZE - 1) / 2;
            int SIN_COS_PI_MUL_2_INDEX = 2 * SIN_COS_PI_INDEX;
            int SIN_COS_PI_MUL_0_5_INDEX = SIN_COS_PI_INDEX / 2;
            int SIN_COS_PI_MUL_1_5_INDEX = 3 * SIN_COS_PI_INDEX / 2;
            for (int i = 0; i < SIN_COS_TABS_SIZE; ++i) {
                double angle = (double)i * SIN_COS_DELTA_HI + (double)i * SIN_COS_DELTA_LO;
                double sinAngle = StrictMath.sin(angle);
                double cosAngle = StrictMath.cos(angle);
                if (i == SIN_COS_PI_INDEX) {
                    sinAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_2_INDEX) {
                    sinAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_0_5_INDEX) {
                    cosAngle = 0.0;
                } else if (i == SIN_COS_PI_MUL_1_5_INDEX) {
                    cosAngle = 0.0;
                }
                MyTSinCos.sinTab[i] = sinAngle;
                MyTSinCos.cosTab[i] = cosAngle;
            }
        }

        static {
            MyTSinCos.init();
        }
    }
}

