/*
 * Decompiled with CFR 0.152.
 */
package jinjava.org.jsoup.select;

import java.util.ArrayList;
import java.util.List;
import jinjava.org.jsoup.internal.StringUtil;
import jinjava.org.jsoup.nodes.Element;
import jinjava.org.jsoup.select.NodeTraversor;
import jinjava.org.jsoup.select.NodeVisitor;

public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    public Elements(int initialCapacity) {
        super(initialCapacity);
    }

    public Elements(List<Element> elements) {
        super(elements);
    }

    @Override
    public Elements clone() {
        Elements clone = new Elements(this.size());
        for (Element e : this) {
            clone.add(e.clone());
        }
        return clone;
    }

    public String html() {
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Element element : this) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element.html());
        }
        return StringUtil.releaseBuilder(sb);
    }

    public String outerHtml() {
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Element element : this) {
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(element.outerHtml());
        }
        return StringUtil.releaseBuilder(sb);
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements remove() {
        for (Element element : this) {
            element.remove();
        }
        return this;
    }

    public Elements traverse(NodeVisitor nodeVisitor) {
        NodeTraversor.traverse(nodeVisitor, this);
        return this;
    }
}

