/*
 * Decompiled with CFR 0.152.
 */
package jinjava.org.jsoup.safety;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jinjava.org.jsoup.helper.Validate;
import jinjava.org.jsoup.internal.Normalizer;
import jinjava.org.jsoup.nodes.Attribute;
import jinjava.org.jsoup.nodes.Attributes;
import jinjava.org.jsoup.nodes.Element;

public class Safelist {
    private final Set<TagName> tagNames = new HashSet<TagName>();
    private final Map<TagName, Set<AttributeKey>> attributes = new HashMap<TagName, Set<AttributeKey>>();
    private final Map<TagName, Map<AttributeKey, AttributeValue>> enforcedAttributes = new HashMap<TagName, Map<AttributeKey, AttributeValue>>();
    private final Map<TagName, Map<AttributeKey, Set<Protocol>>> protocols = new HashMap<TagName, Map<AttributeKey, Set<Protocol>>>();
    private boolean preserveRelativeLinks = false;

    public static Safelist none() {
        return new Safelist();
    }

    protected boolean isSafeTag(String tag) {
        return this.tagNames.contains(TagName.valueOf(tag));
    }

    protected boolean isSafeAttribute(String tagName, Element el, Attribute attr) {
        String attrKey;
        Attributes expect;
        TagName tag = TagName.valueOf(tagName);
        AttributeKey key = AttributeKey.valueOf(attr.getKey());
        Set<AttributeKey> okSet = this.attributes.get(tag);
        if (okSet != null && okSet.contains(key)) {
            if (this.protocols.containsKey(tag)) {
                Map<AttributeKey, Set<Protocol>> attrProts = this.protocols.get(tag);
                return !attrProts.containsKey(key) || this.testValidProtocol(el, attr, attrProts.get(key));
            }
            return true;
        }
        Map<AttributeKey, AttributeValue> enforcedSet = this.enforcedAttributes.get(tag);
        if (enforcedSet != null && (expect = this.getEnforcedAttributes(tagName)).hasKeyIgnoreCase(attrKey = attr.getKey())) {
            return expect.getIgnoreCase(attrKey).equals(attr.getValue());
        }
        return !tagName.equals(":all") && this.isSafeAttribute(":all", el, attr);
    }

    private boolean testValidProtocol(Element el, Attribute attr, Set<Protocol> protocols) {
        String value = el.absUrl(attr.getKey());
        if (value.length() == 0) {
            value = attr.getValue();
        }
        if (!this.preserveRelativeLinks) {
            attr.setValue(value);
        }
        for (Protocol protocol : protocols) {
            String prot = protocol.toString();
            if (prot.equals("#")) {
                if (!this.isValidAnchor(value)) continue;
                return true;
            }
            prot = prot + ":";
            if (!Normalizer.lowerCase(value).startsWith(prot)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAnchor(String value) {
        return value.startsWith("#") && !value.matches(".*\\s.*");
    }

    Attributes getEnforcedAttributes(String tagName) {
        Attributes attrs = new Attributes();
        TagName tag = TagName.valueOf(tagName);
        if (this.enforcedAttributes.containsKey(tag)) {
            Map<AttributeKey, AttributeValue> keyVals = this.enforcedAttributes.get(tag);
            for (Map.Entry<AttributeKey, AttributeValue> entry : keyVals.entrySet()) {
                attrs.put(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        return attrs;
    }

    static class TagName
    extends TypedValue {
        TagName(String value) {
            super(value);
        }

        static TagName valueOf(String value) {
            return new TagName(value);
        }
    }

    static class AttributeKey
    extends TypedValue {
        AttributeKey(String value) {
            super(value);
        }

        static AttributeKey valueOf(String value) {
            return new AttributeKey(value);
        }
    }

    static class AttributeValue
    extends TypedValue {
    }

    static class Protocol
    extends TypedValue {
    }

    static abstract class TypedValue {
        private final String value;

        TypedValue(String value) {
            Validate.notNull(value);
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypedValue other = (TypedValue)obj;
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }

        public String toString() {
            return this.value;
        }
    }
}

