/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class StackMap
extends AttributeInfo {
    StackMap(ConstPool cp, byte[] newInfo) {
        super(cp, "StackMap", newInfo);
    }

    StackMap(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, in);
    }

    @Override
    public AttributeInfo copy(ConstPool newCp, Map<String, String> classnames) {
        Copier copier = new Copier(this, newCp, classnames);
        copier.visit();
        return copier.getStackMap();
    }

    void shiftPc(int where, int gapSize, boolean exclusive) throws BadBytecode {
        new Shifter(this, where, gapSize, exclusive).visit();
    }

    void shiftForSwitch(int where, int gapSize) throws BadBytecode {
        new SwitchShifter(this, where, gapSize).visit();
    }

    public static class Writer {
        private ByteArrayOutputStream output = new ByteArrayOutputStream();

        public StackMap toStackMap(ConstPool cp) {
            return new StackMap(cp, this.output.toByteArray());
        }

        public void writeVerifyTypeInfo(int tag, int data) {
            this.output.write(tag);
            if (tag == 7 || tag == 8) {
                this.write16bit(data);
            }
        }

        public void write16bit(int value) {
            this.output.write(value >>> 8 & 0xFF);
            this.output.write(value & 0xFF);
        }
    }

    static class SwitchShifter
    extends Walker {
        private int where;
        private int gap;

        public SwitchShifter(StackMap smt, int where, int gap) {
            super(smt);
            this.where = where;
            this.gap = gap;
        }

        @Override
        public int locals(int pos, int offset, int num) {
            if (this.where == pos + offset) {
                ByteArray.write16bit(offset - this.gap, this.info, pos - 4);
            } else if (this.where == pos) {
                ByteArray.write16bit(offset + this.gap, this.info, pos - 4);
            }
            return super.locals(pos, offset, num);
        }
    }

    static class Shifter
    extends Walker {
        private int where;
        private int gap;
        private boolean exclusive;

        public Shifter(StackMap smt, int where, int gap, boolean exclusive) {
            super(smt);
            this.where = where;
            this.gap = gap;
            this.exclusive = exclusive;
        }

        @Override
        public int locals(int pos, int offset, int num) {
            if (this.exclusive ? this.where <= offset : this.where < offset) {
                ByteArray.write16bit(offset + this.gap, this.info, pos - 4);
            }
            return super.locals(pos, offset, num);
        }

        @Override
        public void uninitialized(int pos, int offset) {
            if (this.where <= offset) {
                ByteArray.write16bit(offset + this.gap, this.info, pos + 1);
            }
        }
    }

    static class Copier
    extends Walker {
        byte[] dest;
        ConstPool srcCp;
        ConstPool destCp;
        Map<String, String> classnames;

        Copier(StackMap map, ConstPool newCp, Map<String, String> classnames) {
            super(map);
            this.srcCp = map.getConstPool();
            this.dest = new byte[this.info.length];
            this.destCp = newCp;
            this.classnames = classnames;
        }

        @Override
        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            ByteArray.write16bit(num, this.dest, 0);
            super.visit();
        }

        @Override
        public int locals(int pos, int offset, int num) {
            ByteArray.write16bit(offset, this.dest, pos - 4);
            return super.locals(pos, offset, num);
        }

        @Override
        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            ByteArray.write16bit(num, this.dest, pos - 2);
            return super.typeInfoArray(pos, offset, num, isLocals);
        }

        @Override
        public void typeInfo(int pos, byte tag) {
            this.dest[pos] = tag;
        }

        @Override
        public void objectVariable(int pos, int clazz) {
            this.dest[pos] = 7;
            int newClazz = this.srcCp.copy(clazz, this.destCp, this.classnames);
            ByteArray.write16bit(newClazz, this.dest, pos + 1);
        }

        @Override
        public void uninitialized(int pos, int offset) {
            this.dest[pos] = 8;
            ByteArray.write16bit(offset, this.dest, pos + 1);
        }

        public StackMap getStackMap() {
            return new StackMap(this.destCp, this.dest);
        }
    }

    public static class Walker {
        byte[] info;

        public Walker(StackMap sm) {
            this.info = sm.get();
        }

        public void visit() {
            int num = ByteArray.readU16bit(this.info, 0);
            int pos = 2;
            for (int i = 0; i < num; ++i) {
                int offset = ByteArray.readU16bit(this.info, pos);
                int numLoc = ByteArray.readU16bit(this.info, pos + 2);
                pos = this.locals(pos + 4, offset, numLoc);
                int numStack = ByteArray.readU16bit(this.info, pos);
                pos = this.stack(pos + 2, offset, numStack);
            }
        }

        public int locals(int pos, int offset, int num) {
            return this.typeInfoArray(pos, offset, num, true);
        }

        public int stack(int pos, int offset, int num) {
            return this.typeInfoArray(pos, offset, num, false);
        }

        public int typeInfoArray(int pos, int offset, int num, boolean isLocals) {
            for (int k = 0; k < num; ++k) {
                pos = this.typeInfoArray2(k, pos);
            }
            return pos;
        }

        int typeInfoArray2(int k, int pos) {
            byte tag = this.info[pos];
            if (tag == 7) {
                int clazz = ByteArray.readU16bit(this.info, pos + 1);
                this.objectVariable(pos, clazz);
                pos += 3;
            } else if (tag == 8) {
                int offsetOfNew = ByteArray.readU16bit(this.info, pos + 1);
                this.uninitialized(pos, offsetOfNew);
                pos += 3;
            } else {
                this.typeInfo(pos, tag);
                ++pos;
            }
            return pos;
        }

        public void typeInfo(int pos, byte tag) {
        }

        public void objectVariable(int pos, int clazz) {
        }

        public void uninitialized(int pos, int offset) {
        }
    }
}

