/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.service.tool.ToolExecutor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ToolServiceContext {
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final Set<String> immediateReturnTools;

    public ToolServiceContext(Builder builder) {
        this.toolSpecifications = Utils.copy(builder.toolSpecifications);
        this.toolExecutors = Utils.copy(builder.toolExecutors);
        this.immediateReturnTools = Utils.copy(builder.immediateReturnTools);
    }

    public ToolServiceContext(List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors) {
        this.toolSpecifications = Utils.copy(toolSpecifications);
        this.toolExecutors = Utils.copy(toolExecutors);
        this.immediateReturnTools = Set.of();
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public Set<String> immediateReturnTools() {
        return this.immediateReturnTools;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolServiceContext that = (ToolServiceContext)o;
        return Objects.equals(this.toolSpecifications, that.toolSpecifications) && Objects.equals(this.toolExecutors, that.toolExecutors) && Objects.equals(this.immediateReturnTools, that.immediateReturnTools);
    }

    public int hashCode() {
        return Objects.hash(this.toolSpecifications, this.toolExecutors, this.immediateReturnTools);
    }

    public String toString() {
        return "ToolServiceContext{toolSpecifications=" + String.valueOf(this.toolSpecifications) + ", toolExecutors=" + String.valueOf(this.toolExecutors) + ", immediateReturnTools=" + String.valueOf(this.immediateReturnTools) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ToolSpecification> toolSpecifications;
        private Map<String, ToolExecutor> toolExecutors;
        private Set<String> immediateReturnTools;

        public Builder toolSpecifications(List<ToolSpecification> toolSpecifications) {
            this.toolSpecifications = toolSpecifications;
            return this;
        }

        public Builder toolExecutors(Map<String, ToolExecutor> toolExecutors) {
            this.toolExecutors = toolExecutors;
            return this;
        }

        public Builder immediateReturnTools(Set<String> immediateReturnTools) {
            this.immediateReturnTools = immediateReturnTools;
            return this;
        }

        public ToolServiceContext build() {
            return new ToolServiceContext(this);
        }
    }

    public static class Empty
    extends ToolServiceContext {
        public static final Empty INSTANCE = new Empty();

        private Empty() {
            super(List.of(), Map.of());
        }
    }
}

