/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class ToolExecutionResult {
    private final boolean isError;
    private final Object result;
    private final AtomicReference<String> resultText;
    private final Supplier<String> resultTextSupplier;

    public ToolExecutionResult(Builder builder) {
        this.isError = builder.isError;
        this.result = builder.result;
        if (builder.resultText != null) {
            this.resultText = new AtomicReference<String>(builder.resultText);
            this.resultTextSupplier = null;
        } else if (builder.resultTextSupplier != null) {
            this.resultText = new AtomicReference();
            this.resultTextSupplier = builder.resultTextSupplier;
        } else {
            throw new IllegalArgumentException("Either resultText or resultTextSupplier must be provided");
        }
    }

    public boolean isError() {
        return this.isError;
    }

    public String resultText() {
        return this.resultText.updateAndGet(current -> current != null ? current : (this.resultTextSupplier != null ? this.resultTextSupplier.get() : null));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ToolExecutionResult that = (ToolExecutionResult)object;
        return this.isError == that.isError && Objects.equals(this.result, that.result) && Objects.equals(this.resultText(), that.resultText());
    }

    public int hashCode() {
        return Objects.hash(this.isError, this.result, this.resultText());
    }

    public String toString() {
        return "ToolExecutionResult{isError=" + this.isError + ", result=" + String.valueOf(this.result) + ", resultText='" + this.resultText() + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean isError;
        private Object result;
        private String resultText;
        private Supplier<String> resultTextSupplier;

        public Builder isError(boolean isError) {
            this.isError = isError;
            return this;
        }

        public Builder result(Object result) {
            this.result = result;
            return this;
        }

        public Builder resultText(String resultText) {
            this.resultText = resultText;
            this.resultTextSupplier = null;
            return this;
        }

        public Builder resultTextSupplier(Supplier<String> resultTextSupplier) {
            this.resultTextSupplier = resultTextSupplier;
            this.resultText = null;
            return this;
        }

        public ToolExecutionResult build() {
            return new ToolExecutionResult(this);
        }
    }
}

