/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.guardrail;

import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.guardrail.InputGuardrailRequest;
import dev.langchain4j.guardrail.InputGuardrailResult;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.guardrail.OutputGuardrailResult;
import dev.langchain4j.service.guardrail.GuardrailServiceBuilder;
import dev.langchain4j.service.guardrail.spi.GuardrailServiceBuilderFactory;
import java.util.ServiceLoader;

public interface GuardrailService {
    public <MethodKey> InputGuardrailResult executeInputGuardrails(MethodKey var1, InputGuardrailRequest var2);

    default public <MethodKey> UserMessage executeGuardrails(MethodKey method, InputGuardrailRequest request) {
        return this.executeInputGuardrails(method, request).userMessage(request);
    }

    public <MethodKey> OutputGuardrailResult executeOutputGuardrails(MethodKey var1, OutputGuardrailRequest var2);

    public <MethodKey> boolean hasInputGuardrails(MethodKey var1);

    public <MethodKey> boolean hasOutputGuardrails(MethodKey var1);

    default public <MethodKey, T> T executeGuardrails(MethodKey method, OutputGuardrailRequest request) {
        return this.executeOutputGuardrails(method, request).response(request);
    }

    public static Builder builder(Class<?> aiServiceClass) {
        return ServiceLoader.load(GuardrailServiceBuilderFactory.class).findFirst().map(builderFactory -> builderFactory.getBuilder(aiServiceClass)).orElseGet(() -> new GuardrailServiceBuilder(aiServiceClass));
    }

    public static interface Builder {
        public GuardrailService build();
    }
}

