/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.moderation.Moderation;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.DefaultAiServices;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.ModerationException;
import dev.langchain4j.spi.ServiceHelper;
import dev.langchain4j.spi.services.AiServicesFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class AiServices<T> {
    protected final AiServiceContext context;
    private boolean contentRetrieverSet = false;
    private boolean retrievalAugmentorSet = false;

    protected AiServices(AiServiceContext context) {
        this.context = context;
    }

    public static <T> AiServices<T> builder(Class<T> aiService) {
        AiServiceContext context = AiServiceContext.create(aiService);
        return AiServices.builder(context);
    }

    public static <T> AiServices<T> builder(AiServiceContext context) {
        return FactoryHolder.aiServicesFactory != null ? FactoryHolder.aiServicesFactory.create(context) : new DefaultAiServices(context);
    }

    public AiServices<T> chatModel(ChatModel chatModel) {
        this.context.chatModel = chatModel;
        return this;
    }

    public AiServices<T> systemMessage(String systemMessage) {
        return this.systemMessageProvider(ignore -> systemMessage);
    }

    public AiServices<T> systemMessageProvider(Function<Object, String> systemMessageProvider) {
        this.context.systemMessageProvider = systemMessageProvider.andThen(Optional::ofNullable);
        return this;
    }

    public AiServices<T> tools(Object ... objectsWithTools) {
        return this.tools(Arrays.asList(objectsWithTools));
    }

    public AiServices<T> tools(Collection<Object> objectsWithTools) {
        this.context.toolService.tools(objectsWithTools);
        return this;
    }

    public abstract T build();

    protected void performBasicValidation() {
        if (this.context.chatModel == null && this.context.streamingChatModel == null) {
            throw IllegalConfigurationException.illegalConfiguration("Please specify either chatModel or streamingChatModel");
        }
    }

    public static List<ChatMessage> removeToolMessages(List<ChatMessage> messages) {
        return messages.stream().filter(it -> !(it instanceof ToolExecutionResultMessage)).filter(it -> !(it instanceof AiMessage) || !((AiMessage)it).hasToolExecutionRequests()).collect(Collectors.toList());
    }

    public static void verifyModerationIfNeeded(Future<Moderation> moderationFuture) {
        if (moderationFuture != null) {
            try {
                Moderation moderation = moderationFuture.get();
                if (moderation.flagged()) {
                    throw new ModerationException(String.format("Text \"%s\" violates content policy", moderation.flaggedText()), moderation);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FactoryHolder {
        private static final AiServicesFactory aiServicesFactory = ServiceHelper.loadFactory(AiServicesFactory.class);
    }
}

