/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;
import java.util.List;
import java.util.Objects;

public class Metadata {
    private final ChatMessage chatMessage;
    private final SystemMessage systemMessage;
    private final List<ChatMessage> chatMemory;
    private final InvocationContext invocationContext;

    public Metadata(Builder builder) {
        this.chatMessage = ValidationUtils.ensureNotNull(builder.chatMessage, "chatMessage");
        this.systemMessage = builder.systemMessage;
        this.chatMemory = Utils.copy(builder.chatMemory);
        this.invocationContext = ValidationUtils.ensureNotNull(builder.invocationContext, "invocationContext");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata that = (Metadata)o;
        return Objects.equals(this.chatMessage, that.chatMessage) && Objects.equals(this.systemMessage, that.systemMessage) && Objects.equals(this.chatMemory, that.chatMemory) && Objects.equals(this.invocationContext, that.invocationContext);
    }

    public int hashCode() {
        return Objects.hash(this.chatMessage, this.systemMessage, this.chatMemory, this.invocationContext);
    }

    public String toString() {
        return "Metadata { chatMessage = " + String.valueOf(this.chatMessage) + ", systemMessage = " + String.valueOf(this.systemMessage) + ", chatMemory = " + String.valueOf(this.chatMemory) + ", invocationContext = " + String.valueOf(this.invocationContext) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ChatMessage chatMessage;
        private SystemMessage systemMessage;
        private List<ChatMessage> chatMemory;
        private InvocationContext invocationContext;

        public Builder chatMessage(ChatMessage chatMessage) {
            this.chatMessage = chatMessage;
            return this;
        }

        public Builder systemMessage(SystemMessage systemMessage) {
            this.systemMessage = systemMessage;
            return this;
        }

        public Builder chatMemory(List<ChatMessage> chatMemory) {
            this.chatMemory = chatMemory;
            return this;
        }

        public Builder invocationContext(InvocationContext invocationContext) {
            this.invocationContext = invocationContext;
            return this;
        }

        public Metadata build() {
            return new Metadata(this);
        }
    }
}

