/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.observability.api;

import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.observability.api.AiServiceListenerRegistrar;
import dev.langchain4j.observability.api.event.AiServiceEvent;
import dev.langchain4j.observability.api.listener.AiServiceListener;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAiServiceListenerRegistrar
implements AiServiceListenerRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAiServiceListenerRegistrar.class);
    private final Map<Class<? extends AiServiceEvent>, EventListeners<? extends AiServiceEvent>> listeners = new ConcurrentHashMap<Class<? extends AiServiceEvent>, EventListeners<? extends AiServiceEvent>>();
    private final AtomicBoolean shouldThrowExceptionOnEventError = new AtomicBoolean(false);

    @Override
    public <T extends AiServiceEvent> void fireEvent(T event) {
        ValidationUtils.ensureNotNull(event, "event");
        Optional.ofNullable(this.listeners.get(event.eventClass())).map(l -> l).ifPresent(l -> l.fireEvent(event));
    }

    @Override
    public void shouldThrowExceptionOnEventError(boolean shouldThrowExceptionOnEventError) {
        this.shouldThrowExceptionOnEventError.compareAndSet(!shouldThrowExceptionOnEventError, shouldThrowExceptionOnEventError);
    }

    private class EventListeners<T extends AiServiceEvent> {
        private final Set<AiServiceListener<T>> listeners;
        private final ReadWriteLock lock;
        final /* synthetic */ DefaultAiServiceListenerRegistrar this$0;

        private void fireEvent(T event) {
            ValidationUtils.ensureNotNull(event, "event");
            Lock readLock = this.lock.readLock();
            readLock.lock();
            try {
                this.listeners.forEach(listener -> {
                    block2: {
                        try {
                            listener.onEvent(event);
                        }
                        catch (Exception e) {
                            LOG.warn("An error occurred while firing event (%s) to listener (%s): %s".formatted(event.getClass().getName(), listener.getClass().getName(), e.getMessage()), e);
                            if (!this.this$0.shouldThrowExceptionOnEventError.get()) break block2;
                            throw e;
                        }
                    }
                });
            }
            finally {
                readLock.unlock();
            }
        }
    }
}

