/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.jlama;

import dev.langchain4j.exception.InternalServerException;
import dev.langchain4j.internal.ExceptionMapper;
import java.io.IOException;

class JlamaExceptionMapper
extends ExceptionMapper.DefaultExceptionMapper {
    static final JlamaExceptionMapper INSTANCE = new JlamaExceptionMapper();

    private JlamaExceptionMapper() {
    }

    @Override
    public RuntimeException mapException(Throwable t) {
        if (t instanceof IOException && t.getMessage().startsWith("HTTP response code: ")) {
            String httpStatusCode = t.getMessage().substring("HTTP response code: ".length(), "HTTP response code: ".length() + 3);
            try {
                return this.mapHttpStatusCode(t, Integer.parseInt(httpStatusCode));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new InternalServerException(t);
    }
}

